/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import com.entwinemedia.fn.data.Opt;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.subtitleparser.SubtitleParsingException;
import org.opencastproject.subtitleparser.webvttparser.WebVTTParser;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitle;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitleCue;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Processes a WebVTT subtitle document into CutMarks for the editor", "workflow.operation=webvtt-to-cutmarks"})
public class WebvttToCutMarksWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(WebvttToCutMarksWorkflowOperationHandler.class);
    private static final String CFGK_MIN_TIME_SILENCE_IN_MS = "min-time-silence-in-ms";
    private static final String CFGK_MIN_TIME_SILENCE_IN_MS_DEFAULT = "0";
    private static final String CFGK_BUFFER_AROUND_SUBTITLE_IN_MS = "buffer-time-around-subtitle";
    private static final String CFGK_BUFFER_AROUND_SUBTITLE_IN_MS_DEFAULT = "0";
    private static final String CFGK_TRACK_FLAVOR = "track-flavor";
    private static final String CFGK_MIN_TIME_SILENCE_TREATMENT_START = "start-treatment";
    private static final String CFGK_MIN_TIME_SILENCE_TREATMENT_START_DEFAULT = "IGNORE";
    private static final String CFGK_MIN_TIME_SILENCE_TREATMENT_END = "end-treatment";
    private static final String CFGK_MIN_TIME_SILENCE_TREATMENT_END_DEFAULT = "IGNORE";
    private static final String TARGET_FILENAME = "cut-marks.json";
    private static final Gson gson = new Gson();
    private Workspace workspace;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mp = workflowInstance.getMediaPackage();
        logger.debug("Start WebVTT to CutMarks operation for mediapackage {}", (Object)mp.getIdentifier().toString());
        WFConfiguration config = this.readConfiguration(workflowInstance);
        WebVTTSubtitle webvtt = this.readAndParseWebVTT(mp, config.sourceFlavor);
        Opt<Long> trackDuration = this.getTrackDuration(mp, config.trackFlavor);
        List<Times> cutMarks = this.processWebVTTIntoCutPoints(webvtt, config.minTimeSilenceInMS, config.bufferTime, trackDuration, config.treatmentStart, config.treatmentEnd);
        this.saveCutMarks(mp, cutMarks, config.targetFlavor);
        return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
    }

    private WFConfiguration readConfiguration(WorkflowInstance workflowInstance) throws WorkflowOperationException {
        Treatment treatmentEnd;
        Treatment treatmentStart;
        long bufferTime;
        long minTimeSilenceInMS;
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one);
        MediaPackageElementFlavor sourceFlavor = tagsAndFlavors.getSingleSrcFlavor();
        MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
        try {
            minTimeSilenceInMS = Long.parseLong(this.getConfig(workflowInstance, CFGK_MIN_TIME_SILENCE_IN_MS, "0"));
            bufferTime = Long.parseLong(this.getConfig(workflowInstance, CFGK_BUFFER_AROUND_SUBTITLE_IN_MS, "0"));
            if (minTimeSilenceInMS < 0L || bufferTime < 0L) {
                throw new NumberFormatException("Negative Integer, must be positive");
            }
        }
        catch (NumberFormatException error) {
            throw new WorkflowOperationException("min-time-silence-in-ms and buffer-time-around-subtitlemust be a postive integer", (Throwable)error);
        }
        if (minTimeSilenceInMS < 2L * bufferTime) {
            throw new WorkflowOperationException("min-time-silence-in-ms must be at least double the value of buffer-time-around-subtitle");
        }
        Opt trackFlavor = this.getOptConfig(workflowInstance, CFGK_TRACK_FLAVOR);
        String treatmentStrStart = this.getConfig(workflowInstance, CFGK_MIN_TIME_SILENCE_TREATMENT_START, "IGNORE");
        String treatmentStrEnd = this.getConfig(workflowInstance, CFGK_MIN_TIME_SILENCE_TREATMENT_END, "IGNORE");
        try {
            treatmentStart = Treatment.valueOf(treatmentStrStart);
            treatmentEnd = Treatment.valueOf(treatmentStrEnd);
        }
        catch (IllegalArgumentException error) {
            throw new WorkflowOperationException("start-treatment and end-treatment must be one of the values IGNORE, USE_FOR_MIN_TIME, ALWAYS_INCLUDE", (Throwable)error);
        }
        if (treatmentEnd != Treatment.IGNORE && trackFlavor.isEmpty()) {
            throw new WorkflowOperationException("track-flavor is not defined, but end-treatment is not set to IGNORE, therefore a track-flavor is needed");
        }
        WFConfiguration config = new WFConfiguration();
        config.minTimeSilenceInMS = minTimeSilenceInMS;
        config.bufferTime = bufferTime;
        config.sourceFlavor = sourceFlavor;
        config.targetFlavor = targetFlavor;
        config.trackFlavor = trackFlavor;
        config.treatmentStart = treatmentStart;
        config.treatmentEnd = treatmentEnd;
        return config;
    }

    private List<Times> processWebVTTIntoCutPoints(WebVTTSubtitle webvtt, long minTimeSilenceInMS, long bufferTime, Opt<Long> trackDuration, Treatment treatmentStart, Treatment treatmentEnd) {
        ArrayList<Times> cutMarks = new ArrayList<Times>();
        List cues = webvtt.getCues();
        if (cues.size() > 0) {
            WebVTTSubtitleCue firstCue = (WebVTTSubtitleCue)cues.remove(0);
            long oldMarkStart = firstCue.getStartTime();
            long oldMarkEnd = firstCue.getEndTime();
            for (WebVTTSubtitleCue cue : webvtt.getCues()) {
                long newMarkStart = cue.getStartTime();
                long newMarkEnd = cue.getEndTime();
                if (newMarkStart - oldMarkEnd > minTimeSilenceInMS) {
                    Times oldMark = new Times();
                    oldMark.begin = oldMarkStart - bufferTime;
                    oldMark.duration = oldMarkEnd - oldMark.begin + bufferTime;
                    cutMarks.add(oldMark);
                    oldMarkStart = newMarkStart;
                    oldMarkEnd = newMarkEnd;
                    continue;
                }
                if (newMarkEnd <= oldMarkEnd) continue;
                oldMarkEnd = newMarkEnd;
            }
            Times lastMark = new Times();
            lastMark.begin = oldMarkStart - bufferTime;
            lastMark.duration = oldMarkEnd - lastMark.begin + bufferTime;
            cutMarks.add(lastMark);
            Times firstCutMark = (Times)cutMarks.get(0);
            if (treatmentStart == Treatment.ALWAYS_INCLUDE) {
                this.updateTimesBegin(firstCutMark, 0L);
            } else if (treatmentStart == Treatment.USE_FOR_MIN_TIME) {
                if (firstCutMark.begin + bufferTime - 0L <= minTimeSilenceInMS) {
                    this.updateTimesBegin(firstCutMark, 0L);
                }
            } else if (treatmentStart == Treatment.IGNORE && firstCutMark.begin < 0L) {
                this.updateTimesBegin(firstCutMark, 0L);
            }
            if (trackDuration.isDefined()) {
                long trackDur = (Long)trackDuration.get();
                Times lastCutMark = (Times)cutMarks.get(cutMarks.size() - 1);
                if (treatmentEnd == Treatment.ALWAYS_INCLUDE) {
                    this.updateTimesEnd(lastCutMark, trackDur);
                } else if (treatmentEnd == Treatment.USE_FOR_MIN_TIME) {
                    if (trackDur - (lastCutMark.begin + lastCutMark.duration - bufferTime) <= minTimeSilenceInMS) {
                        this.updateTimesEnd(lastCutMark, trackDur);
                    }
                } else if (treatmentEnd == Treatment.IGNORE && lastCutMark.begin + lastCutMark.duration > trackDur) {
                    this.updateTimesEnd(lastCutMark, trackDur);
                }
            }
        }
        return cutMarks;
    }

    private void updateTimesBegin(Times toUpdate, long newBegin) {
        Long end = toUpdate.begin + toUpdate.duration;
        toUpdate.begin = newBegin;
        toUpdate.duration = end - newBegin;
    }

    private void updateTimesEnd(Times toUpdate, long newEnd) {
        toUpdate.duration = newEnd - toUpdate.begin;
    }

    private void saveCutMarks(MediaPackage mp, List<Times> cutMarks, MediaPackageElementFlavor targetFlavor) throws WorkflowOperationException {
        String jsonCutMarks = gson.toJson(cutMarks);
        try {
            InputStream cutMarksOut = IOUtils.toInputStream((String)jsonCutMarks, (Charset)StandardCharsets.UTF_8);
            MediaPackageElementBuilder mpeBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            MediaPackageElement mpe = mpeBuilder.newElement(MediaPackageElement.Type.Attachment, targetFlavor);
            mpe.setIdentifier(UUID.randomUUID().toString());
            URI cutMarksURI = this.workspace.put(mp.getIdentifier().toString(), mpe.getIdentifier(), TARGET_FILENAME, cutMarksOut);
            mpe.setURI(cutMarksURI);
            mp.add(mpe);
        }
        catch (IOException e) {
            throw new WorkflowOperationException("Couldn't write resulting cutMarks");
        }
    }

    private WebVTTSubtitle readAndParseWebVTT(MediaPackage mp, MediaPackageElementFlavor sourceFlavor) throws WorkflowOperationException {
        WebVTTSubtitle webvtt;
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        elementSelector.addFlavor(sourceFlavor);
        Collection elements = elementSelector.select(mp, false);
        MediaPackageElement[] webvttElements = elements.toArray(new MediaPackageElement[elements.size()]);
        if (webvttElements.length != 1) {
            throw new WorkflowOperationException("Couldn't uniqly identify WebVTT Element");
        }
        URI webvttURI = webvttElements[0].getURI();
        InputStream webvttIS = null;
        try {
            webvttIS = this.workspace.read(webvttURI);
            WebVTTParser wvparser = new WebVTTParser();
            webvtt = wvparser.parse(webvttIS);
        }
        catch (IOException | NullPointerException | NotFoundException e) {
            throw new WorkflowOperationException("Couldn't open WebVTT file for parsing", e);
        }
        catch (SubtitleParsingException e) {
            throw new WorkflowOperationException("Failed to parse WebVTT File", (Throwable)e);
        }
        finally {
            try {
                if (webvttIS != null) {
                    webvttIS.close();
                } else {
                    logger.debug("WebVTT InputStream is null (mediapackage {})", (Object)mp.getIdentifier().toString());
                }
            }
            catch (IOException e) {
                logger.warn("Couldn't close '{}' properly (mediapackage {})", (Object)webvttURI.toString(), (Object)mp.getIdentifier().toString());
            }
        }
        return webvtt;
    }

    private Opt<Long> getTrackDuration(MediaPackage mp, Opt<String> trackFlavor) throws WorkflowOperationException {
        if (trackFlavor.isDefined()) {
            Track[] tracks;
            String flavor = (String)trackFlavor.get();
            try {
                tracks = mp.getTracks(MediaPackageElementFlavor.parseFlavor((String)flavor));
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Couldn't parse track-flavor", (Throwable)e);
            }
            if (tracks.length != 1) {
                throw new WorkflowOperationException("Multiple tracks or no track found with flavor '" + flavor + "' in mediapackage '" + mp.getIdentifier().toString() + "', exactly one needed");
            }
            return Opt.nul((Object)tracks[0].getDuration());
        }
        return Opt.none();
    }

    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Registering webvtt-to-cutmarks workflow operation handler");
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    private static enum Treatment {
        IGNORE,
        USE_FOR_MIN_TIME,
        ALWAYS_INCLUDE;

    }

    private static class Times {
        private Long begin;
        private Long duration;

        private Times() {
        }
    }

    private static class WFConfiguration {
        protected long minTimeSilenceInMS;
        protected long bufferTime;
        protected MediaPackageElementFlavor sourceFlavor;
        protected MediaPackageElementFlavor targetFlavor;
        protected Opt<String> trackFlavor;
        protected Treatment treatmentStart;
        protected Treatment treatmentEnd;

        private WFConfiguration() {
        }
    }
}

