/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.workflow.api.RetryStrategy;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationAbortedException;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.workflow.ResumableWorkflowOperationHandlerBase;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResolutionWorkflowOperationHandler
extends ResumableWorkflowOperationHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(ErrorResolutionWorkflowOperationHandler.class);
    private static final String HOLD_UI_PATH = "/ui/operation/retry-strategy/index.html";
    private static final String OPT_STRATEGY = "retryStrategy";

    @Override
    public void activate(ComponentContext componentContext) {
        super.activate(componentContext);
        this.setHoldActionTitle("Select retry strategy");
        this.registerHoldStateUserInterface(HOLD_UI_PATH);
        logger.info("Registering retry strategy failover hold state ui from classpath {}", (Object)HOLD_UI_PATH);
    }

    @Override
    public WorkflowOperationResult resume(WorkflowInstance workflowInstance, JobContext context, Map<String, String> properties) throws WorkflowOperationException {
        String strategyValue = properties.get(OPT_STRATEGY);
        if (StringUtils.isBlank((CharSequence)strategyValue)) {
            logger.warn("No retry strategy submitted for workflow '{}', holding again", (Object)workflowInstance);
            return this.createResult(null, properties, WorkflowOperationResult.Action.PAUSE, 0L);
        }
        try {
            RetryStrategy s = RetryStrategy.valueOf((String)strategyValue);
            switch (s) {
                case NONE: {
                    logger.info("Error resolution 'fail' was triggered for workflow '{}'", (Object)workflowInstance);
                    throw new WorkflowOperationAbortedException("Workflow " + workflowInstance + " was failed by user");
                }
                case RETRY: {
                    logger.info("Error resolution 'retry' was triggered for workflow '{}'", (Object)workflowInstance);
                    return this.createResult(null, properties, WorkflowOperationResult.Action.CONTINUE, 0L);
                }
            }
            logger.warn("Unknown retry strategy '{}' submitted for workflow '{}'", (Object)strategyValue, (Object)workflowInstance);
            return this.createResult(null, properties, WorkflowOperationResult.Action.PAUSE, 0L);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unknown retry strategy '{}' submitted for workflow '{}'", (Object)strategyValue, (Object)workflowInstance);
            return this.createResult(null, properties, WorkflowOperationResult.Action.PAUSE, 0L);
        }
    }
}

