/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.workflow.ResumableWorkflowOperationHandlerBase;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagByDublinCoreTermWOH
extends ResumableWorkflowOperationHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(TagByDublinCoreTermWOH.class);
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    public static final String SOURCE_FLAVORS_PROPERTY = "source-flavors";
    public static final String SOURCE_TAGS_PROPERTY = "source-tags";
    public static final String TARGET_FLAVOR_PROPERTY = "target-flavor";
    public static final String TARGET_TAGS_PROPERTY = "target-tags";
    public static final String DCCATALOG_PROPERTY = "dccatalog";
    public static final String DCTERM_PROPERTY = "dcterm";
    public static final String DEFAULT_VALUE_PROPERTY = "default-value";
    public static final String MATCH_VALUE_PROPERTY = "match-value";
    public static final String COPY_PROPERTY = "copy";
    private Workspace workspace = null;

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        String configuredSourceFlavors = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(SOURCE_FLAVORS_PROPERTY));
        String configuredSourceTags = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(SOURCE_TAGS_PROPERTY));
        String configuredCatalog = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(DCCATALOG_PROPERTY));
        String configuredDCTerm = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(DCTERM_PROPERTY));
        String configuredDefaultValue = StringUtils.trimToNull((String)currentOperation.getConfiguration(DEFAULT_VALUE_PROPERTY));
        String configuredMatchValue = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(MATCH_VALUE_PROPERTY));
        String configuredTargetFlavor = StringUtils.trimToNull((String)currentOperation.getConfiguration(TARGET_FLAVOR_PROPERTY));
        String configuredTargetTags = StringUtils.trimToEmpty((String)currentOperation.getConfiguration(TARGET_TAGS_PROPERTY));
        boolean copy = BooleanUtils.toBoolean((String)currentOperation.getConfiguration(COPY_PROPERTY));
        String[] sourceTags = StringUtils.split((String)configuredSourceTags, (String)",");
        String[] targetTags = StringUtils.split((String)configuredTargetTags, (String)",");
        String[] sourceFlavors = StringUtils.split((String)configuredSourceFlavors, (String)",");
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        for (String string : sourceFlavors) {
            elementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)string));
        }
        for (String string : sourceTags) {
            elementSelector.addTag(string);
        }
        ArrayList<String> removeTags = new ArrayList<String>();
        ArrayList<String> addTags = new ArrayList<String>();
        ArrayList<String> overrideTags = new ArrayList<String>();
        for (String string : targetTags) {
            if (string.startsWith(MINUS)) {
                removeTags.add(string);
                continue;
            }
            if (string.startsWith(PLUS)) {
                addTags.add(string);
                continue;
            }
            overrideTags.add(string);
        }
        Catalog[] catalogArray = mediaPackage.getCatalogs(new MediaPackageElementFlavor("dublincore", StringUtils.lowerCase((String)configuredCatalog)));
        if (catalogArray != null && catalogArray.length > 0) {
            Boolean foundValue = false;
            EName dcterm = new EName("http://purl.org/dc/terms/", configuredDCTerm);
            for (Catalog catalog : catalogArray) {
                DublinCoreCatalog dc = DublinCoreUtil.loadDublinCore((Workspace)this.workspace, (MediaPackageElement)catalog);
                List list = dc.get(dcterm);
                if (list.isEmpty()) {
                    if (configuredDefaultValue == null) continue;
                    foundValue = configuredDefaultValue.equals(configuredMatchValue);
                    continue;
                }
                foundValue = list.contains(DublinCoreValue.mk((String)configuredMatchValue));
            }
            if (foundValue.booleanValue()) {
                if (copy) {
                    logger.info("Retagging mediapackage elements as a copy");
                } else {
                    logger.info("Retagging mediapackage elements");
                }
                Collection collection = elementSelector.select(mediaPackage, false);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    MediaPackageElement e;
                    MediaPackageElement element = e = (MediaPackageElement)iterator.next();
                    if (copy) {
                        element = (MediaPackageElement)e.clone();
                        element.setIdentifier(null);
                        element.setURI(e.getURI());
                    }
                    if (configuredTargetFlavor != null) {
                        element.setFlavor(MediaPackageElementFlavor.parseFlavor((String)configuredTargetFlavor));
                    }
                    if (overrideTags.size() > 0) {
                        element.clearTags();
                        for (String string : overrideTags) {
                            element.addTag(string);
                        }
                    } else {
                        for (String string : removeTags) {
                            element.removeTag(string.substring(MINUS.length()));
                        }
                        for (String string : addTags) {
                            element.addTag(string.substring(PLUS.length()));
                        }
                    }
                    if (!copy) continue;
                    mediaPackage.addDerived(element, e);
                }
            }
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }
}

