/*
 * Decompiled with CFR 0.152.
 */
package com_atlassian_clover;

import com.atlassian.clover.remote.DistributedConfig;
import java.io.Serializable;

public class CloverProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_NAME = "default";
    public static final String DEFAULT_COVERAGE_RECORDER = CoverageRecorderType.FIXED.toString();
    protected String name;
    protected String coverageRecorder;
    protected DistributedConfig distributedCoverage;

    public CloverProfile(String name, CoverageRecorderType coverageRecorder, DistributedConfig distributedCoverage) {
        this.name = name;
        this.setCoverageRecorder(coverageRecorder);
        this.distributedCoverage = distributedCoverage;
    }

    public CloverProfile(String name, String coverageRecorder, String distributedCoverage) {
        this.name = name;
        this.setCoverageRecorder(CoverageRecorderType.valueOf(coverageRecorder));
        this.setDistributedCoverage(distributedCoverage);
    }

    public DistributedConfig getDistributedCoverage() {
        return this.distributedCoverage;
    }

    public CoverageRecorderType getCoverageRecorder() {
        return CoverageRecorderType.valueOf(this.coverageRecorder);
    }

    public String getName() {
        return this.name;
    }

    protected void setCoverageRecorder(CoverageRecorderType coverageRecorder) {
        this.coverageRecorder = coverageRecorder.toString();
    }

    protected void setDistributedCoverage(String distributedCoverage) {
        this.distributedCoverage = distributedCoverage != null ? new DistributedConfig(distributedCoverage) : null;
    }

    public static enum CoverageRecorderType {
        FIXED,
        GROWABLE,
        SHARED;

    }
}

