/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsEvent;
import org.opencms.main.OpenCms;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsRadioSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.cache.Messages;

public class CmsFlexCacheClearDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "flex.clear";
    public static final String[] PAGES = new String[]{"page1"};
    private static final String MODE_ALL = "all";
    private static final String MODE_VARIATIONS = "variations";
    private String m_mode;
    private boolean m_offline;
    private boolean m_online;

    public CmsFlexCacheClearDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsFlexCacheClearDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionClearCaches() throws JspException {
        OpenCms.fireCmsEvent((CmsEvent)new CmsEvent(5, null));
        this.setAction(4);
        this.actionCloseDialog();
    }

    public void actionCommit() {
        try {
            int action = -1;
            action = this.isOnline() && this.isOffline() ? (this.getMode().equals(MODE_ALL) ? 0 : 1) : (this.isOnline() ? (this.getMode().equals(MODE_ALL) ? 2 : 3) : (this.isOffline() ? (this.getMode().equals(MODE_ALL) ? 4 : 5) : (this.getMode().equals(MODE_ALL) ? 0 : 1)));
            OpenCms.fireCmsEvent((CmsEvent)new CmsEvent(9, Collections.singletonMap("action", new Integer(action))));
        }
        catch (Exception e) {
            this.setCommitErrors(Collections.singletonList(e));
        }
    }

    public void actionPurgeJspRepository() throws JspException {
        OpenCms.fireCmsEvent((CmsEvent)new CmsEvent(8, Collections.emptyMap()));
        OpenCms.fireCmsEvent((CmsEvent)new CmsEvent(9, Collections.singletonMap("action", new Integer(1))));
        this.setAction(4);
        this.actionCloseDialog();
    }

    public String getMode() {
        return this.m_mode;
    }

    public boolean isOffline() {
        return this.m_offline;
    }

    public boolean isOnline() {
        return this.m_online;
    }

    public void setMode(String mode) {
        this.m_mode = mode;
    }

    public void setOffline(boolean offline) {
        this.m_offline = offline;
    }

    public void setOnline(boolean online) {
        this.m_online = online;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        int n = 1;
        CmsFlexController controller = (CmsFlexController)this.getJsp().getRequest().getAttribute("org.opencms.flex.CmsFlexController");
        CmsFlexCache cache = controller.getCmsCache();
        if (cache.cacheOffline()) {
            n = 2;
        }
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_FLEXCACHE_LABEL_CLEAN_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, n));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.setKeyPrefix(KEY_PREFIX);
        CmsFlexController controller = (CmsFlexController)this.getJsp().getRequest().getAttribute("org.opencms.flex.CmsFlexController");
        CmsFlexCache cache = controller.getCmsCache();
        this.setOffline(true);
        this.setOnline(true);
        this.setMode(MODE_ALL);
        if (cache.cacheOffline()) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "offline", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "online", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "mode", PAGES[0], (I_CmsWidget)new CmsRadioSelectWidget(this.getModes())));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        super.initWorkplaceMembers(jsp);
        this.setOnlineHelpUriCustom("/cache/flex/clean/");
    }

    private List getModes() {
        ArrayList<CmsSelectWidgetOption> ret = new ArrayList<CmsSelectWidgetOption>();
        ret.add(new CmsSelectWidgetOption(MODE_VARIATIONS, this.getMode().equals(MODE_VARIATIONS), this.key("GUI_FLEXCACHE_CLEAN_MODE_VARIATIONS_0")));
        ret.add(new CmsSelectWidgetOption(MODE_ALL, this.getMode().equals(MODE_ALL), this.key("GUI_FLEXCACHE_CLEAN_MODE_ALL_0")));
        return ret;
    }
}

