/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.cache;

import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.cache.CmsLruCache;
import org.opencms.flex.CmsFlexCache;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.util.CmsFileUtil;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.cache.Messages;

public class CmsFlexCacheOverviewDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "flex.stats";
    public static final String[] PAGES = new String[]{"page1"};
    private String m_avgSize;
    private String m_curSize;
    private String m_keys;
    private String m_maxSize;
    private String m_variations;

    public CmsFlexCacheOverviewDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsFlexCacheOverviewDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        this.setCommitErrors(new ArrayList());
    }

    public String getAvgSize() {
        return this.m_avgSize;
    }

    public String getCurSize() {
        return this.m_curSize;
    }

    public String getKeys() {
        return this.m_keys;
    }

    public String getMaxSize() {
        return this.m_maxSize;
    }

    public String getVariations() {
        return this.m_variations;
    }

    public void setAvgSize(String avgSize) {
        this.m_avgSize = avgSize;
    }

    public void setCurSize(String curSize) {
        this.m_curSize = curSize;
    }

    public void setKeys(String keys) {
        this.m_keys = keys;
    }

    public void setMaxSize(String maxSize) {
        this.m_maxSize = maxSize;
    }

    public void setVariations(String variations) {
        this.m_variations = variations;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_FLEXCACHE_LABEL_STATS_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_FLEXCACHE_LABEL_MEMORY_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(2, 4));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.initCacheObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "keys", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "variations", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "maxSize", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "avgSize", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "curSize", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initCacheObject() {
        CmsFlexController controller = (CmsFlexController)this.getJsp().getRequest().getAttribute("org.opencms.flex.CmsFlexController");
        CmsFlexCache cache = controller.getCmsCache();
        this.setVariations("" + cache.size());
        this.setKeys("" + cache.keySize());
        CmsLruCache entryLruCache = cache.getEntryLruCache();
        if (entryLruCache != null) {
            Locale locale = this.getLocale();
            this.setMaxSize(CmsFileUtil.formatFilesize((long)entryLruCache.getMaxCacheCosts(), (Locale)locale));
            this.setAvgSize(CmsFileUtil.formatFilesize((long)entryLruCache.getAvgCacheCosts(), (Locale)locale));
            this.setCurSize(CmsFileUtil.formatFilesize((long)entryLruCache.getObjectCosts(), (Locale)locale));
        }
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        super.initWorkplaceMembers(jsp);
        this.setOnlineHelpUriCustom("/cache/flex/");
    }
}

