/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.cache;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsEvent;
import org.opencms.main.OpenCms;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.tools.cache.Messages;

public class CmsImageCacheClearDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "image.clear";
    public static final String[] PAGES = new String[]{"page1"};
    private String m_time;

    public CmsImageCacheClearDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsImageCacheClearDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        try {
            float age = (float)(System.currentTimeMillis() - Long.parseLong(this.m_time)) / 3600000.0f;
            OpenCms.fireCmsEvent((CmsEvent)new CmsEvent(5, Collections.singletonMap("_IMAGES_CACHE_", "" + age)));
        }
        catch (Exception e) {
            this.setCommitErrors(Collections.singletonList(e));
        }
    }

    public String getTime() {
        return this.m_time;
    }

    public void setTime(String time) {
        this.m_time = time;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_IMAGECACHE_LABEL_CLEAN_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 0));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.setKeyPrefix(KEY_PREFIX);
        this.setTime("" + (System.currentTimeMillis() - 1800000L));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "time", PAGES[0], (I_CmsWidget)new CmsCalendarWidget()));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        super.initWorkplaceMembers(jsp);
        this.setOnlineHelpUriCustom("/cache/image/clean/");
    }
}

