package org.opencode4workspace.endpoints;

import org.opencode4workspace.WWClient;
import org.opencode4workspace.WWException;
import org.opencode4workspace.graphql.GraphResultContainer;
import org.opencode4workspace.json.GraphQLRequest;

/**
 * @author Paul Withers
 * @since 0.5.0
 * 
 *        Interface for Graph Query endpoints
 *
 */
public interface IWWGraphQLEndpoint {

	/**
	 * @return WWClient passed into constructor
	 * 
	 * @since 0.5.0
	 */
	WWClient getClient();

	/**
	 * @return GraphQLRequest, request details to be passed to the endpoint
	 * 
	 * @since 0.5.0
	 */
	GraphQLRequest getRequest();

	/**
	 * @param request
	 *            GraphQLRequest, request details to be passed to the endpoint
	 * 
	 * @since 0.5.0
	 */
	void setRequest(GraphQLRequest request);

	/**
	 * @return GraphResultContainer generated by a successful {@link #executeRequest()}
	 * 
	 * @since 0.5.0
	 */
	GraphResultContainer getResultContainer();

	/**
	 * @param resultContainer
	 *            GraphResultContainer generated by a successful {@link #executeRequest()}. Should not need overloading, but just in case, this method is still exposed
	 * 
	 * @since 0.5.0
	 */
	void setResultContainer(GraphResultContainer resultContainer);

	/**
	 * Runs the main code to execute the GraphQL request on Watson Work Services. {@link #setRequest(GraphQLRequest)} must be called before calling this method. This method should not need
	 * overloading.
	 * 
	 * @throws WWException
	 *             containing an error message, if the request was unsuccessful
	 * 
	 * @since 0.5.0
	 */
	void executeRequest() throws WWException;

	/**
	 * Parses the ResultContainer to return the relevant Java object of results. This method should be overloaded by any implementation.
	 * 
	 * @return Object containing the contents of the result
	 * @throws WWException
	 *             containing an error message, if the request was unsuccessful
	 * 
	 * @since 0.5.0
	 */
	Object parseResultContainer() throws WWException;

	/**
	 * @return String raw JSON results as String
	 * 
	 * @since 0.5.0
	 */
	public String getResultContent();

	/**
	 * @param resultContent
	 *            String raw JSON results as string
	 * 
	 * @since 0.5.0
	 */
	public void setResultContent(String resultContent);

	/**
	 * @return Boolean whether or not to dump profile data of query and response time
	 * 
	 * @since 0.5.0
	 */
	public Boolean getProfileDump();

	/**
	 * @param profileDump
	 *            Boolean whether or not to dump profile data of query and response time
	 * 
	 * @since 0.5.0
	 */
	public void setProfileDump(Boolean profileDump);

}