/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.maclearner.app.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.opencord.maclearner.app.impl.TestBaseMacLearner;

public class MacLearnerManagerTest
extends TestBaseMacLearner {
    private static final int DELAY = 250;
    private static final int PROCESSING_LENGTH = 500;
    private static final MacAddress CLIENT_MAC = MacAddress.valueOf((String)"00:00:00:00:00:01");
    public static final VlanId CLIENT_VLAN = VlanId.vlanId((String)"100");
    private static final VlanId CLIENT_QINQ_VLAN = VlanId.vlanId((String)"200");
    public static final DeviceId OLT_DEVICE_ID = DeviceId.deviceId((String)"of:0000b86a974385f7");
    public static final PortNumber UNI_PORT = PortNumber.portNumber((long)16L);
    public static final ConnectPoint CLIENT_CP = new ConnectPoint((ElementId)OLT_DEVICE_ID, UNI_PORT);
    public static final DeviceId AGG_DEVICE_ID = DeviceId.deviceId((String)"of:0000000000000001");
    public static final PortNumber AGG_OLT_PORT = PortNumber.portNumber((long)10L);
    public static final PortNumber OLT_NNI_PORT = PortNumber.portNumber((long)0x100000L);
    public static final ConnectPoint NNI_CP = new ConnectPoint((ElementId)OLT_DEVICE_ID, OLT_NNI_PORT);
    public static final String OLT_SERIAL_NUMBER = "BBSIM_OLT_1";
    private static final MacAddress SERVER_MAC = MacAddress.valueOf((String)"00:00:00:00:00:11");

    @Before
    public void setUp() throws IOException {
        this.setUpApp();
    }

    @After
    public void tearDown() {
        this.macLearnerManager.deactivate();
    }

    @Test
    public void testSingleTagDhcpPacket() {
        this.packetService.processPacket((PacketContext)new TestBaseMacLearner.TestDhcpRequestPacketContext(CLIENT_MAC, CLIENT_VLAN, VlanId.NONE, CLIENT_CP));
        TestTools.assertAfter((int)250, (int)500, () -> {
            Optional macAddress = this.macLearnerManager.getMacMapping(CLIENT_CP.deviceId(), CLIENT_CP.port(), CLIENT_VLAN);
            Assert.assertTrue((boolean)macAddress.isPresent());
            Assert.assertEquals((Object)CLIENT_MAC, macAddress.get());
        });
    }

    @Test
    public void testDoubleTagDhcpPacket() {
        this.packetService.processPacket((PacketContext)new TestBaseMacLearner.TestDhcpRequestPacketContext(CLIENT_MAC, CLIENT_VLAN, CLIENT_QINQ_VLAN, CLIENT_CP));
        TestTools.assertAfter((int)250, (int)500, () -> {
            Optional macAddress = this.macLearnerManager.getMacMapping(CLIENT_CP.deviceId(), CLIENT_CP.port(), CLIENT_QINQ_VLAN);
            Assert.assertTrue((boolean)macAddress.isPresent());
            Assert.assertEquals((Object)CLIENT_MAC, macAddress.get());
        });
    }

    @Test
    public void testHostProviding() {
        this.packetService.processPacket((PacketContext)new TestBaseMacLearner.TestDhcpRequestPacketContext(CLIENT_MAC, CLIENT_VLAN, CLIENT_QINQ_VLAN, CLIENT_CP));
        TestTools.assertAfter((int)250, (int)500, () -> {
            HostId hostId = HostId.hostId((MacAddress)CLIENT_MAC, (VlanId)CLIENT_QINQ_VLAN);
            Host host = this.hostService.getHost(hostId);
            Assert.assertNotNull((Object)host);
            Assert.assertEquals((Object)OLT_DEVICE_ID, (Object)host.location().deviceId());
            Assert.assertEquals((Object)UNI_PORT, (Object)host.location().port());
            Optional optAuxLoc = host.auxLocations().stream().findFirst();
            Assert.assertTrue((boolean)optAuxLoc.isPresent());
            Assert.assertEquals((Object)AGG_DEVICE_ID, (Object)((HostLocation)optAuxLoc.get()).deviceId());
            Assert.assertEquals((Object)AGG_OLT_PORT, (Object)((HostLocation)optAuxLoc.get()).port());
        });
    }

    @Test
    public void testDhcpForwardClientRequest() {
        this.macLearnerManager.enableDhcpForward = true;
        TestBaseMacLearner.TestDhcpRequestPacketContext dhcpRequest = new TestBaseMacLearner.TestDhcpRequestPacketContext(CLIENT_MAC, CLIENT_VLAN, VlanId.NONE, CLIENT_CP);
        ByteBuffer inBuffer = dhcpRequest.inPacket().unparsed();
        this.packetService.processPacket((PacketContext)dhcpRequest);
        TestTools.assertAfter((int)250, (int)500, () -> {
            OutboundPacket emittedPacket = this.packetService.emittedPacket;
            ByteBuffer outBuffer = emittedPacket.data();
            DeviceId deviceId = emittedPacket.sendThrough();
            TrafficTreatment treatment = emittedPacket.treatment();
            List instructions = treatment.allInstructions();
            Assert.assertEquals((Object)deviceId, (Object)OLT_DEVICE_ID);
            for (Instruction instruction : instructions) {
                if (!(instruction instanceof Instructions.OutputInstruction)) continue;
                Assert.assertEquals((Object)OLT_NNI_PORT, (Object)((Instructions.OutputInstruction)instruction).port());
            }
            Assert.assertEquals((long)0L, (long)inBuffer.compareTo(outBuffer));
        });
    }

    @Test
    public void testDhcpForwardServerResponse() {
        this.macLearnerManager.enableDhcpForward = true;
        this.testDhcpForwardClientRequest();
        TestBaseMacLearner.TestDhcpResponsePacketContext dhcpResponse = new TestBaseMacLearner.TestDhcpResponsePacketContext(CLIENT_MAC, SERVER_MAC, CLIENT_VLAN, VlanId.NONE, NNI_CP);
        ByteBuffer inBuffer = dhcpResponse.inPacket().unparsed();
        this.packetService.processPacket((PacketContext)dhcpResponse);
        TestTools.assertAfter((int)250, (int)500, () -> {
            OutboundPacket emittedPacket = this.packetService.emittedPacket;
            ByteBuffer outBuffer = emittedPacket.data();
            DeviceId deviceId = emittedPacket.sendThrough();
            TrafficTreatment treatment = emittedPacket.treatment();
            List instructions = treatment.allInstructions();
            Assert.assertEquals((Object)deviceId, (Object)OLT_DEVICE_ID);
            for (Instruction instruction : instructions) {
                if (!(instruction instanceof Instructions.OutputInstruction)) continue;
                Assert.assertEquals((Object)UNI_PORT, (Object)((Instructions.OutputInstruction)instruction).port());
            }
            Assert.assertEquals((long)0L, (long)inBuffer.compareTo(outBuffer));
        });
    }
}

