/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.maclearner.app.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.onlab.junit.TestUtils;
import org.onlab.packet.ChassisId;
import org.onlab.packet.DHCP;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.UDP;
import org.onlab.packet.VlanId;
import org.onlab.packet.dhcp.DhcpOption;
import org.onosproject.cfg.ComponentConfigAdapter;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.ClusterServiceAdapter;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.event.DefaultEventSinkRegistry;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventSink;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.basics.HostLearningConfig;
import org.onosproject.net.config.basics.HostLearningConfigTest;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostProvider;
import org.onosproject.net.host.HostProviderService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketContextAdapter;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketServiceAdapter;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyServiceAdapter;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapAdapter;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetAdapter;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.store.service.StorageServiceAdapter;
import org.onosproject.store.service.Versioned;
import org.opencord.maclearner.app.impl.MacLearnerHostProvider;
import org.opencord.maclearner.app.impl.MacLearnerManager;
import org.opencord.maclearner.app.impl.MacLearnerManagerTest;
import org.opencord.sadis.BandwidthProfileInformation;
import org.opencord.sadis.BaseInformationService;
import org.opencord.sadis.SadisService;
import org.opencord.sadis.SubscriberAndDeviceInformation;

public abstract class TestBaseMacLearner {
    protected static final String C1 = "C1";
    protected static final String C2 = "C2";
    protected static final String C3 = "C3";
    protected static final NodeId CNID_1 = NodeId.nodeId((String)"C1");
    protected static final NodeId CNID_2 = NodeId.nodeId((String)"C2");
    protected static final NodeId CNID_3 = NodeId.nodeId((String)"C3");
    protected static final ControllerNode CNODE_1 = new DefaultControllerNode(CNID_1, "10.0.0.1");
    protected static final ControllerNode CNODE_2 = new DefaultControllerNode(CNID_2, "10.0.0.2");
    protected static final ControllerNode CNODE_3 = new DefaultControllerNode(CNID_3, "10.0.0.3");
    private static final Ip4Address SERVER_IP = Ip4Address.valueOf((String)"10.0.3.253");
    private static final Ip4Address INTERFACE_IP = Ip4Address.valueOf((String)"10.0.3.254");
    protected MacLearnerManager macLearnerManager;
    protected ApplicationId appId;
    protected HostLearningConfig hostLearningConfig;
    protected ComponentConfigService componentConfigService = new MockComponentConfigService();
    protected MockCoreService coreService = new MockCoreService();
    protected MockStorageService storageService = new MockStorageService();
    protected MockPacketService packetService = new MockPacketService();
    protected MockClusterService clusterService = new MockClusterService();
    protected MockDeviceService deviceService = new MockDeviceService();
    protected MockTopologyService topologyService = new MockTopologyService();
    protected MockLinkService linkService = new MockLinkService();
    protected MacLearnerHostProvider macLearnerHostProvider = new MacLearnerHostProvider();
    protected MockHostService hostService = new MockHostService(Sets.newHashSet());
    protected MockSadisService sadisService = new MockSadisService();

    public void setUpApp() throws IOException {
        this.macLearnerManager = new MacLearnerManager();
        this.macLearnerManager.componentConfigService = this.componentConfigService;
        this.macLearnerManager.coreService = this.coreService;
        this.macLearnerManager.storageService = this.storageService;
        this.macLearnerManager.packetService = this.packetService;
        this.macLearnerManager.clusterService = this.clusterService;
        this.macLearnerManager.deviceService = this.deviceService;
        this.macLearnerManager.topologyService = this.topologyService;
        this.macLearnerManager.linkService = this.linkService;
        this.macLearnerManager.sadisService = this.sadisService;
        this.macLearnerManager.hostService = this.hostService;
        this.hostLearningConfig = new HostLearningConfig();
        InputStream jsonStream = HostLearningConfigTest.class.getResourceAsStream("/host-learning-config.json");
        ConnectPoint subject = MacLearnerManagerTest.CLIENT_CP;
        String key = "org.onosproject.core";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(jsonStream);
        MockDelegate delegate = new MockDelegate();
        this.hostLearningConfig = new HostLearningConfig();
        this.hostLearningConfig.init((Object)subject, key, jsonNode, mapper, (ConfigApplyDelegate)delegate);
        this.macLearnerHostProvider.providerService = new MockHostProviderService((HostProvider)this.macLearnerHostProvider);
        this.macLearnerManager.hostLocService = this.macLearnerHostProvider;
        TestBaseMacLearner.injectEventDispatcher(this.macLearnerManager, new MockEventDispatcher());
        this.appId = this.macLearnerManager.coreService.registerApplication("org.opencord.maclearner");
        this.macLearnerManager.activate();
    }

    public static void injectEventDispatcher(Object manager, EventDeliveryService svc) {
        Field[] var3;
        Class<?> mc = manager.getClass();
        for (Field f : var3 = mc.getSuperclass().getDeclaredFields()) {
            if (!f.getType().equals(EventDeliveryService.class)) continue;
            try {
                TestUtils.setField((Object)manager, (String)f.getName(), (Object)svc);
                break;
            }
            catch (TestUtils.TestUtilsException var8) {
                throw new IllegalArgumentException("Unable to inject reference", var8);
            }
        }
    }

    static class MockSubscriberAndDeviceInformation
    extends SubscriberAndDeviceInformation {
        MockSubscriberAndDeviceInformation(String id, VlanId cTag, VlanId sTag, String nasPortId, String circuitId, MacAddress hardId, Ip4Address ipAddress, int uplinkPort) {
            this.setHardwareIdentifier(hardId);
            this.setId(id);
            this.setIPAddress(ipAddress);
            this.setNasPortId(nasPortId);
            this.setUplinkPort(uplinkPort);
            this.setCircuitId(circuitId);
        }
    }

    static class MockSubService
    implements BaseInformationService<SubscriberAndDeviceInformation> {
        MockSubscriberAndDeviceInformation device = new MockSubscriberAndDeviceInformation("BBSIM_OLT_1", MacLearnerManagerTest.CLIENT_VLAN, VlanId.NONE, null, null, null, null, (int)MacLearnerManagerTest.OLT_NNI_PORT.toLong());

        MockSubService() {
        }

        public SubscriberAndDeviceInformation get(String id) {
            if (id.equals("BBSIM_OLT_1")) {
                return this.device;
            }
            return null;
        }

        public void clearLocalData() {
        }

        public void invalidateAll() {
        }

        public void invalidateId(String id) {
        }

        public SubscriberAndDeviceInformation getfromCache(String id) {
            return null;
        }
    }

    static class MockSadisService
    implements SadisService {
        MockSadisService() {
        }

        public BaseInformationService<SubscriberAndDeviceInformation> getSubscriberInfoService() {
            return new MockSubService();
        }

        public BaseInformationService<BandwidthProfileInformation> getBandwidthProfileService() {
            return null;
        }
    }

    protected static class TestDhcpResponsePacketContext
    extends PacketContextAdapter {
        private InboundPacket inPacket;

        public TestDhcpResponsePacketContext(MacAddress clientMacAddress, MacAddress serverMacAddress, VlanId vlanId, VlanId qinqQVid, ConnectPoint connectPoint) {
            super(0L, null, null, false);
            byte[] dhcpMsgType = new byte[]{(byte)DHCP.MsgType.DHCPOFFER.getValue()};
            DhcpOption dhcpOption = new DhcpOption();
            dhcpOption.setCode(DHCP.DHCPOptionCode.OptionCode_MessageType.getValue());
            dhcpOption.setData(dhcpMsgType);
            dhcpOption.setLength((byte)1);
            DhcpOption endOption = new DhcpOption();
            endOption.setCode(DHCP.DHCPOptionCode.OptionCode_END.getValue());
            DHCP dhcp = new DHCP();
            dhcp.setHardwareType((byte)1);
            dhcp.setHardwareAddressLength((byte)6);
            dhcp.setClientHardwareAddress(clientMacAddress.toBytes());
            dhcp.setOptions((List)ImmutableList.of((Object)dhcpOption, (Object)endOption));
            dhcp.setYourIPAddress(Ip4Address.valueOf((String)"1.1.1.1").toInt());
            UDP udp = new UDP();
            udp.setPayload((IPacket)dhcp);
            udp.setSourcePort(67);
            udp.setDestinationPort(68);
            IPv4 ipv4 = new IPv4();
            ipv4.setPayload((IPacket)udp);
            ipv4.setDestinationAddress(INTERFACE_IP.toInt());
            ipv4.setSourceAddress(SERVER_IP.toInt());
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV4).setVlanID(vlanId.toShort()).setQinQVID(qinqQVid.toShort()).setSourceMACAddress(serverMacAddress).setDestinationMACAddress(clientMacAddress).setPayload((IPacket)ipv4);
            this.inPacket = new DefaultInboundPacket(connectPoint, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public InboundPacket inPacket() {
            return this.inPacket;
        }
    }

    protected static class TestDhcpRequestPacketContext
    extends PacketContextAdapter {
        private InboundPacket inPacket;

        public TestDhcpRequestPacketContext(MacAddress clientMac, VlanId vlanId, VlanId qinqQVid, ConnectPoint clientCp) {
            super(0L, null, null, false);
            byte[] dhcpMsgType = new byte[]{(byte)DHCP.MsgType.DHCPREQUEST.getValue()};
            DhcpOption dhcpOption = new DhcpOption();
            dhcpOption.setCode(DHCP.DHCPOptionCode.OptionCode_MessageType.getValue());
            dhcpOption.setData(dhcpMsgType);
            dhcpOption.setLength((byte)1);
            DhcpOption endOption = new DhcpOption();
            endOption.setCode(DHCP.DHCPOptionCode.OptionCode_END.getValue());
            DHCP dhcp = new DHCP();
            dhcp.setHardwareType((byte)1);
            dhcp.setHardwareAddressLength((byte)6);
            dhcp.setClientHardwareAddress(clientMac.toBytes());
            dhcp.setOptions((List)ImmutableList.of((Object)dhcpOption, (Object)endOption));
            UDP udp = new UDP();
            udp.setPayload((IPacket)dhcp);
            udp.setSourcePort(68);
            udp.setDestinationPort(67);
            IPv4 ipv4 = new IPv4();
            ipv4.setPayload((IPacket)udp);
            ipv4.setDestinationAddress(SERVER_IP.toInt());
            ipv4.setSourceAddress(INTERFACE_IP.toInt());
            Ethernet eth = new Ethernet();
            eth.setEtherType(Ethernet.TYPE_IPV4).setVlanID(vlanId.toShort()).setQinQVID(qinqQVid.toShort()).setSourceMACAddress(clientMac).setDestinationMACAddress(MacAddress.BROADCAST).setPayload((IPacket)ipv4);
            this.inPacket = new DefaultInboundPacket(clientCp, eth, ByteBuffer.wrap(eth.serialize()));
        }

        public InboundPacket inPacket() {
            return this.inPacket;
        }
    }

    private class MockHostProviderService
    extends AbstractProviderService<HostProvider>
    implements HostProviderService {
        private HostId hostId;
        private HostDescription hostDescription;
        private String event;

        public MockHostProviderService(HostProvider provider) {
            super((Provider)provider);
            this.hostId = null;
            this.hostDescription = null;
            this.event = null;
        }

        public void hostDetected(HostId hostId, HostDescription hostDescription, boolean replaceIps) {
            this.hostId = hostId;
            this.hostDescription = hostDescription;
            this.event = "hostDetected";
            HashSet previousHosts = Sets.newHashSet((Iterable)TestBaseMacLearner.this.hostService.getHosts());
            previousHosts.add(new DefaultHost(((HostProvider)this.provider()).id(), hostId, hostDescription.hwAddress(), hostDescription.vlan(), hostDescription.locations(), hostDescription.auxLocations(), hostDescription.ipAddress(), VlanId.NONE, EthType.EtherType.UNKNOWN.ethType(), false, false, new Annotations[0]));
            TestBaseMacLearner.this.hostService = new MockHostService(previousHosts);
            TestBaseMacLearner.this.macLearnerManager.hostService = TestBaseMacLearner.this.hostService;
        }

        public void hostVanished(HostId hostId) {
            this.hostId = hostId;
            this.event = "hostVanished";
            HashSet previousHosts = Sets.newHashSet((Iterable)TestBaseMacLearner.this.hostService.getHosts());
            Host removedHost = TestBaseMacLearner.this.hostService.getHost(hostId);
            previousHosts.remove(removedHost);
            TestBaseMacLearner.this.hostService = new MockHostService(previousHosts);
            TestBaseMacLearner.this.macLearnerManager.hostService = TestBaseMacLearner.this.hostService;
        }

        public void removeIpFromHost(HostId hostId, IpAddress ipAddress) {
        }

        public void removeLocationFromHost(HostId hostId, HostLocation location) {
        }

        public void clear() {
            this.hostId = null;
            this.hostDescription = null;
            this.event = null;
        }
    }

    public static class MockEventDispatcher
    extends DefaultEventSinkRegistry
    implements EventDeliveryService {
        public synchronized void post(Event event) {
            EventSink sink = this.getSink(event.getClass());
            Preconditions.checkState((sink != null ? 1 : 0) != 0, (String)"No sink for event %s", (Object)event);
            sink.process(event);
        }

        public void setDispatchTimeLimit(long millis) {
        }

        public long getDispatchTimeLimit() {
            return 0L;
        }
    }

    public static class MockLinkService
    extends LinkServiceAdapter {
        Link link = DefaultLink.builder().type(Link.Type.DIRECT).providerId(NetTestTools.PID).src(new ConnectPoint((ElementId)MacLearnerManagerTest.OLT_DEVICE_ID, MacLearnerManagerTest.OLT_NNI_PORT)).dst(new ConnectPoint((ElementId)MacLearnerManagerTest.AGG_DEVICE_ID, MacLearnerManagerTest.AGG_OLT_PORT)).build();

        public Set<Link> getDeviceLinks(DeviceId deviceId) {
            return Sets.newHashSet((Object[])new Link[]{this.link});
        }
    }

    public static class MockPacketService
    extends PacketServiceAdapter {
        Set<PacketProcessor> packetProcessors = Sets.newHashSet();
        OutboundPacket emittedPacket;

        public void addProcessor(PacketProcessor processor, int priority) {
            this.packetProcessors.add(processor);
        }

        public void processPacket(PacketContext packetContext) {
            this.packetProcessors.forEach(p -> p.process(packetContext));
        }

        public void emit(OutboundPacket packet) {
            this.emittedPacket = packet;
        }
    }

    private static class MockAtomicCounter
    implements AtomicCounter {
        long id = 0L;

        private MockAtomicCounter() {
        }

        public long incrementAndGet() {
            return ++this.id;
        }

        public long getAndIncrement() {
            return this.id++;
        }

        public long getAndAdd(long delta) {
            long oldId = this.id;
            this.id += delta;
            return oldId;
        }

        public long addAndGet(long delta) {
            this.id += delta;
            return this.id;
        }

        public void set(long value) {
            this.id = value;
        }

        public boolean compareAndSet(long expectedValue, long updateValue) {
            if (this.id == expectedValue) {
                this.id = updateValue;
                return true;
            }
            return false;
        }

        public long get() {
            return this.id;
        }

        public String name() {
            return "MockAtomicCounter";
        }
    }

    private static class MockStorageService
    extends StorageServiceAdapter {
        private MockStorageService() {
        }

        public <K, V> ConsistentMapBuilder<K, V> consistentMapBuilder() {
            ConsistentMapBuilder builder = new ConsistentMapBuilder<K, V>(){

                public AsyncConsistentMap<K, V> buildAsyncMap() {
                    return null;
                }

                public ConsistentMap<K, V> build() {
                    return new TestConsistentMap();
                }
            };
            return builder;
        }

        public <E> DistributedSetBuilder<E> setBuilder() {
            DistributedSetBuilder builder = new DistributedSetBuilder<E>(){

                public AsyncDistributedSet<E> build() {
                    return new DistributedSetAdapter<E>(){

                        public DistributedSet<E> asDistributedSet() {
                            return new TestDistributedSet();
                        }
                    };
                }
            };
            return builder;
        }

        public AtomicCounter getAtomicCounter(String name) {
            return new MockAtomicCounter();
        }

        class TestDistributedSet<E>
        extends HashSet<E>
        implements DistributedSet<E> {
            TestDistributedSet() {
            }

            public void addListener(SetEventListener<E> listener) {
            }

            public void removeListener(SetEventListener<E> listener) {
            }

            public String name() {
                return null;
            }

            public DistributedPrimitive.Type primitiveType() {
                return null;
            }
        }

        class TestConsistentMap<K, V>
        extends ConsistentMapAdapter<K, V> {
            private Map<K, Versioned<V>> map = new HashMap<K, Versioned<V>>();
            private Map<MapEventListener<K, V>, Executor> listeners = new HashMap<MapEventListener<K, V>, Executor>();

            TestConsistentMap() {
            }

            public void notifyListeners(MapEvent<K, V> event) {
                this.listeners.forEach((c, e) -> e.execute(() -> c.event(event)));
            }

            public int size() {
                return this.map.size();
            }

            public Versioned<V> put(K key, V value) {
                Versioned<V> oldValue = this.map.get(key);
                Versioned newValue = new Versioned(value, oldValue == null ? 0L : oldValue.version() + 1L);
                this.map.put(key, newValue);
                this.notifyListeners(new MapEvent(this.name(), key, newValue, oldValue));
                return newValue;
            }

            public Versioned<V> get(K key) {
                return this.map.get(key);
            }

            public Versioned<V> remove(K key) {
                Versioned<V> oldValue = this.map.remove(key);
                this.notifyListeners(new MapEvent(this.name(), key, oldValue, null));
                return oldValue;
            }

            public Versioned<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
                Versioned<V> oldValue = this.map.get(key);
                Versioned newValue = new Versioned(remappingFunction.apply(key, oldValue.value()), oldValue == null ? 0L : oldValue.version() + 1L);
                this.map.put(key, newValue);
                this.notifyListeners(new MapEvent(this.name(), key, newValue, oldValue));
                return newValue;
            }

            public Set<Map.Entry<K, Versioned<V>>> entrySet() {
                return this.map.entrySet();
            }

            public Set<K> keySet() {
                return this.map.keySet();
            }

            public Collection<Versioned<V>> values() {
                return this.map.values();
            }

            public void clear() {
                this.map.clear();
            }

            public void addListener(MapEventListener<K, V> listener, Executor executor) {
                this.listeners.put(listener, executor);
            }

            public void removeListener(MapEventListener<K, V> listener) {
                this.listeners.remove(listener);
            }
        }
    }

    private static class MockTopology
    implements Topology {
        private MockTopology() {
        }

        public long time() {
            return 11111L;
        }

        public long creationTime() {
            return 22222L;
        }

        public long computeCost() {
            return 0L;
        }

        public int clusterCount() {
            return 2;
        }

        public int deviceCount() {
            return 6;
        }

        public int linkCount() {
            return 4;
        }

        public ProviderId providerId() {
            return ProviderId.NONE;
        }
    }

    private static class MockTopologyService
    extends TopologyServiceAdapter {
        private final Topology topology = new MockTopology();

        private MockTopologyService() {
        }

        public Topology currentTopology() {
            return this.topology;
        }

        public boolean isInfrastructure(Topology topology, ConnectPoint connectPoint) {
            return false;
        }
    }

    static class MockPort
    implements Port {
        private ConnectPoint cp;

        public MockPort(ConnectPoint cp) {
            this.cp = cp;
        }

        public boolean isEnabled() {
            return true;
        }

        public long portSpeed() {
            return 1000L;
        }

        public Element element() {
            return null;
        }

        public PortNumber number() {
            return null;
        }

        public Annotations annotations() {
            return new MockAnnotations();
        }

        public Port.Type type() {
            return Port.Type.FIBER;
        }

        private class MockAnnotations
        implements Annotations {
            private MockAnnotations() {
            }

            public String value(String val) {
                if (MockPort.this.cp.port().toLong() == 32L) {
                    return "ALPHe3d1cea3-1";
                }
                if (MockPort.this.cp.port().toLong() == 4112L) {
                    return "ALPHe3d1ceb7-1";
                }
                return "PON 1/1";
            }

            public Set<String> keys() {
                return null;
            }
        }
    }

    private static class MockDeviceService
    extends DeviceServiceAdapter {
        private List<DeviceListener> listeners = Lists.newArrayList();

        private MockDeviceService() {
        }

        public Device getDevice(DeviceId deviceId) {
            if (deviceId.equals((Object)MacLearnerManagerTest.OLT_DEVICE_ID)) {
                return new DefaultDevice(null, MacLearnerManagerTest.OLT_DEVICE_ID, Device.Type.SWITCH, "VOLTHA Project", "open_pon", "open_pon", "BBSIM_OLT_1", new ChassisId("a0a0a0a0a01"), new Annotations[0]);
            }
            return null;
        }

        public Port getPort(DeviceId deviceId, PortNumber portNumber) {
            return new MockPort(new ConnectPoint((ElementId)deviceId, portNumber));
        }

        public void addListener(DeviceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(DeviceListener listener) {
            this.listeners.remove(listener);
        }
    }

    protected static class MockHostService
    extends HostServiceAdapter {
        private Set<Host> hosts;

        MockHostService(Set<Host> hosts) {
            this.hosts = ImmutableSet.copyOf(hosts);
        }

        public Set<Host> getHosts() {
            return this.hosts;
        }

        public Host getHost(HostId hostId) {
            return this.hosts.stream().filter(host -> hostId.equals((Object)host.id())).findFirst().orElse(null);
        }
    }

    private static class MockClusterService
    extends ClusterServiceAdapter {
        private final Map<NodeId, ControllerNode> nodes = new HashMap<NodeId, ControllerNode>();
        private final Map<NodeId, ControllerNode.State> states = new HashMap<NodeId, ControllerNode.State>();

        MockClusterService() {
            this.nodes.put(CNODE_1.id(), CNODE_1);
            this.nodes.put(CNODE_2.id(), CNODE_2);
            this.nodes.put(CNODE_3.id(), CNODE_3);
            this.states.put(CNODE_1.id(), ControllerNode.State.READY);
            this.states.put(CNODE_2.id(), ControllerNode.State.ACTIVE);
            this.states.put(CNODE_3.id(), ControllerNode.State.ACTIVE);
        }

        public Set<ControllerNode> getNodes() {
            return ImmutableSet.copyOf(this.nodes.values());
        }

        public ControllerNode getNode(NodeId nodeId) {
            return this.nodes.get(nodeId);
        }

        public ControllerNode.State getState(NodeId nodeId) {
            return this.states.get(nodeId);
        }
    }

    private static final class MockCoreService
    extends CoreServiceAdapter {
        private List<ApplicationId> idList = Lists.newArrayList();
        private Map<String, ApplicationId> idMap = Maps.newHashMap();

        private MockCoreService() {
        }

        public ApplicationId getAppId(Short id) {
            if (id >= this.idList.size()) {
                return null;
            }
            return this.idList.get(id.shortValue());
        }

        public ApplicationId getAppId(String name) {
            return this.idMap.get(name);
        }

        public ApplicationId registerApplication(String name) {
            ApplicationId appId = this.idMap.get(name);
            if (appId == null) {
                appId = new MockApplicationId((short)this.idList.size(), name);
                this.idList.add(appId);
                this.idMap.put(name, appId);
            }
            return appId;
        }
    }

    private static final class MockComponentConfigService
    extends ComponentConfigAdapter {
        private MockComponentConfigService() {
        }
    }

    private static final class MockApplicationId
    implements ApplicationId {
        private final short id;
        private final String name;

        public MockApplicationId(short id, String name) {
            this.id = id;
            this.name = name;
        }

        public short id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }
    }

    private class MockDelegate
    implements ConfigApplyDelegate {
        private MockDelegate() {
        }

        public void onApply(Config config) {
        }
    }
}

