/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl;

import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipService;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.device.DeviceService;
import org.opencord.igmpproxy.IgmpLeadershipService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={IgmpLeadershipService.class})
public class IgmpLeadershipManager
implements IgmpLeadershipService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected LeadershipService leadershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected MastershipService mastershipService;

    @Activate
    public void activate(ComponentContext context) {
        this.log.info("Started.");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.log.info("Stopped.");
    }

    public boolean isLocalLeader(DeviceId deviceId) {
        if (this.deviceService.isAvailable(deviceId)) {
            return this.mastershipService.isLocalMaster(deviceId);
        }
        NodeId leader = this.leadershipService.runForLeadership(deviceId.toString()).leaderNodeId();
        return this.clusterService.getLocalNode().id().equals((Object)leader);
    }

    public NodeId getLocalNodeId() {
        return this.clusterService.getLocalNode().id();
    }

    public NodeId getLeader(String topic) {
        return this.leadershipService.getLeader(topic);
    }

    public Leadership runForLeadership(String topic) {
        return this.leadershipService.runForLeadership(topic);
    }

    public void withdraw(String topic) {
        this.leadershipService.withdraw(topic);
    }
}

