/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.onlab.packet.EthType;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IGMP;
import org.onlab.packet.IGMPGroup;
import org.onlab.packet.IGMPMembership;
import org.onlab.packet.IGMPQuery;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mcast.api.McastRoute;
import org.onosproject.mcast.api.MulticastRouteService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.McastConfig;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flowobjective.DefaultFilteringObjective;
import org.onosproject.net.flowobjective.FilteringObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.flowobjective.ObjectiveContext;
import org.onosproject.net.flowobjective.ObjectiveError;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.opencord.igmpproxy.GroupMemberId;
import org.opencord.igmpproxy.IgmpLeadershipService;
import org.opencord.igmpproxy.IgmpStatisticType;
import org.opencord.igmpproxy.IgmpStatisticsService;
import org.opencord.igmpproxy.impl.IgmpSender;
import org.opencord.igmpproxy.impl.IgmpproxyConfig;
import org.opencord.igmpproxy.impl.IgmpproxySsmTranslateConfig;
import org.opencord.igmpproxy.impl.store.groupmember.GroupMember;
import org.opencord.igmpproxy.impl.store.groupmember.GroupMemberStore;
import org.opencord.igmpproxy.statemachine.StateMachineService;
import org.opencord.sadis.SadisService;
import org.opencord.sadis.SubscriberAndDeviceInformation;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class IgmpManager {
    private static final String MCAST_NOT_RUNNING = "Multicast is not running.";
    private static final String SADIS_NOT_RUNNING = "Sadis is not running.";
    private static final String APP_NAME = "org.opencord.igmpproxy";
    private static final Class<IgmpproxyConfig> IGMPPROXY_CONFIG_CLASS = IgmpproxyConfig.class;
    private static final Class<IgmpproxySsmTranslateConfig> IGMPPROXY_SSM_CONFIG_CLASS = IgmpproxySsmTranslateConfig.class;
    private static final Class<McastConfig> MCAST_CONFIG_CLASS = McastConfig.class;
    private static ApplicationId appId;
    private static int unSolicitedTimeout;
    private static int keepAliveCount;
    private static int lastQueryInterval;
    private static int lastQueryCount;
    private static boolean fastLeave;
    private static boolean withRAUplink;
    private static boolean withRADownlink;
    private static boolean periodicQuery;
    private static short mvlan;
    private static short mvlanInner;
    private static byte igmpCos;
    private static byte igmpUniCos;
    public static boolean connectPointMode;
    public static ConnectPoint connectPoint;
    private static ConnectPoint sourceDeviceAndPort;
    private static boolean enableIgmpProvisioning;
    private static boolean igmpOnPodBasis;
    private static boolean outgoingIgmpWithV3;
    private static final Integer MAX_PRIORITY;
    private static final String INSTALLED = "installed";
    private static final String REMOVED = "removed";
    private static final String INSTALLATION = "installation";
    private static final String REMOVAL = "removal";
    private static final String NNI_PREFIX = "nni";
    private static boolean pimSSmInterworking;
    private static final String DEFAULT_PIMSSM_HOST = "127.0.0.1";
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected NetworkConfigRegistry networkConfig;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, bind="bindMcastRouteService", unbind="unbindMcastRouteService", policy=ReferencePolicy.DYNAMIC)
    protected volatile MulticastRouteService multicastService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, bind="bindSadisService", unbind="unbindSadisService", policy=ReferencePolicy.DYNAMIC)
    protected volatile SadisService sadisService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected IgmpStatisticsService igmpStatisticsManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected GroupMemberStore groupMemberStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected StateMachineService stateMachineService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected IgmpLeadershipService igmpLeadershipService;
    private IgmpPacketProcessor processor = new IgmpPacketProcessor();
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationId coreAppId;
    private Map<Ip4Address, Ip4Address> ssmTranslateTable = new ConcurrentHashMap<Ip4Address, Ip4Address>();
    private InternalNetworkConfigListener configListener = new InternalNetworkConfigListener();
    private DeviceListener deviceListener = new InternalDeviceListener();
    private ConfigFactory<ApplicationId, IgmpproxyConfig> igmpproxyConfigFactory = new ConfigFactory<ApplicationId, IgmpproxyConfig>(SubjectFactories.APP_SUBJECT_FACTORY, IGMPPROXY_CONFIG_CLASS, "igmpproxy"){

        public IgmpproxyConfig createConfig() {
            return new IgmpproxyConfig();
        }
    };
    private ConfigFactory<ApplicationId, IgmpproxySsmTranslateConfig> igmpproxySsmConfigFactory = new ConfigFactory<ApplicationId, IgmpproxySsmTranslateConfig>(SubjectFactories.APP_SUBJECT_FACTORY, IGMPPROXY_SSM_CONFIG_CLASS, "ssmTranslate", true){

        public IgmpproxySsmTranslateConfig createConfig() {
            return new IgmpproxySsmTranslateConfig();
        }
    };
    private int maxResp = 10;
    private int keepAliveInterval = 120;
    private int numberOfIgmpReportProcessorThreads = 20;
    ExecutorService[] igmpReportProcessServiceExecutorList;
    private ExecutorService eventExecutor;
    private List<Byte> validMembershipModes = Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6);

    public static int getUnsolicitedTimeout() {
        return unSolicitedTimeout;
    }

    public static boolean outgoingIgmpWithV3() {
        return outgoingIgmpWithV3;
    }

    @Activate
    protected void activate() {
        appId = this.coreService.registerApplication(APP_NAME);
        this.coreAppId = this.coreService.registerApplication("org.onosproject.core");
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)4));
        IgmpSender.init(this.packetService, this.igmpStatisticsManager);
        this.networkConfig.registerConfigFactory(this.igmpproxySsmConfigFactory);
        this.networkConfig.registerConfigFactory(this.igmpproxyConfigFactory);
        this.networkConfig.addListener((EventListener)this.configListener);
        this.configListener.reconfigureNetwork((IgmpproxyConfig)this.networkConfig.getConfig((Object)appId, IGMPPROXY_CONFIG_CLASS));
        this.configListener.reconfigureSsmTable((IgmpproxySsmTranslateConfig)this.networkConfig.getConfig((Object)appId, IGMPPROXY_SSM_CONFIG_CLASS));
        if (connectPointMode) {
            this.provisionConnectPointFlows();
        } else {
            this.provisionUplinkFlows();
        }
        McastConfig config = (McastConfig)this.networkConfig.getConfig((Object)this.coreAppId, MCAST_CONFIG_CLASS);
        if (config != null) {
            mvlan = config.egressVlan().toShort();
            IgmpSender.getInstance().setMvlan(mvlan);
            mvlanInner = config.egressInnerVlan().toShort();
            IgmpSender.getInstance().setMvlanInner(mvlanInner);
        }
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.scheduledExecutorService.scheduleAtFixedRate(new IgmpProxyTimerTask(), 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.eventExecutor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"cord/igmpproxy", (String)"events-igmp-%d", (Logger)this.log));
        this.initializeIgmpReportProcessServiceExecutors();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.scheduledExecutorService.shutdown();
        this.eventExecutor.shutdown();
        this.shutdownIgmpReportProcessServiceExecutors();
        this.networkConfig.removeListener((EventListener)this.configListener);
        this.networkConfig.unregisterConfigFactory(this.igmpproxyConfigFactory);
        this.networkConfig.unregisterConfigFactory(this.igmpproxySsmConfigFactory);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.log.info("Stopped");
    }

    private void initializeIgmpReportProcessServiceExecutors() {
        this.igmpReportProcessServiceExecutorList = new ExecutorService[this.numberOfIgmpReportProcessorThreads];
        for (int i = 0; i < this.numberOfIgmpReportProcessorThreads; ++i) {
            ExecutorService igmpReportProcessServiceExecutor;
            ThreadFactory igmpReportProcessorThreadFactory = new ThreadFactoryBuilder().setNameFormat("report-processor-igmp-" + i).setUncaughtExceptionHandler((t, e) -> this.log.error("Uncaught exception on {}: ", (Object)t.getName(), (Object)e)).build();
            this.igmpReportProcessServiceExecutorList[i] = igmpReportProcessServiceExecutor = Executors.newSingleThreadExecutor(igmpReportProcessorThreadFactory);
        }
    }

    private void shutdownIgmpReportProcessServiceExecutors() {
        for (ExecutorService executor : this.igmpReportProcessServiceExecutorList) {
            executor.shutdown();
        }
    }

    protected void bindSadisService(SadisService service) {
        this.sadisService = service;
        this.log.info("Sadis-service binds to onos.");
    }

    protected void unbindSadisService(SadisService service) {
        this.sadisService = null;
        this.log.info("Sadis-service unbinds from onos.");
    }

    protected void bindMcastRouteService(MulticastRouteService service) {
        this.multicastService = service;
        this.log.info("Multicast route service binds to onos.");
    }

    protected void unbindMcastRouteService(MulticastRouteService service) {
        this.multicastService = null;
        this.log.info("Multicast route service unbinds from onos.");
    }

    protected Ip4Address getDeviceIp(DeviceId ofDeviceId) {
        try {
            String[] mgmtAddress = this.deviceService.getDevice(ofDeviceId).annotations().value("managementAddress").split(":");
            return Ip4Address.valueOf((String)mgmtAddress[0]);
        }
        catch (Exception ex) {
            this.log.info("No valid Ipaddress for {}", (Object)ofDeviceId);
            return null;
        }
    }

    private void processIgmpQuery(IGMPQuery igmpQuery, ConnectPoint cp, int maxResp) {
        DeviceId deviceId = cp.deviceId();
        Ip4Address gAddr = igmpQuery.getGaddr().getIp4Address();
        maxResp = this.calculateMaxResp(maxResp);
        if (gAddr != null && !gAddr.isZero()) {
            this.stateMachineService.specialQuery(deviceId, gAddr, maxResp);
            this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_GRP_SPECIFIC_MEMBERSHIP_QUERY);
        } else {
            this.stateMachineService.generalQuery(deviceId, maxResp);
            this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_GENERAL_MEMBERSHIP_QUERY);
        }
    }

    private void processIgmpConnectPointQuery(IGMPQuery igmpQuery, ConnectPoint cp, int maxResp) {
        Ip4Address gAddr = igmpQuery.getGaddr().getIp4Address();
        int maxResponseTime = this.calculateMaxResp(maxResp);
        if (gAddr != null && !gAddr.isZero()) {
            this.deviceService.getAvailableDevices().forEach(device -> {
                Optional<SubscriberAndDeviceInformation> accessDevice = this.getSubscriberAndDeviceInformation(device.id());
                if (accessDevice.isPresent()) {
                    this.stateMachineService.specialQuery(device.id(), gAddr, maxResponseTime);
                    this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_GRP_AND_SRC_SPESIFIC_MEMBERSHIP_QUERY);
                }
            });
            this.igmpStatisticsManager.increaseStat(IgmpStatisticType.CURRENT_GRP_NUMBER_COUNTER);
        } else {
            this.stateMachineService.generalQuery(maxResponseTime);
            this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_GENERAL_MEMBERSHIP_QUERY);
        }
    }

    private int calculateMaxResp(int maxResp) {
        if (maxResp >= 128) {
            int mant = maxResp & 0xF;
            int exp = maxResp >> 4 & 7;
            maxResp = (mant | 0x10) << exp + 3;
        }
        return (maxResp + 5) / 10;
    }

    private void queueIgmpReport(IGMPMembership igmpGroup, VlanId vlan, ConnectPoint cp, byte igmpType) {
        int packetHashCode = Objects.hash(igmpGroup.getGaddr(), cp);
        int threadId = Math.abs(packetHashCode % this.numberOfIgmpReportProcessorThreads);
        this.log.debug("IGMP report for ConnectPoint {} and group IP {} shall be processed in thread #{}", new Object[]{cp, igmpGroup.getGaddr(), threadId});
        this.igmpReportProcessServiceExecutorList[threadId].execute(() -> this.processIgmpReport(igmpGroup, vlan, cp, igmpType));
    }

    private Ip4Address ssmTranslateRoute(IpAddress group) {
        return this.ssmTranslateTable.get(group);
    }

    private void processIgmpReport(IGMPMembership igmpGroup, VlanId vlan, ConnectPoint cp, byte igmpType) {
        if (this.multicastService == null) {
            this.log.warn(MCAST_NOT_RUNNING);
            return;
        }
        DeviceId deviceId = cp.deviceId();
        PortNumber portNumber = cp.port();
        this.log.debug("Processing IGMP report on membership {} for vlan {} on port {} with type {}", new Object[]{igmpGroup, vlan, cp, igmpType});
        Ip4Address groupIp = igmpGroup.getGaddr().getIp4Address();
        if (!groupIp.isMulticast()) {
            this.log.info("{} is not a valid group address", (Object)groupIp);
            this.igmpStatisticsManager.increaseStat(IgmpStatisticType.FAIL_JOIN_REQ_UNKNOWN_MULTICAST_IP_COUNTER);
            return;
        }
        Ip4Address srcIp = this.getDeviceIp(deviceId);
        byte recordType = igmpGroup.getRecordType();
        boolean join = false;
        ArrayList<Ip4Address> sourceList = new ArrayList<Ip4Address>();
        if (!this.validMembershipModes.contains(recordType)) {
            this.igmpStatisticsManager.increaseStat(IgmpStatisticType.REPORTS_RX_WITH_WRONG_MODE_COUNTER);
        }
        if (igmpGroup.getSources().size() > 0) {
            igmpGroup.getSources().forEach(source -> sourceList.add(source.getIp4Address()));
            if (recordType == 4 || recordType == 2 || recordType == 6) {
                join = false;
            } else if (recordType == 3 || recordType == 1 || recordType == 5) {
                join = true;
            }
        } else {
            IpAddress src = null;
            if (pimSSmInterworking) {
                src = this.ssmTranslateRoute((IpAddress)groupIp);
                if (src == null) {
                    this.log.info("no ssm translate for group {}", (Object)groupIp);
                    return;
                }
            } else {
                src = IpAddress.valueOf((String)DEFAULT_PIMSSM_HOST);
            }
            sourceList.add(src.getIp4Address());
            if (recordType == 4 || recordType == 2 || recordType == 6) {
                join = true;
            } else if (recordType == 3 || recordType == 1 || recordType == 5) {
                join = false;
            }
        }
        GroupMemberId groupMemberKey = GroupMemberId.of((Ip4Address)groupIp, (DeviceId)deviceId, (PortNumber)portNumber);
        this.log.debug("{} for {}", (Object)(join ? "Join" : "Leave"), (Object)groupMemberKey);
        GroupMember groupMember = this.groupMemberStore.getGroupMember(groupMemberKey);
        if (join) {
            this.log.debug("Received join on {} for vlan {}", (Object)cp, (Object)vlan);
            this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_JOIN_REQ);
            if (groupMember == null) {
                Optional<ConnectPoint> sourceConfigured = IgmpManager.getSource();
                if (!sourceConfigured.isPresent()) {
                    this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_FAIL_JOIN_REQ);
                    this.log.warn("Unable to process IGMP Join from {} since no source configuration is found.", (Object)deviceId);
                    this.igmpStatisticsManager.increaseStat(IgmpStatisticType.FAIL_JOIN_REQ_INSUFF_PERMISSION_ACCESS_COUNTER);
                    return;
                }
                Optional<PortNumber> deviceUplink = this.getDeviceUplink(deviceId);
                if (deviceUplink.isEmpty()) {
                    this.log.warn("Unable to process IGMP Join since uplink port of the device {} is not found.", (Object)deviceId);
                    return;
                }
                groupMember = igmpType == 22 ? new GroupMember(groupIp, vlan, deviceId, portNumber, true) : new GroupMember(groupIp, vlan, deviceId, portNumber, false);
                HashSet sourceConnectPoints = Sets.newHashSet((Object[])new ConnectPoint[]{sourceConfigured.get()});
                boolean isJoined = this.stateMachineService.join(deviceId, groupIp, srcIp, deviceUplink.get());
                if (isJoined) {
                    this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_SUCCESS_JOIN_RE_JOIN_REQ);
                    this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_CHANNEL_JOIN_COUNTER);
                } else {
                    this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_FAIL_JOIN_REQ);
                }
                this.groupMemberStore.putGroupMember(groupMember);
                this.log.debug("Group member created with id: {}", (Object)groupMember.getGroupMemberId());
                groupMember.updateList(recordType, sourceList);
                groupMember.getSourceList().forEach(source -> {
                    McastRoute route = new McastRoute((IpAddress)source, (IpAddress)groupIp, McastRoute.Type.IGMP);
                    this.multicastService.add(route);
                    this.multicastService.addSources(route, (Set)Sets.newHashSet((Iterable)sourceConnectPoints));
                    this.multicastService.addSinks(route, (Set)Sets.newHashSet((Object[])new ConnectPoint[]{cp}));
                });
                this.igmpStatisticsManager.increaseStat(IgmpStatisticType.UNCONFIGURED_GROUP_COUNTER);
            }
            groupMember.resetAllTimers();
            groupMember.updateList(recordType, sourceList);
            groupMember.setLeave(false);
            this.groupMemberStore.putGroupMember(groupMember);
        } else {
            this.log.debug("Received leave on {} for vlan {}", (Object)cp, (Object)vlan);
            this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_LEAVE_REQ);
            if (groupMember == null) {
                this.log.info("receive leave but no instance, group {} device: {} port:{}", new Object[]{groupIp, deviceId, portNumber});
                this.igmpStatisticsManager.increaseStat(IgmpStatisticType.UNCONFIGURED_GROUP_COUNTER);
                return;
            }
            groupMember.setLeave(true);
            if (fastLeave) {
                this.leaveAction(groupMember);
            } else {
                this.sendQuery(groupMember);
                this.groupMemberStore.updateGroupMember(groupMember);
            }
        }
    }

    private void leaveAction(GroupMember groupMember) {
        if (this.multicastService == null) {
            this.log.warn(MCAST_NOT_RUNNING);
            return;
        }
        this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_DISCONNECT);
        ConnectPoint cp = new ConnectPoint((ElementId)groupMember.getDeviceId(), groupMember.getPortNumber());
        this.stateMachineService.leave(groupMember.getDeviceId(), groupMember.getGroupIp());
        groupMember.getSourceList().forEach(source -> this.multicastService.removeSinks(new McastRoute((IpAddress)source, (IpAddress)groupMember.getGroupIp(), McastRoute.Type.IGMP), (Set)Sets.newHashSet((Object[])new ConnectPoint[]{cp})));
        this.groupMemberStore.removeGroupMember(groupMember.getGroupMemberId());
    }

    private void sendQuery(GroupMember groupMember) {
        Ip4Address srcIp = this.getDeviceIp(groupMember.getDeviceId());
        Ethernet ethpkt = groupMember.getv2() ? IgmpSender.getInstance().buildIgmpV2Query(groupMember.getGroupIp(), srcIp, groupMember.getvlan().toShort()) : IgmpSender.getInstance().buildIgmpV3Query(groupMember.getGroupIp(), srcIp, groupMember.getvlan().toShort());
        this.log.debug("Sending IGMP query to {}/{} for group {}: {}", new Object[]{groupMember.getDeviceId(), groupMember.getPortNumber(), groupMember.getGroupIp(), ethpkt});
        IgmpSender.getInstance().sendIgmpPacket(ethpkt, groupMember.getDeviceId(), groupMember.getPortNumber());
    }

    public static Optional<ConnectPoint> getSource() {
        return sourceDeviceAndPort == null ? Optional.empty() : Optional.of(sourceDeviceAndPort);
    }

    private void processIgmpMessage(InboundPacket pkt, IGMP igmp, PortNumber upLinkPort, short vlan) {
        if (pkt.receivedFrom().port().equals((Object)upLinkPort) || this.isConnectPoint(pkt.receivedFrom().deviceId(), pkt.receivedFrom().port())) {
            this.log.info("IGMP Picked up join/leave from uplink/connectPoint port");
            return;
        }
        for (IGMPGroup group : igmp.getGroups()) {
            this.log.debug("IGMPGroup {}", (Object)group.getGaddr());
            if (group instanceof IGMPMembership) {
                this.queueIgmpReport((IGMPMembership)group, VlanId.vlanId((short)vlan), pkt.receivedFrom(), igmp.getIgmpType());
                continue;
            }
            IGMPMembership mgroup = new IGMPMembership(group.getGaddr().getIp4Address());
            mgroup.setRecordType(igmp.getIgmpType() == 22 ? (byte)2 : 1);
            this.queueIgmpReport(mgroup, VlanId.vlanId((short)vlan), pkt.receivedFrom(), igmp.getIgmpType());
        }
    }

    public Optional<PortNumber> getDeviceUplink(DeviceId devId) {
        Device device = this.deviceService.getDevice(devId);
        if (device == null || device.serialNumber() == null) {
            return Optional.empty();
        }
        Optional<SubscriberAndDeviceInformation> olt = this.getSubscriberAndDeviceInformation(device.serialNumber());
        if (olt.isEmpty()) {
            return Optional.empty();
        }
        PortNumber portNumber = PortNumber.portNumber((long)olt.get().uplinkPort());
        return this.validateUpLinkPort(device.id(), portNumber) ? Optional.of(portNumber) : Optional.empty();
    }

    public boolean validateUpLinkPort(DeviceId deviceId, PortNumber portNumber) {
        boolean isValid;
        Port port = this.deviceService.getPort(deviceId, portNumber);
        if (port == null) {
            return false;
        }
        boolean bl = isValid = port.annotations().value("portName") != null && port.annotations().value("portName").startsWith(NNI_PREFIX);
        if (!isValid) {
            this.log.warn("Port cannot be validated; it is not configured as an NNI port. Device/port: {}/{}", (Object)deviceId, (Object)portNumber);
        }
        return isValid;
    }

    public static boolean isIgmpOnPodBasis() {
        return igmpOnPodBasis;
    }

    private void processFilterObjective(final DeviceId devId, final PortNumber port, final boolean remove) {
        if (!enableIgmpProvisioning) {
            this.log.debug("IGMP trap rules won't be installed since enableIgmpProvisioning flag is not set");
            return;
        }
        DefaultFilteringObjective.Builder builder = DefaultFilteringObjective.builder();
        builder = remove ? builder.deny() : builder.permit();
        FilteringObjective igmp = builder.withKey(Criteria.matchInPort((PortNumber)port)).addCondition(Criteria.matchEthType((EthType)EthType.EtherType.IPV4.ethType())).addCondition(Criteria.matchIPProtocol((short)2)).withMeta(DefaultTrafficTreatment.builder().setOutput(PortNumber.CONTROLLER).build()).fromApp(appId).withPriority(MAX_PRIORITY.intValue()).add(new ObjectiveContext(){

            public void onSuccess(Objective objective) {
                IgmpManager.this.log.info("Igmp filter for {} on {} {}.", new Object[]{devId, port, remove ? IgmpManager.REMOVED : IgmpManager.INSTALLED});
            }

            public void onError(Objective objective, ObjectiveError error) {
                IgmpManager.this.log.info("Igmp filter {} for device {} on port {} failed because of {}", new Object[]{remove ? IgmpManager.INSTALLATION : IgmpManager.REMOVAL, devId, port, error});
            }
        });
        this.flowObjectiveService.filter(devId, igmp);
    }

    private boolean isConnectPoint(DeviceId device, PortNumber port) {
        if (connectPoint != null) {
            return connectPointMode && connectPoint.deviceId().equals((Object)device) && connectPoint.port().equals((Object)port);
        }
        this.log.debug("connectPoint not configured for device {}", (Object)device);
        return false;
    }

    private boolean isUplink(DeviceId device, PortNumber port) {
        if (connectPointMode) {
            return false;
        }
        Optional<PortNumber> upLinkPort = this.getDeviceUplink(device);
        return upLinkPort.isPresent() && upLinkPort.get().equals((Object)port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<SubscriberAndDeviceInformation> getSubscriberAndDeviceInformation(String serialNumber) {
        long start = System.currentTimeMillis();
        try {
            if (this.sadisService == null) {
                this.log.warn(SADIS_NOT_RUNNING);
                Optional<SubscriberAndDeviceInformation> optional = Optional.empty();
                return optional;
            }
            Optional<SubscriberAndDeviceInformation> optional = Optional.ofNullable((SubscriberAndDeviceInformation)this.sadisService.getSubscriberInfoService().get(serialNumber));
            return optional;
        }
        finally {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Device fetched from SADIS. Elapsed {} msec", (Object)(System.currentTimeMillis() - start));
            }
        }
    }

    private Optional<SubscriberAndDeviceInformation> getSubscriberAndDeviceInformation(DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device == null || device.serialNumber() == null) {
            return Optional.empty();
        }
        return this.getSubscriberAndDeviceInformation(device.serialNumber());
    }

    private Set<McastRoute> multicastRoutesOfIgmpProxy() {
        HashSet<McastRoute> routes = new HashSet<McastRoute>();
        this.groupMemberStore.getAllGroupMemberIds().forEach(groupMemberId -> {
            GroupMember groupMember = this.groupMemberStore.getGroupMember((GroupMemberId)groupMemberId);
            if (groupMember != null) {
                groupMember.getSourceList().forEach(source -> routes.add(new McastRoute((IpAddress)source, (IpAddress)groupMemberId.getGroupIp(), McastRoute.Type.IGMP)));
            }
        });
        return routes;
    }

    private void onSourceStateChanged(DeviceId deviceId, PortNumber portNumber, boolean enabled) {
        if (this.multicastService == null) {
            this.log.warn(MCAST_NOT_RUNNING);
            return;
        }
        if (!(IgmpManager.getSource().isPresent() && IgmpManager.getSource().get().deviceId().equals((Object)deviceId) && IgmpManager.getSource().get().port().equals((Object)portNumber))) {
            this.log.debug("{}/{} is not the source cp. Stopped processing it further", (Object)deviceId, (Object)portNumber);
            return;
        }
        this.log.info("source device:port is {}. DeviceId={}, portNumber={}", new Object[]{enabled ? "enabled. Restoring the source" : "disabled. Deleting it from multicast routes", deviceId, portNumber});
        Set<McastRoute> routes = this.multicastRoutesOfIgmpProxy();
        routes.forEach(route -> {
            if (enabled) {
                this.multicastService.addSources(route, (Set)Sets.newHashSet((Object[])new ConnectPoint[]{new ConnectPoint((ElementId)deviceId, portNumber)}));
            } else {
                this.multicastService.removeSources(route, (Set)Sets.newHashSet((Object[])new ConnectPoint[]{new ConnectPoint((ElementId)deviceId, portNumber)}));
            }
        });
    }

    private void provisionUplinkFlows(DeviceId deviceId) {
        if (connectPointMode) {
            return;
        }
        Optional<PortNumber> upLink = this.getDeviceUplink(deviceId);
        if (upLink.isPresent()) {
            this.processFilterObjective(deviceId, upLink.get(), false);
        }
    }

    private void provisionUplinkFlows() {
        if (connectPointMode) {
            return;
        }
        this.deviceService.getAvailableDevices().forEach(device -> {
            Optional<SubscriberAndDeviceInformation> accessDevice = this.getSubscriberAndDeviceInformation(device.id());
            if (accessDevice.isPresent()) {
                this.provisionUplinkFlows(device.id());
            }
        });
    }

    private void unprovisionUplinkFlows() {
        this.deviceService.getAvailableDevices().forEach(device -> {
            Optional<PortNumber> upLink;
            Optional<SubscriberAndDeviceInformation> accessDevices = this.getSubscriberAndDeviceInformation(device.id());
            if (accessDevices.isPresent() && (upLink = this.getDeviceUplink(device.id())).isPresent()) {
                this.processFilterObjective(device.id(), upLink.get(), true);
            }
        });
    }

    private void provisionConnectPointFlows() {
        if (!connectPointMode || connectPoint == null) {
            return;
        }
        this.processFilterObjective(connectPoint.deviceId(), connectPoint.port(), false);
    }

    private void unprovisionConnectPointFlows() {
        if (connectPoint == null) {
            return;
        }
        this.processFilterObjective(connectPoint.deviceId(), connectPoint.port(), true);
    }

    static {
        unSolicitedTimeout = 3;
        keepAliveCount = 3;
        lastQueryInterval = 2;
        lastQueryCount = 2;
        fastLeave = true;
        withRAUplink = true;
        withRADownlink = false;
        periodicQuery = true;
        mvlan = (short)4000;
        mvlanInner = VlanId.NONE.toShort();
        igmpCos = (byte)7;
        igmpUniCos = (byte)7;
        connectPointMode = true;
        connectPoint = null;
        sourceDeviceAndPort = null;
        enableIgmpProvisioning = false;
        igmpOnPodBasis = false;
        outgoingIgmpWithV3 = true;
        MAX_PRIORITY = 10000;
        pimSSmInterworking = false;
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        private void reconfigureNetwork(IgmpproxyConfig cfg) {
            IgmpproxyConfig newCfg = cfg == null ? new IgmpproxyConfig() : cfg;
            unSolicitedTimeout = newCfg.unsolicitedTimeOut();
            IgmpManager.this.maxResp = newCfg.maxResp();
            IgmpManager.this.keepAliveInterval = newCfg.keepAliveInterval();
            keepAliveCount = newCfg.keepAliveCount();
            lastQueryInterval = newCfg.lastQueryInterval();
            lastQueryCount = newCfg.lastQueryCount();
            withRAUplink = newCfg.withRAUplink();
            withRADownlink = newCfg.withRADownlink();
            igmpCos = newCfg.igmpCos();
            igmpUniCos = newCfg.igmpUniCos();
            periodicQuery = newCfg.periodicQuery();
            fastLeave = newCfg.fastLeave();
            pimSSmInterworking = newCfg.pimSsmInterworking();
            enableIgmpProvisioning = newCfg.enableIgmpProvisioning();
            igmpOnPodBasis = newCfg.igmpOnPodBasis();
            if (IgmpManager.this.numberOfIgmpReportProcessorThreads != newCfg.numberOfIgmpReportProcessorThreads()) {
                IgmpManager.this.numberOfIgmpReportProcessorThreads = newCfg.numberOfIgmpReportProcessorThreads();
                IgmpManager.this.shutdownIgmpReportProcessServiceExecutors();
                IgmpManager.this.initializeIgmpReportProcessServiceExecutors();
            }
            if (newCfg.outgoingIgmpWithV3() != null && outgoingIgmpWithV3 != newCfg.outgoingIgmpWithV3()) {
                outgoingIgmpWithV3 = newCfg.outgoingIgmpWithV3();
            }
            if (connectPointMode != newCfg.connectPointMode() || connectPoint != newCfg.connectPoint()) {
                connectPointMode = newCfg.connectPointMode();
                connectPoint = newCfg.connectPoint();
                if (connectPointMode) {
                    IgmpManager.this.unprovisionUplinkFlows();
                    IgmpManager.this.provisionConnectPointFlows();
                } else {
                    IgmpManager.this.unprovisionConnectPointFlows();
                    IgmpManager.this.provisionUplinkFlows();
                }
            }
            if (connectPoint != null) {
                IgmpManager.this.log.info("connect point : {}", (Object)connectPoint);
            }
            IgmpManager.this.log.info("mode: {}", (Object)connectPointMode);
            this.getSourceConnectPoint(newCfg);
            IgmpSender.getInstance().setIgmpCos(igmpCos);
            IgmpSender.getInstance().setIgmpUniCos(igmpUniCos);
            IgmpSender.getInstance().setMaxResp(IgmpManager.this.maxResp);
            IgmpSender.getInstance().setMvlan(mvlan);
            IgmpSender.getInstance().setMvlanInner(mvlanInner);
            IgmpSender.getInstance().setWithRADownlink(withRADownlink);
            IgmpSender.getInstance().setWithRAUplink(withRAUplink);
        }

        void getSourceConnectPoint(IgmpproxyConfig cfg) {
            ConnectPoint oldSourceDevPort = sourceDeviceAndPort;
            sourceDeviceAndPort = cfg.getSourceDeviceAndPort();
            if (sourceDeviceAndPort != null) {
                IgmpManager.this.log.debug("source parameter configured to {}", (Object)sourceDeviceAndPort);
            }
            if (oldSourceDevPort != null && !oldSourceDevPort.equals((Object)sourceDeviceAndPort)) {
                IgmpManager.this.onSourceStateChanged(oldSourceDevPort.deviceId(), oldSourceDevPort.port(), false);
            }
            if (sourceDeviceAndPort != null && !sourceDeviceAndPort.equals((Object)oldSourceDevPort)) {
                IgmpManager.this.onSourceStateChanged(sourceDeviceAndPort.deviceId(), sourceDeviceAndPort.port(), true);
            }
        }

        public void reconfigureSsmTable(IgmpproxySsmTranslateConfig cfg) {
            if (cfg == null) {
                return;
            }
            List<McastRoute> translations = cfg.getSsmTranslations();
            for (McastRoute route : translations) {
                IgmpManager.this.ssmTranslateTable.put(route.group().getIp4Address(), ((IpAddress)route.source().get()).getIp4Address());
            }
        }

        public void event(NetworkConfigEvent event) {
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: {
                    Config config;
                    if (event.configClass().equals(IGMPPROXY_CONFIG_CLASS) && (config = (IgmpproxyConfig)IgmpManager.this.networkConfig.getConfig((Object)appId, IGMPPROXY_CONFIG_CLASS)) != null) {
                        IgmpManager.this.log.info("igmpproxy config received. {}", (Object)config);
                        this.reconfigureNetwork((IgmpproxyConfig)config);
                    }
                    if (event.configClass().equals(IGMPPROXY_SSM_CONFIG_CLASS) && (config = (IgmpproxySsmTranslateConfig)IgmpManager.this.networkConfig.getConfig((Object)appId, IGMPPROXY_SSM_CONFIG_CLASS)) != null) {
                        this.reconfigureSsmTable((IgmpproxySsmTranslateConfig)config);
                    }
                    if (event.configClass().equals(MCAST_CONFIG_CLASS)) {
                        boolean innerVlanConfigChanged;
                        config = (McastConfig)IgmpManager.this.networkConfig.getConfig((Object)IgmpManager.this.coreAppId, MCAST_CONFIG_CLASS);
                        boolean vlanConfigChanged = config != null && mvlan != config.egressVlan().toShort();
                        boolean bl = innerVlanConfigChanged = config != null && mvlanInner != config.egressInnerVlan().toShort();
                        if (vlanConfigChanged || innerVlanConfigChanged) {
                            IgmpManager.this.log.info("igmpproxy vlan config received. {}", (Object)config);
                            IgmpManager.this.groupMemberStore.getAllGroupMembers().forEach(m -> {
                                if (IgmpManager.this.igmpLeadershipService.isLocalLeader(m.getDeviceId())) {
                                    IgmpManager.this.leaveAction((GroupMember)m);
                                }
                            });
                            if (vlanConfigChanged) {
                                mvlan = config.egressVlan().toShort();
                                IgmpSender.getInstance().setMvlan(mvlan);
                            }
                            if (innerVlanConfigChanged) {
                                mvlanInner = config.egressInnerVlan().toShort();
                                IgmpSender.getInstance().setMvlanInner(mvlanInner);
                            }
                        }
                    }
                    IgmpManager.this.log.info("Reconfigured");
                    break;
                }
                case CONFIG_REGISTERED: 
                case CONFIG_UNREGISTERED: {
                    break;
                }
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            IgmpManager.this.eventExecutor.execute(() -> {
                DeviceId devId = ((Device)event.subject()).id();
                Port p = event.port();
                if (!IgmpManager.this.igmpLeadershipService.isLocalLeader(devId)) {
                    return;
                }
                if (IgmpManager.this.getSubscriberAndDeviceInformation(devId).isEmpty() && (p == null || !IgmpManager.this.isConnectPoint(devId, p.number()))) {
                    return;
                }
                switch ((DeviceEvent.Type)event.type()) {
                    case DEVICE_ADDED: 
                    case DEVICE_UPDATED: 
                    case DEVICE_REMOVED: 
                    case DEVICE_SUSPENDED: 
                    case DEVICE_AVAILABILITY_CHANGED: 
                    case PORT_STATS_UPDATED: {
                        break;
                    }
                    case PORT_ADDED: {
                        PortNumber port = p.number();
                        if (IgmpManager.this.getSubscriberAndDeviceInformation(devId).isPresent() && !IgmpManager.this.isUplink(devId, port) && !IgmpManager.this.isConnectPoint(devId, port)) {
                            IgmpManager.this.processFilterObjective(devId, port, false);
                        } else if (IgmpManager.this.isUplink(devId, port)) {
                            IgmpManager.this.provisionUplinkFlows();
                        } else if (IgmpManager.this.isConnectPoint(devId, port)) {
                            IgmpManager.this.provisionConnectPointFlows();
                        }
                        IgmpManager.this.onSourceStateChanged(devId, port, true);
                        break;
                    }
                    case PORT_UPDATED: {
                        PortNumber port = p.number();
                        if (IgmpManager.this.getSubscriberAndDeviceInformation(devId).isPresent() && !IgmpManager.this.isUplink(devId, port) && !IgmpManager.this.isConnectPoint(devId, port)) {
                            IgmpManager.this.processFilterObjective(devId, port, !event.port().isEnabled());
                        } else if (IgmpManager.this.isUplink(devId, port)) {
                            if (event.port().isEnabled()) {
                                IgmpManager.this.provisionUplinkFlows(devId);
                            } else {
                                IgmpManager.this.processFilterObjective(devId, port, true);
                            }
                        } else if (IgmpManager.this.isConnectPoint(devId, port)) {
                            if (event.port().isEnabled()) {
                                IgmpManager.this.provisionConnectPointFlows();
                            } else {
                                IgmpManager.this.unprovisionConnectPointFlows();
                            }
                        }
                        IgmpManager.this.onSourceStateChanged(devId, port, event.port().isEnabled());
                        break;
                    }
                    case PORT_REMOVED: {
                        PortNumber port = p.number();
                        IgmpManager.this.processFilterObjective(devId, port, true);
                        IgmpManager.this.onSourceStateChanged(devId, port, false);
                        break;
                    }
                    default: {
                        IgmpManager.this.log.info("Unknown device event {}", (Object)event.type());
                    }
                }
            });
        }

        public boolean isRelevant(DeviceEvent event) {
            return true;
        }
    }

    private class IgmpProxyTimerTask
    extends TimerTask {
        private IgmpProxyTimerTask() {
        }

        @Override
        public void run() {
            try {
                IgmpManager.this.stateMachineService.timeOut1s();
                this.queryMembers();
            }
            catch (Exception ex) {
                IgmpManager.this.log.warn("Igmp timer task error : {}", (Object)ex.getMessage());
            }
        }

        private void queryMembers() {
            Set<GroupMemberId> keySet = IgmpManager.this.groupMemberStore.getAllGroupMemberIds();
            for (GroupMemberId key : keySet) {
                DeviceId did;
                GroupMember groupMember = IgmpManager.this.groupMemberStore.getGroupMember(key);
                if (groupMember == null || !IgmpManager.this.igmpLeadershipService.isLocalLeader(did = groupMember.getDeviceId())) continue;
                if (groupMember.isLeave()) {
                    this.lastQuery(groupMember);
                    continue;
                }
                if (!periodicQuery) continue;
                this.periodicQuery(groupMember);
            }
        }

        private void lastQuery(GroupMember groupMember) {
            if (groupMember.getLastQueryInterval() < lastQueryInterval) {
                groupMember.lastQueryInterval(true);
                IgmpManager.this.groupMemberStore.updateGroupMember(groupMember);
            } else if (groupMember.getLastQueryCount() < lastQueryCount - 1) {
                IgmpManager.this.sendQuery(groupMember);
                groupMember.lastQueryInterval(false);
                groupMember.lastQueryCount(true);
                IgmpManager.this.groupMemberStore.updateGroupMember(groupMember);
            } else if (groupMember.getLastQueryCount() == lastQueryCount - 1) {
                IgmpManager.this.leaveAction(groupMember);
            }
        }

        private void periodicQuery(GroupMember groupMember) {
            if (groupMember.getKeepAliveQueryInterval() < IgmpManager.this.keepAliveInterval) {
                groupMember.keepAliveInterval(true);
                IgmpManager.this.groupMemberStore.updateGroupMember(groupMember);
            } else if (groupMember.getKeepAliveQueryCount() < keepAliveCount) {
                IgmpManager.this.sendQuery(groupMember);
                groupMember.keepAliveInterval(false);
                groupMember.keepAliveQueryCount(true);
                IgmpManager.this.groupMemberStore.updateGroupMember(groupMember);
            } else if (groupMember.getKeepAliveQueryCount() == keepAliveCount) {
                IgmpManager.this.leaveAction(groupMember);
            }
        }
    }

    private class IgmpPacketProcessor
    implements PacketProcessor {
        private IgmpPacketProcessor() {
        }

        public void process(PacketContext context) {
            IgmpManager.this.eventExecutor.execute(() -> {
                try {
                    InboundPacket pkt = context.inPacket();
                    IgmpManager.this.log.debug("IgmpPacketProcessor shall process InboundPacket: {}", (Object)pkt);
                    Ethernet ethPkt = pkt.parsed();
                    if (ethPkt == null) {
                        return;
                    }
                    IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.TOTAL_MSG_RECEIVED);
                    if (ethPkt.getEtherType() != Ethernet.TYPE_IPV4) {
                        return;
                    }
                    IPv4 ipv4Pkt = (IPv4)ethPkt.getPayload();
                    if (ipv4Pkt.getProtocol() != 2) {
                        return;
                    }
                    IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_VALID_CHECKSUM_COUNTER);
                    short vlan = ethPkt.getVlanID();
                    DeviceId deviceId = pkt.receivedFrom().deviceId();
                    if (!IgmpManager.this.isConnectPoint(deviceId, pkt.receivedFrom().port()) && !IgmpManager.this.getSubscriberAndDeviceInformation(deviceId).isPresent()) {
                        IgmpManager.this.log.error("Device not registered in netcfg : {}", (Object)deviceId);
                        IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.FAIL_JOIN_REQ_INSUFF_PERMISSION_ACCESS_COUNTER);
                        return;
                    }
                    IGMP igmp = (IGMP)ipv4Pkt.getPayload();
                    Optional<PortNumber> deviceUpLinkOpt = IgmpManager.this.getDeviceUplink(deviceId);
                    PortNumber upLinkPort = deviceUpLinkOpt.isPresent() ? deviceUpLinkOpt.get() : null;
                    switch (igmp.getIgmpType()) {
                        case 17: {
                            IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_V3_MEMBERSHIP_QUERY);
                            if (!pkt.receivedFrom().port().equals((Object)upLinkPort)) {
                                if (IgmpManager.this.isConnectPoint(deviceId, pkt.receivedFrom().port())) {
                                    IgmpManager.this.log.info("IGMP Picked up query from connectPoint");
                                    IgmpManager.this.processIgmpConnectPointQuery((IGMPQuery)igmp.getGroups().get(0), pkt.receivedFrom(), 0xFF & igmp.getMaxRespField());
                                    break;
                                }
                                IgmpManager.this.log.warn("IGMP Picked up query from non-uplink port {}", (Object)upLinkPort);
                                return;
                            }
                            IgmpManager.this.processIgmpQuery((IGMPQuery)igmp.getGroups().get(0), pkt.receivedFrom(), 0xFF & igmp.getMaxRespField());
                            break;
                        }
                        case 18: {
                            IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_V1_MEMBERSHIP_REPORT);
                            IgmpManager.this.log.debug("IGMP version 1  message types are not currently supported.");
                            break;
                        }
                        case 34: {
                            IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_V3_MEMBERSHIP_REPORT);
                            IgmpManager.this.processIgmpMessage(pkt, igmp, upLinkPort, vlan);
                            break;
                        }
                        case 22: {
                            IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_V2_MEMBERSHIP_REPORT);
                            IgmpManager.this.processIgmpMessage(pkt, igmp, upLinkPort, vlan);
                            break;
                        }
                        case 23: {
                            IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.IGMP_V2_LEAVE_GROUP);
                            IgmpManager.this.processIgmpMessage(pkt, igmp, upLinkPort, vlan);
                            break;
                        }
                        default: {
                            IgmpManager.this.log.warn("Unknown IGMP message type: {}", (Object)igmp.getIgmpType());
                            IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.INVALID_IGMP_MSG_RECEIVED);
                            IgmpManager.this.igmpStatisticsManager.increaseStat(IgmpStatisticType.UNKNOWN_IGMP_TYPE_PACKETS_RX_COUNTER);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    IgmpManager.this.log.error("igmp process error : ", (Throwable)ex);
                }
            });
        }
    }
}

