/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl;

import java.nio.ByteBuffer;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IGMP;
import org.onlab.packet.IGMPGroup;
import org.onlab.packet.IGMPMembership;
import org.onlab.packet.IGMPQuery;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketService;
import org.opencord.igmpproxy.IgmpLeadershipService;
import org.opencord.igmpproxy.IgmpStatisticType;
import org.opencord.igmpproxy.IgmpStatisticsService;
import org.opencord.igmpproxy.impl.IgmpManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IgmpSender {
    static final String V3_REPORT_ADDRESS = "224.0.0.22";
    static final String V2_LEAVE_DST = "224.0.0.2";
    static final String MAC_ADDRESS = "DE:AD:BE:EF:BA:11";
    static final short DEFAULT_MVLAN = 4000;
    static final byte DEFAULT_COS = 7;
    static final int DEFAULT_MEX_RESP = 10;
    static final byte[] RA_BYTES = new byte[]{-108, 4, 0, 0};
    private static IgmpSender instance = null;
    private PacketService packetService;
    private IgmpLeadershipService igmpLeadershipService;
    private IgmpStatisticsService igmpStatisticsService;
    private boolean withRAUplink = true;
    private boolean withRADownlink = false;
    private short mvlan = (short)4000;
    private short mvlanInner = VlanId.NONE.toShort();
    private byte igmpCos = (byte)7;
    private byte igmpUniCos = (byte)7;
    private int maxResp = 10;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    private IgmpSender(PacketService packetService, IgmpStatisticsService igmpStatisticsService) {
        this.packetService = packetService;
        this.igmpStatisticsService = igmpStatisticsService;
    }

    public static void init(PacketService packetService, IgmpStatisticsService igmpStatisticsService) {
        instance = new IgmpSender(packetService, igmpStatisticsService);
    }

    public static IgmpSender getInstance() {
        return instance;
    }

    public void setWithRAUplink(boolean withRaUplink) {
        this.withRAUplink = withRaUplink;
    }

    public void setWithRADownlink(boolean withRADownlink) {
        this.withRADownlink = withRADownlink;
    }

    public void setMvlan(short mvlan) {
        this.mvlan = mvlan;
    }

    public void setMvlanInner(short mvlanInner) {
        this.mvlanInner = mvlanInner;
    }

    public void setIgmpCos(byte igmpCos) {
        this.igmpCos = igmpCos;
    }

    public void setIgmpUniCos(byte igmpUniCos) {
        this.igmpUniCos = igmpUniCos;
    }

    public void setMaxResp(int maxResp) {
        this.maxResp = maxResp;
    }

    public Ethernet buildIgmpV3Join(Ip4Address groupIp, Ip4Address sourceIp) {
        IGMPMembership igmpMembership = new IGMPMembership(groupIp);
        igmpMembership.setRecordType((byte)4);
        return this.buildIgmpPacket((byte)34, groupIp, igmpMembership, sourceIp, false, this.mvlan, this.mvlanInner, this.igmpCos);
    }

    public Ethernet buildIgmpV2Join(Ip4Address groupIp, Ip4Address sourceIp) {
        IGMPMembership igmpMembership = new IGMPMembership(groupIp);
        return this.buildIgmpPacket((byte)22, groupIp, igmpMembership, sourceIp, true, this.mvlan, this.mvlanInner, this.igmpCos);
    }

    public Ethernet buildIgmpV2ResponseQuery(Ip4Address groupIp, Ip4Address sourceIp) {
        return this.buildIgmpV2Join(groupIp, sourceIp);
    }

    public Ethernet buildIgmpV3ResponseQuery(Ip4Address groupIp, Ip4Address sourceIp) {
        IGMPMembership igmpMembership = new IGMPMembership(groupIp);
        igmpMembership.setRecordType((byte)2);
        return this.buildIgmpPacket((byte)34, groupIp, igmpMembership, sourceIp, false, this.mvlan, this.mvlanInner, this.igmpCos);
    }

    public Ethernet buildIgmpV3Leave(Ip4Address groupIp, Ip4Address sourceIp) {
        IGMPMembership igmpMembership = new IGMPMembership(groupIp);
        igmpMembership.setRecordType((byte)3);
        return this.buildIgmpPacket((byte)34, groupIp, igmpMembership, sourceIp, false, this.mvlan, this.mvlanInner, this.igmpCos);
    }

    public Ethernet buildIgmpV2Leave(Ip4Address groupIp, Ip4Address sourceIp) {
        IGMPMembership igmpMembership = new IGMPMembership(groupIp);
        return this.buildIgmpPacket((byte)23, groupIp, igmpMembership, sourceIp, true, this.mvlan, this.mvlanInner, this.igmpCos);
    }

    public Ethernet buildIgmpV2Query(Ip4Address groupIp, Ip4Address sourceIp, short vlan) {
        return this.buildIgmpPacket((byte)17, groupIp, null, sourceIp, true, vlan, VlanId.NONE.toShort(), this.igmpUniCos);
    }

    public Ethernet buildIgmpV3Query(Ip4Address groupIp, Ip4Address sourceIp, short vlan) {
        return this.buildIgmpPacket((byte)17, groupIp, null, sourceIp, false, vlan, VlanId.NONE.toShort(), this.igmpUniCos);
    }

    protected Ethernet buildIgmpPacket(byte type, Ip4Address groupIp, IGMPMembership igmpMembership, Ip4Address sourceIp, boolean isV2Query, short vlan, short innerVlan, byte igmpCos) {
        Object igmpPacket = isV2Query ? new IGMP.IGMPv2() : new IGMP.IGMPv3();
        IPv4 ip4Packet = new IPv4();
        Ethernet ethPkt = new Ethernet();
        ethPkt.setPad(true);
        igmpPacket.setIgmpType(type);
        switch (type) {
            case 17: {
                igmpPacket.setMaxRespCode((byte)(this.maxResp * 10));
                IGMPQuery igmpQuery = new IGMPQuery((IpAddress)groupIp, 0);
                igmpPacket.addGroup((IGMPGroup)igmpQuery);
                ip4Packet.setDestinationAddress(groupIp.toInt());
                if (!this.withRADownlink) break;
                ip4Packet.setOptions(RA_BYTES);
                break;
            }
            case 34: {
                if (igmpMembership == null) {
                    this.log.debug("Igmp membership is not found. igmp-type {} ", (Object)type);
                    return null;
                }
                igmpPacket.addGroup((IGMPGroup)igmpMembership);
                ip4Packet.setDestinationAddress(Ip4Address.valueOf((String)V3_REPORT_ADDRESS).toInt());
                if (!this.withRAUplink) break;
                ip4Packet.setOptions(RA_BYTES);
                break;
            }
            case 22: 
            case 23: {
                if (igmpMembership == null) {
                    this.log.debug("Igmp membership is not found. igmp-type {} ", (Object)type);
                    return null;
                }
                igmpPacket.addGroup((IGMPGroup)igmpMembership);
                int dst = type == 22 ? groupIp.toInt() : Ip4Address.valueOf((String)V2_LEAVE_DST).toInt();
                ip4Packet.setDestinationAddress(dst);
                break;
            }
            default: {
                this.log.debug("Unknown igmp type: {} ", (Object)type);
                this.igmpStatisticsService.increaseStat(IgmpStatisticType.UNKNOWN_IGMP_TYPE_PACKETS_RX_COUNTER);
                return null;
            }
        }
        igmpPacket.setParent((IPacket)ip4Packet);
        ip4Packet.setSourceAddress(sourceIp.toInt());
        ip4Packet.setProtocol((byte)2);
        ip4Packet.setPayload((IPacket)igmpPacket);
        ip4Packet.setParent((IPacket)ethPkt);
        ip4Packet.setTtl((byte)120);
        ethPkt.setDestinationMACAddress(this.multiaddToMac(ip4Packet.getDestinationAddress()));
        ethPkt.setSourceMACAddress(MAC_ADDRESS);
        ethPkt.setEtherType(Ethernet.TYPE_IPV4);
        ethPkt.setPayload((IPacket)ip4Packet);
        ethPkt.setVlanID(vlan);
        ethPkt.setPriorityCode(igmpCos);
        if (innerVlan != VlanId.NONE.toShort()) {
            ethPkt.setQinQTPID(Ethernet.TYPE_VLAN);
            ethPkt.setQinQVID(vlan);
            ethPkt.setVlanID(innerVlan);
            ethPkt.setQinQPriorityCode(igmpCos);
        }
        return ethPkt;
    }

    private MacAddress multiaddToMac(int multiaddress) {
        byte[] b = new byte[]{(byte)(multiaddress & 0xFF), (byte)(multiaddress >> 8 & 0xFF), (byte)(multiaddress >> 16 & 0x7F)};
        byte[] macByte = new byte[]{1, 0, 94, b[2], b[1], b[0]};
        MacAddress mac = MacAddress.valueOf((byte[])macByte);
        return mac;
    }

    public void sendIgmpPacketUplink(Ethernet ethPkt, DeviceId deviceId, PortNumber upLinkPort) {
        if (IgmpManager.connectPointMode) {
            if (IgmpManager.connectPoint == null) {
                this.log.warn("cannot find a connectPoint to send the packet uplink");
                return;
            }
            this.sendIgmpPacket(ethPkt, IgmpManager.connectPoint.deviceId(), IgmpManager.connectPoint.port());
        } else {
            this.sendIgmpPacket(ethPkt, deviceId, upLinkPort);
        }
    }

    public void sendIgmpPacket(Ethernet ethPkt, DeviceId deviceId, PortNumber portNumber) {
        IPv4 ipv4Pkt;
        IGMP igmp;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Emitting on {}/{} outbound IGMP packet {}", new Object[]{deviceId, portNumber, ethPkt});
        }
        if (((igmp = (IGMP)(ipv4Pkt = (IPv4)ethPkt.getPayload()).getPayload()).getIgmpType() == 22 || igmp.getIgmpType() == 34 || igmp.getIgmpType() == 23) && igmp.getGroups().isEmpty()) {
            this.igmpStatisticsService.increaseStat(IgmpStatisticType.INVALID_IGMP_LENGTH);
        }
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(portNumber).build();
        DefaultOutboundPacket packet = new DefaultOutboundPacket(deviceId, treatment, ByteBuffer.wrap(ethPkt.serialize()));
        this.igmpStatisticsService.increaseStat(IgmpStatisticType.VALID_IGMP_PACKET_COUNTER);
        this.packetService.emit((OutboundPacket)packet);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Emitted on {}/{} outbound IGMP packet {}", new Object[]{deviceId, portNumber, packet});
        }
    }
}

