/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl;

import com.google.common.base.Strings;
import java.util.Dictionary;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onlab.util.KryoNamespace;
import org.onlab.util.SafeRecurringTask;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.opencord.igmpproxy.IgmpLeadershipService;
import org.opencord.igmpproxy.IgmpStatisticType;
import org.opencord.igmpproxy.IgmpStatistics;
import org.opencord.igmpproxy.IgmpStatisticsEvent;
import org.opencord.igmpproxy.IgmpStatisticsEventListener;
import org.opencord.igmpproxy.IgmpStatisticsService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"statisticsGenerationPeriodInSeconds:Integer=20", "statisticsSyncPeriodInSeconds:Integer=10"})
public class IgmpStatisticsManager
extends AbstractListenerManager<IgmpStatisticsEvent, IgmpStatisticsEventListener>
implements IgmpStatisticsService {
    private static final String IGMP_STATISTICS = "igmp-statistics";
    private static final String IGMP_STATISTICS_LEADERSHIP = "igmp-statistics";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private IgmpStatistics igmpStats;
    private ScheduledExecutorService executorForIgmp;
    private ScheduledFuture<?> publisherTask;
    private ScheduledFuture<?> syncTask;
    protected int statisticsGenerationPeriodInSeconds = 20;
    protected int statisticsSyncPeriodInSeconds = 10;
    private EventuallyConsistentMap<NodeId, IgmpStatistics> statistics;
    private static final MessageSubject RESET_SUBJECT = new MessageSubject("igmp-statistics-reset");
    private KryoNamespace statSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{IgmpStatistics.class}).register(new Class[]{ClusterMessage.class}).register(new Class[]{MessageSubject.class}).build();
    private AtomicBoolean validityCheck = new AtomicBoolean(false);
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected IgmpLeadershipService leadershipManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ClusterCommunicationService clusterCommunicationService;

    @Activate
    public void activate(ComponentContext context) {
        this.igmpStats = this.getIgmpStatsInstance();
        this.statistics = this.storageService.eventuallyConsistentMapBuilder().withName("igmp-statistics").withSerializer(this.statSerializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.initStats((IgmpStatistics)this.statistics.get((Object)this.leadershipManager.getLocalNodeId()));
        this.syncStats();
        this.leadershipManager.runForLeadership("igmp-statistics");
        this.eventDispatcher.addSink(IgmpStatisticsEvent.class, (EventSink)this.listenerRegistry);
        this.executorForIgmp = Executors.newScheduledThreadPool(1);
        this.cfgService.registerProperties(((Object)((Object)this)).getClass());
        this.clusterCommunicationService.addSubscriber(RESET_SUBJECT, arg_0 -> ((Serializer)Serializer.using((KryoNamespace)this.statSerializer)).decode(arg_0), this::resetLocal, (Executor)this.executorForIgmp);
        this.modified(context);
        this.log.info("IgmpStatisticsManager Activated");
    }

    @Modified
    public void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        try {
            String s = Tools.get((Dictionary)properties, (String)"statisticsGenerationPeriodInSeconds");
            this.statisticsGenerationPeriodInSeconds = Strings.isNullOrEmpty((String)s) ? Integer.parseInt("statisticsGenerationPeriodInSeconds") : Integer.parseInt(s.trim());
            this.log.debug("statisticsGenerationPeriodInSeconds: {}", (Object)this.statisticsGenerationPeriodInSeconds);
            this.statisticsSyncPeriodInSeconds = Strings.isNullOrEmpty((String)s) ? Integer.parseInt("statisticsSyncPeriodInSeconds") : Integer.parseInt(s.trim());
            this.log.debug("statisticsSyncPeriodInSeconds: {}", (Object)this.statisticsSyncPeriodInSeconds);
        }
        catch (NumberFormatException ne) {
            this.log.error("Unable to parse configuration parameter", (Throwable)ne);
            this.statisticsGenerationPeriodInSeconds = 20;
            this.statisticsSyncPeriodInSeconds = 10;
        }
        this.stopPublishTask();
        this.stopSyncTask();
        this.startPublishTask();
        this.startSyncTask();
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(IgmpStatisticsEvent.class);
        this.stopPublishTask();
        this.stopSyncTask();
        this.executorForIgmp.shutdown();
        this.cfgService.unregisterProperties(((Object)((Object)this)).getClass(), false);
        this.igmpStats = null;
        this.clusterCommunicationService.removeSubscriber(RESET_SUBJECT);
        this.leadershipManager.withdraw("igmp-statistics");
        this.log.info("IgmpStatisticsManager Deactivated");
    }

    private IgmpStatistics getIgmpStatsInstance() {
        if (this.igmpStats == null) {
            this.igmpStats = new IgmpStatistics();
            this.log.info("Instance of igmp-statistics created.");
        }
        return this.igmpStats;
    }

    private void syncStats() {
        if (!this.validityCheck.get()) {
            this.statistics.put((Object)this.leadershipManager.getLocalNodeId(), (Object)this.snapshot());
            this.validityCheck.set(true);
            this.log.debug("Valid statistic values are put.");
        }
    }

    private void initStats(IgmpStatistics init) {
        if (init == null) {
            this.log.warn("Igmp statistics was not created.");
            return;
        }
        this.igmpStats.setStats(init);
    }

    private IgmpStatistics snapshot() {
        return this.getIgmpStatsInstance();
    }

    private void startSyncTask() {
        this.syncTask = this.startTask(this::syncStats, this.statisticsSyncPeriodInSeconds);
        this.log.debug("Sync task started. period in seconds: {}", (Object)this.statisticsSyncPeriodInSeconds);
    }

    private void stopSyncTask() {
        this.stopTask(this.syncTask);
        this.log.debug("Sync task stopped.");
    }

    private void startPublishTask() {
        this.publisherTask = this.startTask(this::publishStats, this.statisticsGenerationPeriodInSeconds);
        this.log.debug("Publisher task started. period in seconds: {}", (Object)this.statisticsGenerationPeriodInSeconds);
    }

    private void stopPublishTask() {
        this.stopTask(this.publisherTask);
        this.log.debug("Publisher task stopped.");
    }

    private ScheduledFuture<?> startTask(Runnable r, int rate) {
        return this.executorForIgmp.scheduleAtFixedRate((Runnable)SafeRecurringTask.wrap((Runnable)r), 0L, rate, TimeUnit.SECONDS);
    }

    private void stopTask(ScheduledFuture<?> task) {
        if (task != null) {
            task.cancel(true);
        }
    }

    private void resetLocal(ClusterMessage message) {
        this.igmpStats.resetAll();
        this.validityCheck.set(false);
    }

    private void publishStats() {
        if (!Objects.equals(this.leadershipManager.getLeader("igmp-statistics"), this.leadershipManager.getLocalNodeId())) {
            this.log.debug("This is not leader of : {}", (Object)"igmp-statistics");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Notifying stats: {}", (Object)this.igmpStats);
            this.log.debug("--IgmpDisconnect--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_DISCONNECT));
            this.log.debug("--IgmpFailJoinReq--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_FAIL_JOIN_REQ));
            this.log.debug("--IgmpJoinReq--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_JOIN_REQ));
            this.log.debug("--IgmpLeaveReq--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_LEAVE_REQ));
            this.log.debug("--IgmpMsgReceived--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_MSG_RECEIVED));
            this.log.debug("--IgmpSuccessJoinRejoinReq--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_SUCCESS_JOIN_RE_JOIN_REQ));
            this.log.debug("--Igmpv1MemershipReport--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_V1_MEMBERSHIP_REPORT));
            this.log.debug("--Igmpv2LeaveGroup--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_V2_LEAVE_GROUP));
            this.log.debug("--Igmpv2MembershipReport--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_V2_MEMBERSHIP_REPORT));
            this.log.debug("--Igmpv3MembershipQuery--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_V3_MEMBERSHIP_QUERY));
            this.log.debug("--Igmpv3MembershipReport--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_V3_MEMBERSHIP_REPORT));
            this.log.debug("--InvalidIgmpMsgReceived--" + this.igmpStats.getStat(IgmpStatisticType.INVALID_IGMP_MSG_RECEIVED));
            this.log.debug("--TotalMsgReceived--  " + this.igmpStats.getStat(IgmpStatisticType.TOTAL_MSG_RECEIVED));
            this.log.debug("--UnknownIgmpTypePacketsRx--" + this.igmpStats.getStat(IgmpStatisticType.UNKNOWN_IGMP_TYPE_PACKETS_RX_COUNTER));
            this.log.debug("--ReportsRxWithWrongMode--" + this.igmpStats.getStat(IgmpStatisticType.REPORTS_RX_WITH_WRONG_MODE_COUNTER));
            this.log.debug("--FailJoinReqInsuffPermission--" + this.igmpStats.getStat(IgmpStatisticType.FAIL_JOIN_REQ_INSUFF_PERMISSION_ACCESS_COUNTER));
            this.log.debug("--FailJoinReqUnknownMulticastIp--" + this.igmpStats.getStat(IgmpStatisticType.FAIL_JOIN_REQ_UNKNOWN_MULTICAST_IP_COUNTER));
            this.log.debug("--UnconfiguredGroupCounter--" + this.igmpStats.getStat(IgmpStatisticType.UNCONFIGURED_GROUP_COUNTER));
            this.log.debug("--ValidIgmpPacketCounter--" + this.igmpStats.getStat(IgmpStatisticType.VALID_IGMP_PACKET_COUNTER));
            this.log.debug("--IgmpChannelJoinCounter--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_CHANNEL_JOIN_COUNTER));
            this.log.debug("--CurrentGrpNumCounter--" + this.igmpStats.getStat(IgmpStatisticType.CURRENT_GRP_NUMBER_COUNTER));
            this.log.debug("--IgmpValidChecksumCounter--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_VALID_CHECKSUM_COUNTER));
            this.log.debug("--InvalidIgmpLength--" + this.igmpStats.getStat(IgmpStatisticType.INVALID_IGMP_LENGTH));
            this.log.debug("--IgmpGeneralMembershipQuery--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_GENERAL_MEMBERSHIP_QUERY));
            this.log.debug("--IgmpGrpSpecificMembershipQuery--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_GRP_SPECIFIC_MEMBERSHIP_QUERY));
            this.log.debug("--IgmpGrpAndSrcSpecificMembershipQuery--" + this.igmpStats.getStat(IgmpStatisticType.IGMP_GRP_AND_SRC_SPESIFIC_MEMBERSHIP_QUERY));
        }
        this.post((Event)new IgmpStatisticsEvent(IgmpStatisticsEvent.Type.STATS_UPDATE, this.igmpStats));
    }

    public void increaseStat(IgmpStatisticType type) {
        this.igmpStats.increaseStat(type);
        this.validityCheck.set(false);
    }

    public void resetAllStats() {
        ClusterMessage reset = new ClusterMessage(this.leadershipManager.getLocalNodeId(), RESET_SUBJECT, new byte[0]);
        this.clusterCommunicationService.broadcastIncludeSelf((Object)reset, RESET_SUBJECT, arg_0 -> ((Serializer)Serializer.using((KryoNamespace)this.statSerializer)).encode(arg_0));
    }

    public Long getStat(IgmpStatisticType type) {
        return this.igmpStats.getStat(type);
    }
}

