/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.mcast.api.McastRoute;
import org.onosproject.net.config.Config;

public class IgmpproxySsmTranslateConfig
extends Config<ApplicationId> {
    private static final String SOURCE = "source";
    private static final String GROUP = "group";

    public boolean isValid() {
        for (JsonNode node : this.array) {
            if (!this.hasOnlyFields((ObjectNode)node, new String[]{SOURCE, GROUP})) {
                return false;
            }
            if (this.isIpAddress((ObjectNode)node, SOURCE, Config.FieldPresence.MANDATORY) && this.isIpAddress((ObjectNode)node, GROUP, Config.FieldPresence.MANDATORY)) continue;
            return false;
        }
        return true;
    }

    public List<McastRoute> getSsmTranslations() {
        ArrayList translations = Lists.newArrayList();
        for (JsonNode node : this.array) {
            translations.add(new McastRoute(IpAddress.valueOf((String)node.path(SOURCE).asText().trim()), IpAddress.valueOf((String)node.path(GROUP).asText().trim()), McastRoute.Type.STATIC));
        }
        return translations;
    }
}

