/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.opencord.igmpproxy.impl.state.DelayMember;
import org.opencord.igmpproxy.impl.state.IdleMember;
import org.opencord.igmpproxy.impl.state.NonMember;
import org.opencord.igmpproxy.statemachine.State;
import org.opencord.igmpproxy.statemachine.StateMachine;
import org.opencord.igmpproxy.statemachine.StateMachineId;

public final class SingleStateMachine
implements StateMachine {
    public static final int DEFAULT_MAX_RESP = 0xFFFFFFF;
    private StateMachineId stateMachineId;
    private int currentState;
    private Ip4Address srcIp;
    private PortNumber upLinkPort;
    private AtomicInteger timeOut;
    private State[] states;
    private int[] nonTransition = new int[]{1, 0, 0, 0};
    private int[] delayTransition = new int[]{1, 0, 1, 2};
    private int[] idleTransition = new int[]{2, 0, 1, 2};
    private int[][] transition = new int[][]{this.nonTransition, this.delayTransition, this.idleTransition};

    private SingleStateMachine() {
        this.stateMachineId = null;
        this.srcIp = null;
        this.upLinkPort = null;
        this.timeOut = null;
        this.states = null;
    }

    public SingleStateMachine(DeviceId deviceId, Ip4Address groupIp, Ip4Address srcIp, PortNumber upLinkPort) {
        this.stateMachineId = StateMachineId.of((DeviceId)deviceId, (Ip4Address)groupIp);
        this.srcIp = srcIp;
        this.upLinkPort = upLinkPort;
        this.currentState = 0;
        this.timeOut = null;
        this.states = new State[]{new NonMember(this), new DelayMember(this), new IdleMember(this)};
    }

    public SingleStateMachine(StateMachineId machineId, Ip4Address srcIp, PortNumber upLinkPort, int currentState, Integer timeout) {
        this.stateMachineId = machineId;
        this.srcIp = srcIp;
        this.upLinkPort = upLinkPort;
        this.currentState = currentState;
        if (timeout != null) {
            this.createTimeOut(timeout);
        } else {
            this.timeOut = null;
        }
        this.states = new State[]{new NonMember(this), new DelayMember(this), new IdleMember(this)};
    }

    public StateMachineId getStateMachineId() {
        return this.stateMachineId;
    }

    public Ip4Address getGroupIp() {
        return this.stateMachineId.getGroupIp();
    }

    public DeviceId getDeviceId() {
        return this.stateMachineId.getDeviceId();
    }

    public Ip4Address getSrcIp() {
        return this.srcIp;
    }

    public PortNumber getUpLinkPort() {
        return this.upLinkPort;
    }

    public int currentState() {
        return this.currentState;
    }

    public Integer getTimeOut() {
        return this.timeOut == null ? null : Integer.valueOf(this.timeOut.get());
    }

    public void increaseTimeOut() {
        this.timeOut.getAndIncrement();
    }

    public void decreaseTimeOut() {
        this.timeOut.getAndDecrement();
    }

    public void setMaxTimeout() {
        this.timeOut.set(0xFFFFFFF);
    }

    public void startTimer(int timeout) {
        this.createTimeOut(timeout);
    }

    public void resetTimer(int timeout) {
        this.setTimeOut(timeout);
    }

    public void destroyTimer() {
        this.setTimeOut(null);
    }

    public void join(boolean messageOutAllowed) {
        if (messageOutAllowed) {
            State state = this.states[this.currentState];
            state.join();
        }
        this.next(0);
    }

    public void leave(boolean messageOutAllowed) {
        if (messageOutAllowed) {
            State state = this.states[this.currentState];
            state.leave();
        }
        this.next(1);
    }

    public void query(int maxResp) {
        State state = this.states[this.currentState];
        state.query(maxResp);
        this.next(2);
    }

    public void timeOut(boolean sendQuery) {
        if (sendQuery) {
            State state = this.states[this.currentState];
            state.timeOut();
        }
        this.next(3);
    }

    private void next(int msg) {
        this.currentState = this.transition[this.currentState][msg];
    }

    private void setTimeOut(int timeout) {
        this.timeOut.set(timeout);
    }

    private void setTimeOut(Integer timeout) {
        if (timeout == null) {
            this.timeOut = null;
        } else {
            this.timeOut.set(timeout);
        }
    }

    private void createTimeOut(Integer timeout) {
        this.timeOut = new AtomicInteger(timeout);
    }
}

