/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl;

import java.util.Collection;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.opencord.igmpproxy.IgmpLeadershipService;
import org.opencord.igmpproxy.impl.IgmpManager;
import org.opencord.igmpproxy.impl.SingleStateMachine;
import org.opencord.igmpproxy.impl.store.machine.StateMachineStore;
import org.opencord.igmpproxy.statemachine.StateMachine;
import org.opencord.igmpproxy.statemachine.StateMachineId;
import org.opencord.igmpproxy.statemachine.StateMachineService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={StateMachineService.class})
public class StateMachineManager
implements StateMachineService {
    public static boolean sendQuery = true;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected StateMachineStore stateMachineStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected IgmpLeadershipService igmpLeadershipService;

    @Activate
    public void activate(ComponentContext context) {
        this.log.info("Started.");
    }

    @Deactivate
    public void deactivate(ComponentContext context) {
        this.log.info("Stopped.");
    }

    private StateMachine get(DeviceId devId, Ip4Address groupIp) {
        StateMachineId id = StateMachineId.of((DeviceId)devId, (Ip4Address)groupIp);
        return this.stateMachineStore.getStateMachine(id);
    }

    public void destroySingle(DeviceId devId, Ip4Address groupIp) {
        StateMachine machine = this.get(devId, groupIp);
        if (machine == null) {
            this.log.debug("Machine has already been destroyed. deviceId: {} and groupIp: {} ", (Object)devId, (Object)groupIp);
            return;
        }
        this.stateMachineStore.removeStateMachine(machine.getStateMachineId());
        this.stateMachineStore.removeCounter(machine.getStateMachineId());
    }

    public boolean join(DeviceId devId, Ip4Address groupIp, Ip4Address srcIP, PortNumber upLinkPort) {
        StateMachine machineInstance = this.get(devId, groupIp);
        if (machineInstance == null) {
            machineInstance = new SingleStateMachine(devId, groupIp, srcIP, upLinkPort);
            this.stateMachineStore.putStateMachine(machineInstance);
            this.stateMachineStore.increaseAndGetCounter(machineInstance.getStateMachineId());
            this.log.debug("Instance of machine created with id: {}", (Object)machineInstance.getStateMachineId());
            boolean shouldSendJoin = true;
            if (IgmpManager.isIgmpOnPodBasis() && this.groupListenedByOtherDevices(devId, groupIp)) {
                shouldSendJoin = false;
            }
            machineInstance.join(shouldSendJoin);
            this.stateMachineStore.updateStateMachine(machineInstance);
            return true;
        }
        this.log.debug("Instance of machine has already been created. deviceId: {} and groupIp: {}", (Object)devId, (Object)groupIp);
        this.stateMachineStore.increaseAndGetCounter(machineInstance.getStateMachineId());
        return false;
    }

    public boolean leave(DeviceId devId, Ip4Address groupIp) {
        StateMachine machine = this.get(devId, groupIp);
        if (machine == null) {
            this.log.debug("Machine has already been left and destroyed. deviceId: {} and groupIp: {} ", (Object)devId, (Object)groupIp);
            return false;
        }
        long count = this.stateMachineStore.decreaseAndGetCounter(machine.getStateMachineId());
        if (count == 0L) {
            boolean shouldSendLeave = true;
            if (IgmpManager.isIgmpOnPodBasis() && this.groupListenedByOtherDevices(devId, groupIp)) {
                shouldSendLeave = false;
            }
            machine.leave(shouldSendLeave);
            this.destroySingle(devId, groupIp);
            this.log.debug("This machine left and destroyed. deviceId: {} and groupIp: {}", (Object)devId, (Object)groupIp);
            return true;
        }
        this.log.debug("This machine still has member/members. number of member/members: {}, deviceId: {}, groupIp: {} ", new Object[]{count, devId, groupIp});
        return false;
    }

    public void specialQuery(DeviceId devId, Ip4Address groupIp, int maxResp) {
        StateMachine machine = this.get(devId, groupIp);
        if (machine == null) {
            this.log.debug("Machine is not found. deviceId: {} and groupIp: {} ", (Object)devId, (Object)groupIp);
            return;
        }
        machine.query(maxResp);
        this.stateMachineStore.updateStateMachine(machine);
    }

    public void generalQuery(DeviceId devId, int maxResp) {
        for (StateMachine machine : this.stateMachineStore.getAllStateMachines()) {
            if (!devId.equals((Object)machine.getDeviceId())) continue;
            machine.query(maxResp);
            this.stateMachineStore.updateStateMachine(machine);
        }
    }

    public void generalQuery(int maxResp) {
        for (StateMachine machine : this.stateMachineStore.getAllStateMachines()) {
            machine.query(maxResp);
            this.stateMachineStore.updateStateMachine(machine);
        }
    }

    public void timeOut(DeviceId devId, Ip4Address groupIp) {
        StateMachine machine = this.get(devId, groupIp);
        if (machine == null) {
            this.log.debug("Machine is not found. deviceId: {} and groupIp: {}", (Object)devId, (Object)groupIp);
            return;
        }
        machine.timeOut(sendQuery);
        this.stateMachineStore.updateStateMachine(machine);
    }

    public void timeOut1s() {
        Collection<StateMachine> mapSet = this.stateMachineStore.getAllStateMachines();
        for (StateMachine machineInfo : mapSet) {
            StateMachineId machineId;
            if (machineInfo.getTimeOut() == null || !this.igmpLeadershipService.isLocalLeader((machineId = machineInfo.getStateMachineId()).getDeviceId())) continue;
            if (machineInfo.getTimeOut() > 0) {
                this.stateMachineStore.decreaseTimeout(machineId);
                continue;
            }
            StateMachine machine = this.stateMachineStore.getStateMachine(machineId);
            machine.timeOut(sendQuery);
            machine.destroyTimer();
            this.stateMachineStore.updateStateMachine(machine);
        }
    }

    public void clearAllMaps() {
        this.stateMachineStore.clearAllStateMachines();
    }

    private boolean groupListenedByOtherDevices(DeviceId devId, Ip4Address groupIp) {
        for (StateMachine machine : this.stateMachineStore.getAllStateMachines()) {
            if (machine.getStateMachineId().getDeviceId().equals((Object)devId) || !machine.getStateMachineId().getGroupIp().equals((Object)groupIp)) continue;
            return true;
        }
        return false;
    }
}

