/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl.state;

import java.util.Random;
import org.onlab.packet.Ethernet;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.DeviceId;
import org.opencord.igmpproxy.impl.IgmpManager;
import org.opencord.igmpproxy.impl.IgmpSender;
import org.opencord.igmpproxy.statemachine.State;
import org.opencord.igmpproxy.statemachine.StateMachine;

public abstract class AbstractState
implements State {
    protected StateMachine machine;

    protected AbstractState(StateMachine machine) {
        this.machine = machine;
    }

    public void join() {
    }

    public void leave() {
        DeviceId devId = this.machine.getStateMachineId().getDeviceId();
        Ip4Address groupIp = this.machine.getStateMachineId().getGroupIp();
        Ethernet eth = IgmpManager.outgoingIgmpWithV3() ? IgmpSender.getInstance().buildIgmpV3Leave(groupIp, this.machine.getSrcIp()) : IgmpSender.getInstance().buildIgmpV2Leave(groupIp, this.machine.getSrcIp());
        IgmpSender.getInstance().sendIgmpPacketUplink(eth, devId, this.machine.getUpLinkPort());
    }

    public void query(int maxResp) {
    }

    public void timeOut() {
    }

    protected int getTimeOut(int maxTimeOut) {
        Random random = new Random();
        return Math.abs(random.nextInt()) % maxTimeOut;
    }
}

