/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl.store.groupmember;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.onosproject.store.AbstractStore;
import org.opencord.igmpproxy.GroupMemberId;
import org.opencord.igmpproxy.impl.store.groupmember.GroupMember;
import org.opencord.igmpproxy.impl.store.groupmember.GroupMemberEvent;
import org.opencord.igmpproxy.impl.store.groupmember.GroupMemberStore;
import org.opencord.igmpproxy.impl.store.groupmember.GroupMemberStoreDelegate;

public abstract class AbstractGroupMemberStore
extends AbstractStore<GroupMemberEvent, GroupMemberStoreDelegate>
implements GroupMemberStore {
    protected Map<GroupMemberId, GroupMember> groupMemberMap;

    protected AbstractGroupMemberStore() {
    }

    protected AbstractGroupMemberStore(Map<GroupMemberId, GroupMember> groupMemberMap) {
        this.groupMemberMap = groupMemberMap;
    }

    @Override
    public GroupMember putGroupMember(GroupMember groupMember) {
        return this.groupMemberMap.put(groupMember.getGroupMemberId(), groupMember);
    }

    @Override
    public GroupMember updateGroupMember(GroupMember groupMember) {
        return this.groupMemberMap.replace(groupMember.getGroupMemberId(), groupMember);
    }

    @Override
    public GroupMember removeGroupMember(GroupMemberId groupMemberId) {
        return this.groupMemberMap.remove(groupMemberId);
    }

    @Override
    public GroupMember getGroupMember(GroupMemberId groupMemberId) {
        return this.groupMemberMap.getOrDefault(groupMemberId, null);
    }

    @Override
    public Set<GroupMemberId> getAllGroupMemberIds() {
        return ImmutableSet.copyOf(this.groupMemberMap.keySet());
    }

    @Override
    public Collection<GroupMember> getAllGroupMembers() {
        return ImmutableList.copyOf(this.groupMemberMap.values());
    }
}

