/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl.store.groupmember;

import java.util.ArrayList;
import java.util.Iterator;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.opencord.igmpproxy.GroupMemberId;

public final class GroupMember {
    private final VlanId vlan;
    private final GroupMemberId groupMemberId;
    private final boolean v2;
    private byte recordType = 1;
    private ArrayList<Ip4Address> sourceList = new ArrayList();
    private int keepAliveQueryInterval = 0;
    private int keepAliveQueryCount = 0;
    private int lastQueryInterval = 0;
    private int lastQueryCount = 0;
    private boolean leave = false;

    public GroupMember(Ip4Address groupIp, VlanId vlan, DeviceId deviceId, PortNumber portNum, boolean isV2) {
        this.vlan = vlan;
        this.groupMemberId = GroupMemberId.of((Ip4Address)groupIp, (DeviceId)deviceId, (PortNumber)portNum);
        this.v2 = isV2;
    }

    public String getkey() {
        return this.groupMemberId.toString();
    }

    public GroupMemberId getGroupMemberId() {
        return this.groupMemberId;
    }

    public VlanId getvlan() {
        return this.vlan;
    }

    public DeviceId getDeviceId() {
        return this.groupMemberId.getDeviceId();
    }

    public PortNumber getPortNumber() {
        return this.groupMemberId.getPortNum();
    }

    public Ip4Address getGroupIp() {
        return this.groupMemberId.getGroupIp();
    }

    public byte getRecordType() {
        return this.recordType;
    }

    public boolean getv2() {
        return this.v2;
    }

    public ArrayList<Ip4Address> getSourceList() {
        return this.sourceList;
    }

    public void updateList(byte recordType, ArrayList<Ip4Address> newSourceList) {
        this.recordType = recordType;
        this.sourceList.clear();
        this.sourceList.addAll(newSourceList);
    }

    private void join(ArrayList<Integer> listA, ArrayList<Integer> listB) {
        Iterator<Integer> iterA = null;
        Iterator<Integer> iterB = listB.iterator();
        while (iterB.hasNext()) {
            iterA = listA.iterator();
            boolean exists = false;
            int ipToAdd = iterB.next();
            while (iterA.hasNext()) {
                if (!iterA.next().equals(ipToAdd)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            listA.add(ipToAdd);
        }
    }

    private void intersection(ArrayList<Integer> listA, ArrayList<Integer> listB) {
        Iterator<Integer> iterA = listA.iterator();
        while (iterA.hasNext()) {
            Iterator<Integer> iterB = listB.iterator();
            int ipToInclude = iterA.next();
            boolean exists = false;
            while (iterB.hasNext()) {
                if (!iterB.next().equals(ipToInclude)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            iterA.remove();
        }
    }

    private void exclude(ArrayList<Integer> listA, ArrayList<Integer> listB) {
        Iterator<Integer> iterA = null;
        Iterator<Integer> iterB = listB.iterator();
        block0: while (iterB.hasNext()) {
            iterA = listA.iterator();
            int ipToDel = iterB.next();
            while (iterA.hasNext()) {
                if (!iterA.next().equals(ipToDel)) continue;
                iterA.remove();
                continue block0;
            }
        }
    }

    public void setLeave(boolean l) {
        this.leave = l;
    }

    public boolean isLeave() {
        return this.leave;
    }

    public int getKeepAliveQueryInterval() {
        return this.keepAliveQueryInterval;
    }

    public int getKeepAliveQueryCount() {
        return this.keepAliveQueryCount;
    }

    public int getLastQueryInterval() {
        return this.lastQueryInterval;
    }

    public int getLastQueryCount() {
        return this.lastQueryCount;
    }

    public void keepAliveQueryCount(boolean add) {
        this.keepAliveQueryCount = add ? ++this.keepAliveQueryCount : 0;
    }

    public void lastQueryCount(boolean add) {
        this.lastQueryCount = add ? ++this.lastQueryCount : 0;
    }

    public void keepAliveInterval(boolean add) {
        this.keepAliveQueryInterval = add ? ++this.keepAliveQueryInterval : 0;
    }

    public void lastQueryInterval(boolean add) {
        this.lastQueryInterval = add ? ++this.lastQueryInterval : 0;
    }

    public void resetAllTimers() {
        this.keepAliveQueryInterval = 0;
        this.keepAliveQueryCount = 0;
        this.lastQueryInterval = 0;
        this.lastQueryCount = 0;
    }
}

