/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl.store.machine;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import org.onosproject.store.AbstractStore;
import org.opencord.igmpproxy.impl.store.machine.StateMachineEvent;
import org.opencord.igmpproxy.impl.store.machine.StateMachineStore;
import org.opencord.igmpproxy.impl.store.machine.StateMachineStoreDelegate;
import org.opencord.igmpproxy.statemachine.StateMachine;
import org.opencord.igmpproxy.statemachine.StateMachineId;

public abstract class AbstractStateMachineStore
extends AbstractStore<StateMachineEvent, StateMachineStoreDelegate>
implements StateMachineStore {
    protected Map<StateMachineId, StateMachine> stateMachineMap;

    protected AbstractStateMachineStore() {
    }

    protected AbstractStateMachineStore(Map<StateMachineId, StateMachine> stateMachineMap) {
        this.stateMachineMap = stateMachineMap;
    }

    @Override
    public StateMachine putStateMachine(StateMachine stateMachine) {
        return this.stateMachineMap.put(stateMachine.getStateMachineId(), stateMachine);
    }

    @Override
    public StateMachine updateStateMachine(StateMachine machine) {
        return this.stateMachineMap.replace(machine.getStateMachineId(), machine);
    }

    @Override
    public StateMachine removeStateMachine(StateMachineId id) {
        return this.stateMachineMap.remove(id);
    }

    @Override
    public StateMachine getStateMachine(StateMachineId id) {
        return this.stateMachineMap.get(id);
    }

    @Override
    public Collection<StateMachine> getAllStateMachines() {
        return ImmutableList.copyOf(this.stateMachineMap.values());
    }

    @Override
    public void clearAllStateMachines() {
        this.stateMachineMap.clear();
        this.stateMachineMap = null;
    }

    @Override
    public void decreaseTimeout(StateMachineId machineId) {
        StateMachine machine = this.stateMachineMap.get(machineId);
        machine.decreaseTimeOut();
        this.updateStateMachine(machine);
    }

    @Override
    public void increaseTimeout(StateMachineId machineId) {
        StateMachine machine = this.stateMachineMap.get(machineId);
        machine.increaseTimeOut();
        this.updateStateMachine(machine);
    }
}

