/*
 * Decompiled with CFR 0.152.
 */
package org.opencord.igmpproxy.impl.store.machine;

import com.esotericsoftware.kryo.Serializer;
import org.onlab.util.KryoNamespace;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AtomicCounterMap;
import org.onosproject.store.service.AtomicCounterMapBuilder;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.StorageService;
import org.opencord.igmpproxy.impl.SingleStateMachine;
import org.opencord.igmpproxy.impl.SingleStateMachineSerializer;
import org.opencord.igmpproxy.impl.store.machine.AbstractStateMachineStore;
import org.opencord.igmpproxy.impl.store.machine.StateMachineStore;
import org.opencord.igmpproxy.statemachine.StateMachine;
import org.opencord.igmpproxy.statemachine.StateMachineId;
import org.opencord.igmpproxy.statemachine.StateMachineIdSerializer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={StateMachineStore.class})
public class DistributedStateMachineStore
extends AbstractStateMachineStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String STATE_MACHINE_COUNTER_STORE = "onos-state-machine-counter-store";
    private static final String STATE_MACHINE_MAP_NAME = "onos-state-machine-store";
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected StorageService storageService;
    private AtomicCounterMap<StateMachineId> stateMachineCounters;
    private ConsistentMap<StateMachineId, StateMachine> consistentMap;

    @Activate
    public void activate() {
        KryoNamespace.Builder stateMachineKryoBuilder = KryoNamespace.newBuilder().register(KryoNamespaces.API).register((Serializer)new StateMachineIdSerializer(), new Class[]{StateMachineId.class});
        this.stateMachineCounters = (AtomicCounterMap)((AtomicCounterMapBuilder)((AtomicCounterMapBuilder)this.storageService.atomicCounterMapBuilder().withName(STATE_MACHINE_COUNTER_STORE)).withSerializer(org.onosproject.store.service.Serializer.using((KryoNamespace)stateMachineKryoBuilder.build()))).build();
        stateMachineKryoBuilder.register((Serializer)new SingleStateMachineSerializer(), new Class[]{SingleStateMachine.class});
        this.consistentMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(STATE_MACHINE_MAP_NAME)).withSerializer(org.onosproject.store.service.Serializer.using((KryoNamespace)stateMachineKryoBuilder.build()))).build();
        this.stateMachineMap = this.consistentMap.asJavaMap();
        this.log.info("Started.");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped.");
    }

    @Override
    public long increaseAndGetCounter(StateMachineId stateMachineId) {
        return this.stateMachineCounters.incrementAndGet((Object)stateMachineId);
    }

    @Override
    public long decreaseAndGetCounter(StateMachineId stateMachineId) {
        if (this.stateMachineCounters.get((Object)stateMachineId) > 0L) {
            return this.stateMachineCounters.decrementAndGet((Object)stateMachineId);
        }
        return this.stateMachineCounters.get((Object)stateMachineId);
    }

    @Override
    public long getCounter(StateMachineId stateMachineId) {
        return this.stateMachineCounters.get((Object)stateMachineId);
    }

    @Override
    public boolean removeCounter(StateMachineId stateMachineId) {
        this.stateMachineCounters.remove((Object)stateMachineId);
        return true;
    }

    @Override
    public void clearAllStateMachines() {
        super.clearAllStateMachines();
        this.stateMachineCounters.clear();
    }
}

