/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.5.0).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.opendatadiscovery.oddplatform.ingestion.contract.api;

import org.opendatadiscovery.oddplatform.ingestion.contract.model.CompactDataEntityList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataEntityList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSourceList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DatasetStatisticsList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.IngestionAlertList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetricSetList;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import org.springframework.http.codec.multipart.Part;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import jakarta.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
@Tag(name = "OpenDataDiscoveryIngestion", description = "the OpenDataDiscoveryIngestion API")
public interface IngestionApi {

    /**
     * POST /ingestion/alerts : Alerts target catalog about ingestion issues
     * Alerts target catalog about ingestion issues
     *
     * @param ingestionAlertList  (optional)
     * @return Created (status code 201)
     */
    @Operation(
        operationId = "createAlerts",
        summary = "Alerts target catalog about ingestion issues",
        description = "Alerts target catalog about ingestion issues",
        tags = { "OpenDataDiscoveryIngestion" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ingestion/alerts",
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> createAlerts(
        @Parameter(name = "IngestionAlertList", description = "") @RequestBody(required = false) Mono<IngestionAlertList> ingestionAlertList,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(ingestionAlertList).then(Mono.empty());

    }


    /**
     * POST /ingestion/datasources : Creates data sources in the target catalog
     * Creates data sources in the target catalog
     *
     * @param dataSourceList  (optional)
     * @return Created (status code 201)
     */
    @Operation(
        operationId = "createDataSource",
        summary = "Creates data sources in the target catalog",
        description = "Creates data sources in the target catalog",
        tags = { "OpenDataDiscoveryIngestion" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ingestion/datasources",
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> createDataSource(
        @Parameter(name = "DataSourceList", description = "") @RequestBody(required = false) Mono<DataSourceList> dataSourceList,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(dataSourceList).then(Mono.empty());

    }


    /**
     * GET /ingestion/entities/degs/children : Get data entity by oddrn in Data Entity Groups
     * Searches for data entities in the target catalog by oddrn of a DEG they are currently part of
     *
     * @param oddrn  (required)
     * @return OK (status code 200)
     */
    @Operation(
        operationId = "getDataEntitiesByDEGOddrn",
        summary = "Get data entity by oddrn in Data Entity Groups",
        description = "Searches for data entities in the target catalog by oddrn of a DEG they are currently part of",
        tags = { "OpenDataDiscoveryIngestion" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompactDataEntityList.class))
            })
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/ingestion/entities/degs/children",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<CompactDataEntityList>> getDataEntitiesByDEGOddrn(
        @Parameter(name = "oddrn", description = "", required = true, in = ParameterIn.QUERY) @RequestParam(value = "oddrn", required = true) String oddrn,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"items\" : [ { \"oddrn\" : \"oddrn\" }, { \"oddrn\" : \"oddrn\" } ] }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * POST /ingestion/metrics : Ingests list of metrics
     * Ingests list of metrics
     *
     * @param metricSetList  (required)
     * @return Created (status code 201)
     */
    @Operation(
        operationId = "ingestMetrics",
        summary = "Ingests list of metrics",
        description = "Ingests list of metrics",
        tags = { "OpenDataDiscoveryIngestion" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ingestion/metrics",
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> ingestMetrics(
        @Parameter(name = "MetricSetList", description = "", required = true) @RequestBody Mono<MetricSetList> metricSetList,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(metricSetList).then(Mono.empty());

    }


    /**
     * POST /ingestion/entities : Ingests list of data entities
     * Ingests list of data entities
     *
     * @param dataEntityList  (required)
     * @return Created (status code 201)
     */
    @Operation(
        operationId = "postDataEntityList",
        summary = "Ingests list of data entities",
        description = "Ingests list of data entities",
        tags = { "OpenDataDiscoveryIngestion" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ingestion/entities",
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> postDataEntityList(
        @Parameter(name = "DataEntityList", description = "", required = true) @RequestBody Mono<DataEntityList> dataEntityList,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(dataEntityList).then(Mono.empty());

    }


    /**
     * POST /ingestion/entities/datasets/stats : Ingests list of stats for data sets
     * Ingests list of stats for data sets
     *
     * @param datasetStatisticsList  (required)
     * @return Created (status code 201)
     */
    @Operation(
        operationId = "postDataSetStatsList",
        summary = "Ingests list of stats for data sets",
        description = "Ingests list of stats for data sets",
        tags = { "OpenDataDiscoveryIngestion" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Created")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/ingestion/entities/datasets/stats",
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> postDataSetStatsList(
        @Parameter(name = "DatasetStatisticsList", description = "", required = true) @RequestBody Mono<DatasetStatisticsList> datasetStatisticsList,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(datasetStatisticsList).then(Mono.empty());

    }

}
