package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetadataExtension;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Tag;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * BaseObject
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class BaseObject {

  private String oddrn;

  private String name;

  private String version;

  private String description;

  private String owner;

  
  private List<MetadataExtension> metadata;

  
  private List<Tag> tags;

  /**
   * Default constructor
   * @deprecated Use {@link BaseObject#BaseObject(String, String)}
   */
  @Deprecated
  public BaseObject() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public BaseObject(String oddrn, String name) {
    this.oddrn = oddrn;
    this.name = name;
  }

  public BaseObject oddrn(String oddrn) {
    this.oddrn = oddrn;
    return this;
  }

  /**
   * Get oddrn
   * @return oddrn
  */
  @NotNull
  @Schema(name = "oddrn", example = "//aws/glue/{account_id}/{database}/{tablename}", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("oddrn")
  public String getOddrn() {
    return oddrn;
  }

  public void setOddrn(String oddrn) {
    this.oddrn = oddrn;
  }

  public BaseObject name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public BaseObject version(String version) {
    this.version = version;
    return this;
  }

  /**
   * Get version
   * @return version
  */
  
  @Schema(name = "version", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public BaseObject description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public BaseObject owner(String owner) {
    this.owner = owner;
    return this;
  }

  /**
   * Get owner
   * @return owner
  */
  
  @Schema(name = "owner", example = "//aws/iam/{account_id}/user/name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("owner")
  public String getOwner() {
    return owner;
  }

  public void setOwner(String owner) {
    this.owner = owner;
  }

  public BaseObject metadata(List<MetadataExtension> metadata) {
    this.metadata = metadata;
    return this;
  }

  public BaseObject addMetadataItem(MetadataExtension metadataItem) {
    if (this.metadata == null) {
      this.metadata = new ArrayList<>();
    }
    this.metadata.add(metadataItem);
    return this;
  }

  /**
   * Get metadata
   * @return metadata
  */
  
  @Schema(name = "metadata", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("metadata")
  public List<MetadataExtension> getMetadata() {
    return metadata;
  }

  public void setMetadata(List<MetadataExtension> metadata) {
    this.metadata = metadata;
  }

  public BaseObject tags(List<Tag> tags) {
    this.tags = tags;
    return this;
  }

  public BaseObject addTagsItem(Tag tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * Get tags
   * @return tags
  */
  
  @Schema(name = "tags", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tags")
  public List<Tag> getTags() {
    return tags;
  }

  public void setTags(List<Tag> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BaseObject baseObject = (BaseObject) o;
    return Objects.equals(this.oddrn, baseObject.oddrn) &&
        Objects.equals(this.name, baseObject.name) &&
        Objects.equals(this.version, baseObject.version) &&
        Objects.equals(this.description, baseObject.description) &&
        Objects.equals(this.owner, baseObject.owner) &&
        Objects.equals(this.metadata, baseObject.metadata) &&
        Objects.equals(this.tags, baseObject.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oddrn, name, version, description, owner, metadata, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BaseObject {\n");
    sb.append("    oddrn: ").append(toIndentedString(oddrn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

