package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.math.BigDecimal;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Exemplar;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Bucket
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class Bucket {

  private BigDecimal upperBound;

  private Long count;

  private Exemplar exemplar;

  /**
   * Default constructor
   * @deprecated Use {@link Bucket#Bucket(Long)}
   */
  @Deprecated
  public Bucket() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public Bucket(Long count) {
    this.count = count;
  }

  public Bucket upperBound(BigDecimal upperBound) {
    this.upperBound = upperBound;
    return this;
  }

  /**
   * Get upperBound
   * @return upperBound
  */
  
  @Schema(name = "upper_bound", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("upper_bound")
  public BigDecimal getUpperBound() {
    return upperBound;
  }

  public void setUpperBound(BigDecimal upperBound) {
    this.upperBound = upperBound;
  }

  public Bucket count(Long count) {
    this.count = count;
    return this;
  }

  /**
   * Get count
   * @return count
  */
  @NotNull
  @Schema(name = "count", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("count")
  public Long getCount() {
    return count;
  }

  public void setCount(Long count) {
    this.count = count;
  }

  public Bucket exemplar(Exemplar exemplar) {
    this.exemplar = exemplar;
    return this;
  }

  /**
   * Get exemplar
   * @return exemplar
  */
  
  @Schema(name = "exemplar", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("exemplar")
  public Exemplar getExemplar() {
    return exemplar;
  }

  public void setExemplar(Exemplar exemplar) {
    this.exemplar = exemplar;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Bucket bucket = (Bucket) o;
    return Objects.equals(this.upperBound, bucket.upperBound) &&
        Objects.equals(this.count, bucket.count) &&
        Objects.equals(this.exemplar, bucket.exemplar);
  }

  @Override
  public int hashCode() {
    return Objects.hash(upperBound, count, exemplar);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Bucket {\n");
    sb.append("    upperBound: ").append(toIndentedString(upperBound)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    exemplar: ").append(toIndentedString(exemplar)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

