package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.math.BigDecimal;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Exemplar;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * CounterValue
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class CounterValue {

  private BigDecimal total;

  private Integer created;

  private Exemplar exemplar;

  /**
   * Default constructor
   * @deprecated Use {@link CounterValue#CounterValue(BigDecimal)}
   */
  @Deprecated
  public CounterValue() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public CounterValue(BigDecimal total) {
    this.total = total;
  }

  public CounterValue total(BigDecimal total) {
    this.total = total;
    return this;
  }

  /**
   * Get total
   * @return total
  */
  @NotNull
  @Schema(name = "total", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("total")
  public BigDecimal getTotal() {
    return total;
  }

  public void setTotal(BigDecimal total) {
    this.total = total;
  }

  public CounterValue created(Integer created) {
    this.created = created;
    return this;
  }

  /**
   * Get created
   * @return created
  */
  
  @Schema(name = "created", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("created")
  public Integer getCreated() {
    return created;
  }

  public void setCreated(Integer created) {
    this.created = created;
  }

  public CounterValue exemplar(Exemplar exemplar) {
    this.exemplar = exemplar;
    return this;
  }

  /**
   * Get exemplar
   * @return exemplar
  */
  
  @Schema(name = "exemplar", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("exemplar")
  public Exemplar getExemplar() {
    return exemplar;
  }

  public void setExemplar(Exemplar exemplar) {
    this.exemplar = exemplar;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CounterValue counterValue = (CounterValue) o;
    return Objects.equals(this.total, counterValue.total) &&
        Objects.equals(this.created, counterValue.created) &&
        Objects.equals(this.exemplar, counterValue.exemplar);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, created, exemplar);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CounterValue {\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    exemplar: ").append(toIndentedString(exemplar)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

