package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataConsumer;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataEntityGroup;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataEntityType;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataInput;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataQualityTest;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataQualityTestRun;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSet;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataTransformer;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataTransformerRun;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetadataExtension;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Relationship;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Tag;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataEntity
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataEntity {

  private String oddrn;

  private String name;

  private String version;

  private String description;

  private String owner;

  
  private List<MetadataExtension> metadata;

  
  private List<Tag> tags;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime updatedAt;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  private DataEntityType type;

  private DataSet dataset;

  private DataTransformer dataTransformer;

  private DataTransformerRun dataTransformerRun;

  private DataQualityTest dataQualityTest;

  private DataQualityTestRun dataQualityTestRun;

  private DataInput dataInput;

  private DataConsumer dataConsumer;

  private DataEntityGroup dataEntityGroup;

  private Relationship dataEntityRelationship;

  /**
   * Default constructor
   * @deprecated Use {@link DataEntity#DataEntity(String, String, DataEntityType)}
   */
  @Deprecated
  public DataEntity() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataEntity(String oddrn, String name, DataEntityType type) {
    this.oddrn = oddrn;
    this.name = name;
    this.type = type;
  }

  public DataEntity oddrn(String oddrn) {
    this.oddrn = oddrn;
    return this;
  }

  /**
   * Get oddrn
   * @return oddrn
  */
  @NotNull
  @Schema(name = "oddrn", example = "//aws/glue/{account_id}/{database}/{tablename}", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("oddrn")
  public String getOddrn() {
    return oddrn;
  }

  public void setOddrn(String oddrn) {
    this.oddrn = oddrn;
  }

  public DataEntity name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DataEntity version(String version) {
    this.version = version;
    return this;
  }

  /**
   * Get version
   * @return version
  */
  
  @Schema(name = "version", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public DataEntity description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public DataEntity owner(String owner) {
    this.owner = owner;
    return this;
  }

  /**
   * Get owner
   * @return owner
  */
  
  @Schema(name = "owner", example = "//aws/iam/{account_id}/user/name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("owner")
  public String getOwner() {
    return owner;
  }

  public void setOwner(String owner) {
    this.owner = owner;
  }

  public DataEntity metadata(List<MetadataExtension> metadata) {
    this.metadata = metadata;
    return this;
  }

  public DataEntity addMetadataItem(MetadataExtension metadataItem) {
    if (this.metadata == null) {
      this.metadata = new ArrayList<>();
    }
    this.metadata.add(metadataItem);
    return this;
  }

  /**
   * Get metadata
   * @return metadata
  */
  
  @Schema(name = "metadata", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("metadata")
  public List<MetadataExtension> getMetadata() {
    return metadata;
  }

  public void setMetadata(List<MetadataExtension> metadata) {
    this.metadata = metadata;
  }

  public DataEntity tags(List<Tag> tags) {
    this.tags = tags;
    return this;
  }

  public DataEntity addTagsItem(Tag tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * Get tags
   * @return tags
  */
  
  @Schema(name = "tags", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tags")
  public List<Tag> getTags() {
    return tags;
  }

  public void setTags(List<Tag> tags) {
    this.tags = tags;
  }

  public DataEntity updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Get updatedAt
   * @return updatedAt
  */
  
  @Schema(name = "updated_at", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("updated_at")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }

  public DataEntity createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Get createdAt
   * @return createdAt
  */
  
  @Schema(name = "created_at", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("created_at")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public DataEntity type(DataEntityType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @NotNull
  @Schema(name = "type", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public DataEntityType getType() {
    return type;
  }

  public void setType(DataEntityType type) {
    this.type = type;
  }

  public DataEntity dataset(DataSet dataset) {
    this.dataset = dataset;
    return this;
  }

  /**
   * Get dataset
   * @return dataset
  */
  
  @Schema(name = "dataset", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("dataset")
  public DataSet getDataset() {
    return dataset;
  }

  public void setDataset(DataSet dataset) {
    this.dataset = dataset;
  }

  public DataEntity dataTransformer(DataTransformer dataTransformer) {
    this.dataTransformer = dataTransformer;
    return this;
  }

  /**
   * Get dataTransformer
   * @return dataTransformer
  */
  
  @Schema(name = "data_transformer", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_transformer")
  public DataTransformer getDataTransformer() {
    return dataTransformer;
  }

  public void setDataTransformer(DataTransformer dataTransformer) {
    this.dataTransformer = dataTransformer;
  }

  public DataEntity dataTransformerRun(DataTransformerRun dataTransformerRun) {
    this.dataTransformerRun = dataTransformerRun;
    return this;
  }

  /**
   * Get dataTransformerRun
   * @return dataTransformerRun
  */
  
  @Schema(name = "data_transformer_run", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_transformer_run")
  public DataTransformerRun getDataTransformerRun() {
    return dataTransformerRun;
  }

  public void setDataTransformerRun(DataTransformerRun dataTransformerRun) {
    this.dataTransformerRun = dataTransformerRun;
  }

  public DataEntity dataQualityTest(DataQualityTest dataQualityTest) {
    this.dataQualityTest = dataQualityTest;
    return this;
  }

  /**
   * Get dataQualityTest
   * @return dataQualityTest
  */
  
  @Schema(name = "data_quality_test", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_quality_test")
  public DataQualityTest getDataQualityTest() {
    return dataQualityTest;
  }

  public void setDataQualityTest(DataQualityTest dataQualityTest) {
    this.dataQualityTest = dataQualityTest;
  }

  public DataEntity dataQualityTestRun(DataQualityTestRun dataQualityTestRun) {
    this.dataQualityTestRun = dataQualityTestRun;
    return this;
  }

  /**
   * Get dataQualityTestRun
   * @return dataQualityTestRun
  */
  
  @Schema(name = "data_quality_test_run", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_quality_test_run")
  public DataQualityTestRun getDataQualityTestRun() {
    return dataQualityTestRun;
  }

  public void setDataQualityTestRun(DataQualityTestRun dataQualityTestRun) {
    this.dataQualityTestRun = dataQualityTestRun;
  }

  public DataEntity dataInput(DataInput dataInput) {
    this.dataInput = dataInput;
    return this;
  }

  /**
   * Get dataInput
   * @return dataInput
  */
  
  @Schema(name = "data_input", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_input")
  public DataInput getDataInput() {
    return dataInput;
  }

  public void setDataInput(DataInput dataInput) {
    this.dataInput = dataInput;
  }

  public DataEntity dataConsumer(DataConsumer dataConsumer) {
    this.dataConsumer = dataConsumer;
    return this;
  }

  /**
   * Get dataConsumer
   * @return dataConsumer
  */
  
  @Schema(name = "data_consumer", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_consumer")
  public DataConsumer getDataConsumer() {
    return dataConsumer;
  }

  public void setDataConsumer(DataConsumer dataConsumer) {
    this.dataConsumer = dataConsumer;
  }

  public DataEntity dataEntityGroup(DataEntityGroup dataEntityGroup) {
    this.dataEntityGroup = dataEntityGroup;
    return this;
  }

  /**
   * Get dataEntityGroup
   * @return dataEntityGroup
  */
  
  @Schema(name = "data_entity_group", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_entity_group")
  public DataEntityGroup getDataEntityGroup() {
    return dataEntityGroup;
  }

  public void setDataEntityGroup(DataEntityGroup dataEntityGroup) {
    this.dataEntityGroup = dataEntityGroup;
  }

  public DataEntity dataEntityRelationship(Relationship dataEntityRelationship) {
    this.dataEntityRelationship = dataEntityRelationship;
    return this;
  }

  /**
   * Get dataEntityRelationship
   * @return dataEntityRelationship
  */
  
  @Schema(name = "data_entity_relationship", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_entity_relationship")
  public Relationship getDataEntityRelationship() {
    return dataEntityRelationship;
  }

  public void setDataEntityRelationship(Relationship dataEntityRelationship) {
    this.dataEntityRelationship = dataEntityRelationship;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataEntity dataEntity = (DataEntity) o;
    return Objects.equals(this.oddrn, dataEntity.oddrn) &&
        Objects.equals(this.name, dataEntity.name) &&
        Objects.equals(this.version, dataEntity.version) &&
        Objects.equals(this.description, dataEntity.description) &&
        Objects.equals(this.owner, dataEntity.owner) &&
        Objects.equals(this.metadata, dataEntity.metadata) &&
        Objects.equals(this.tags, dataEntity.tags) &&
        Objects.equals(this.updatedAt, dataEntity.updatedAt) &&
        Objects.equals(this.createdAt, dataEntity.createdAt) &&
        Objects.equals(this.type, dataEntity.type) &&
        Objects.equals(this.dataset, dataEntity.dataset) &&
        Objects.equals(this.dataTransformer, dataEntity.dataTransformer) &&
        Objects.equals(this.dataTransformerRun, dataEntity.dataTransformerRun) &&
        Objects.equals(this.dataQualityTest, dataEntity.dataQualityTest) &&
        Objects.equals(this.dataQualityTestRun, dataEntity.dataQualityTestRun) &&
        Objects.equals(this.dataInput, dataEntity.dataInput) &&
        Objects.equals(this.dataConsumer, dataEntity.dataConsumer) &&
        Objects.equals(this.dataEntityGroup, dataEntity.dataEntityGroup) &&
        Objects.equals(this.dataEntityRelationship, dataEntity.dataEntityRelationship);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oddrn, name, version, description, owner, metadata, tags, updatedAt, createdAt, type, dataset, dataTransformer, dataTransformerRun, dataQualityTest, dataQualityTestRun, dataInput, dataConsumer, dataEntityGroup, dataEntityRelationship);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataEntity {\n");
    sb.append("    oddrn: ").append(toIndentedString(oddrn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    dataset: ").append(toIndentedString(dataset)).append("\n");
    sb.append("    dataTransformer: ").append(toIndentedString(dataTransformer)).append("\n");
    sb.append("    dataTransformerRun: ").append(toIndentedString(dataTransformerRun)).append("\n");
    sb.append("    dataQualityTest: ").append(toIndentedString(dataQualityTest)).append("\n");
    sb.append("    dataQualityTestRun: ").append(toIndentedString(dataQualityTestRun)).append("\n");
    sb.append("    dataInput: ").append(toIndentedString(dataInput)).append("\n");
    sb.append("    dataConsumer: ").append(toIndentedString(dataConsumer)).append("\n");
    sb.append("    dataEntityGroup: ").append(toIndentedString(dataEntityGroup)).append("\n");
    sb.append("    dataEntityRelationship: ").append(toIndentedString(dataEntityRelationship)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

