package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataConsumer;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataEntityGroup;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataEntityType;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataInput;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataQualityTest;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataQualityTestRun;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSet;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataTransformer;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataTransformerRun;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Relationship;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataEntityAllOf
 */

@JsonTypeName("DataEntity_allOf")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataEntityAllOf {

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime updatedAt;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdAt;

  private DataEntityType type;

  private DataSet dataset;

  private DataTransformer dataTransformer;

  private DataTransformerRun dataTransformerRun;

  private DataQualityTest dataQualityTest;

  private DataQualityTestRun dataQualityTestRun;

  private DataInput dataInput;

  private DataConsumer dataConsumer;

  private DataEntityGroup dataEntityGroup;

  private Relationship dataEntityRelationship;

  /**
   * Default constructor
   * @deprecated Use {@link DataEntityAllOf#DataEntityAllOf(DataEntityType)}
   */
  @Deprecated
  public DataEntityAllOf() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataEntityAllOf(DataEntityType type) {
    this.type = type;
  }

  public DataEntityAllOf updatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Get updatedAt
   * @return updatedAt
  */
  
  @Schema(name = "updated_at", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("updated_at")
  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }

  public void setUpdatedAt(OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }

  public DataEntityAllOf createdAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Get createdAt
   * @return createdAt
  */
  
  @Schema(name = "created_at", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("created_at")
  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public DataEntityAllOf type(DataEntityType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @NotNull
  @Schema(name = "type", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public DataEntityType getType() {
    return type;
  }

  public void setType(DataEntityType type) {
    this.type = type;
  }

  public DataEntityAllOf dataset(DataSet dataset) {
    this.dataset = dataset;
    return this;
  }

  /**
   * Get dataset
   * @return dataset
  */
  
  @Schema(name = "dataset", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("dataset")
  public DataSet getDataset() {
    return dataset;
  }

  public void setDataset(DataSet dataset) {
    this.dataset = dataset;
  }

  public DataEntityAllOf dataTransformer(DataTransformer dataTransformer) {
    this.dataTransformer = dataTransformer;
    return this;
  }

  /**
   * Get dataTransformer
   * @return dataTransformer
  */
  
  @Schema(name = "data_transformer", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_transformer")
  public DataTransformer getDataTransformer() {
    return dataTransformer;
  }

  public void setDataTransformer(DataTransformer dataTransformer) {
    this.dataTransformer = dataTransformer;
  }

  public DataEntityAllOf dataTransformerRun(DataTransformerRun dataTransformerRun) {
    this.dataTransformerRun = dataTransformerRun;
    return this;
  }

  /**
   * Get dataTransformerRun
   * @return dataTransformerRun
  */
  
  @Schema(name = "data_transformer_run", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_transformer_run")
  public DataTransformerRun getDataTransformerRun() {
    return dataTransformerRun;
  }

  public void setDataTransformerRun(DataTransformerRun dataTransformerRun) {
    this.dataTransformerRun = dataTransformerRun;
  }

  public DataEntityAllOf dataQualityTest(DataQualityTest dataQualityTest) {
    this.dataQualityTest = dataQualityTest;
    return this;
  }

  /**
   * Get dataQualityTest
   * @return dataQualityTest
  */
  
  @Schema(name = "data_quality_test", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_quality_test")
  public DataQualityTest getDataQualityTest() {
    return dataQualityTest;
  }

  public void setDataQualityTest(DataQualityTest dataQualityTest) {
    this.dataQualityTest = dataQualityTest;
  }

  public DataEntityAllOf dataQualityTestRun(DataQualityTestRun dataQualityTestRun) {
    this.dataQualityTestRun = dataQualityTestRun;
    return this;
  }

  /**
   * Get dataQualityTestRun
   * @return dataQualityTestRun
  */
  
  @Schema(name = "data_quality_test_run", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_quality_test_run")
  public DataQualityTestRun getDataQualityTestRun() {
    return dataQualityTestRun;
  }

  public void setDataQualityTestRun(DataQualityTestRun dataQualityTestRun) {
    this.dataQualityTestRun = dataQualityTestRun;
  }

  public DataEntityAllOf dataInput(DataInput dataInput) {
    this.dataInput = dataInput;
    return this;
  }

  /**
   * Get dataInput
   * @return dataInput
  */
  
  @Schema(name = "data_input", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_input")
  public DataInput getDataInput() {
    return dataInput;
  }

  public void setDataInput(DataInput dataInput) {
    this.dataInput = dataInput;
  }

  public DataEntityAllOf dataConsumer(DataConsumer dataConsumer) {
    this.dataConsumer = dataConsumer;
    return this;
  }

  /**
   * Get dataConsumer
   * @return dataConsumer
  */
  
  @Schema(name = "data_consumer", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_consumer")
  public DataConsumer getDataConsumer() {
    return dataConsumer;
  }

  public void setDataConsumer(DataConsumer dataConsumer) {
    this.dataConsumer = dataConsumer;
  }

  public DataEntityAllOf dataEntityGroup(DataEntityGroup dataEntityGroup) {
    this.dataEntityGroup = dataEntityGroup;
    return this;
  }

  /**
   * Get dataEntityGroup
   * @return dataEntityGroup
  */
  
  @Schema(name = "data_entity_group", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_entity_group")
  public DataEntityGroup getDataEntityGroup() {
    return dataEntityGroup;
  }

  public void setDataEntityGroup(DataEntityGroup dataEntityGroup) {
    this.dataEntityGroup = dataEntityGroup;
  }

  public DataEntityAllOf dataEntityRelationship(Relationship dataEntityRelationship) {
    this.dataEntityRelationship = dataEntityRelationship;
    return this;
  }

  /**
   * Get dataEntityRelationship
   * @return dataEntityRelationship
  */
  
  @Schema(name = "data_entity_relationship", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("data_entity_relationship")
  public Relationship getDataEntityRelationship() {
    return dataEntityRelationship;
  }

  public void setDataEntityRelationship(Relationship dataEntityRelationship) {
    this.dataEntityRelationship = dataEntityRelationship;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataEntityAllOf dataEntityAllOf = (DataEntityAllOf) o;
    return Objects.equals(this.updatedAt, dataEntityAllOf.updatedAt) &&
        Objects.equals(this.createdAt, dataEntityAllOf.createdAt) &&
        Objects.equals(this.type, dataEntityAllOf.type) &&
        Objects.equals(this.dataset, dataEntityAllOf.dataset) &&
        Objects.equals(this.dataTransformer, dataEntityAllOf.dataTransformer) &&
        Objects.equals(this.dataTransformerRun, dataEntityAllOf.dataTransformerRun) &&
        Objects.equals(this.dataQualityTest, dataEntityAllOf.dataQualityTest) &&
        Objects.equals(this.dataQualityTestRun, dataEntityAllOf.dataQualityTestRun) &&
        Objects.equals(this.dataInput, dataEntityAllOf.dataInput) &&
        Objects.equals(this.dataConsumer, dataEntityAllOf.dataConsumer) &&
        Objects.equals(this.dataEntityGroup, dataEntityAllOf.dataEntityGroup) &&
        Objects.equals(this.dataEntityRelationship, dataEntityAllOf.dataEntityRelationship);
  }

  @Override
  public int hashCode() {
    return Objects.hash(updatedAt, createdAt, type, dataset, dataTransformer, dataTransformerRun, dataQualityTest, dataQualityTestRun, dataInput, dataConsumer, dataEntityGroup, dataEntityRelationship);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataEntityAllOf {\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    dataset: ").append(toIndentedString(dataset)).append("\n");
    sb.append("    dataTransformer: ").append(toIndentedString(dataTransformer)).append("\n");
    sb.append("    dataTransformerRun: ").append(toIndentedString(dataTransformerRun)).append("\n");
    sb.append("    dataQualityTest: ").append(toIndentedString(dataQualityTest)).append("\n");
    sb.append("    dataQualityTestRun: ").append(toIndentedString(dataQualityTestRun)).append("\n");
    sb.append("    dataInput: ").append(toIndentedString(dataInput)).append("\n");
    sb.append("    dataConsumer: ").append(toIndentedString(dataConsumer)).append("\n");
    sb.append("    dataEntityGroup: ").append(toIndentedString(dataEntityGroup)).append("\n");
    sb.append("    dataEntityRelationship: ").append(toIndentedString(dataEntityRelationship)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

