package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataEntityGroup
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataEntityGroup {

  
  private List<String> entitiesList = new ArrayList<>();

  private String groupOddrn;

  /**
   * Default constructor
   * @deprecated Use {@link DataEntityGroup#DataEntityGroup(List<String>)}
   */
  @Deprecated
  public DataEntityGroup() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataEntityGroup(List<String> entitiesList) {
    this.entitiesList = entitiesList;
  }

  public DataEntityGroup entitiesList(List<String> entitiesList) {
    this.entitiesList = entitiesList;
    return this;
  }

  public DataEntityGroup addEntitiesListItem(String entitiesListItem) {
    if (this.entitiesList == null) {
      this.entitiesList = new ArrayList<>();
    }
    this.entitiesList.add(entitiesListItem);
    return this;
  }

  /**
   * Get entitiesList
   * @return entitiesList
  */
  @NotNull
  @Schema(name = "entities_list", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("entities_list")
  public List<String> getEntitiesList() {
    return entitiesList;
  }

  public void setEntitiesList(List<String> entitiesList) {
    this.entitiesList = entitiesList;
  }

  public DataEntityGroup groupOddrn(String groupOddrn) {
    this.groupOddrn = groupOddrn;
    return this;
  }

  /**
   * Get groupOddrn
   * @return groupOddrn
  */
  
  @Schema(name = "group_oddrn", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("group_oddrn")
  public String getGroupOddrn() {
    return groupOddrn;
  }

  public void setGroupOddrn(String groupOddrn) {
    this.groupOddrn = groupOddrn;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataEntityGroup dataEntityGroup = (DataEntityGroup) o;
    return Objects.equals(this.entitiesList, dataEntityGroup.entitiesList) &&
        Objects.equals(this.groupOddrn, dataEntityGroup.groupOddrn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(entitiesList, groupOddrn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataEntityGroup {\n");
    sb.append("    entitiesList: ").append(toIndentedString(entitiesList)).append("\n");
    sb.append("    groupOddrn: ").append(toIndentedString(groupOddrn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

