package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataEntity;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataEntityList
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataEntityList {

  private String dataSourceOddrn;

  
  private List<DataEntity> items;

  /**
   * Default constructor
   * @deprecated Use {@link DataEntityList#DataEntityList(String)}
   */
  @Deprecated
  public DataEntityList() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataEntityList(String dataSourceOddrn) {
    this.dataSourceOddrn = dataSourceOddrn;
  }

  public DataEntityList dataSourceOddrn(String dataSourceOddrn) {
    this.dataSourceOddrn = dataSourceOddrn;
    return this;
  }

  /**
   * Get dataSourceOddrn
   * @return dataSourceOddrn
  */
  @NotNull
  @Schema(name = "data_source_oddrn", example = "//aws/glue/123456789010/", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("data_source_oddrn")
  public String getDataSourceOddrn() {
    return dataSourceOddrn;
  }

  public void setDataSourceOddrn(String dataSourceOddrn) {
    this.dataSourceOddrn = dataSourceOddrn;
  }

  public DataEntityList items(List<DataEntity> items) {
    this.items = items;
    return this;
  }

  public DataEntityList addItemsItem(DataEntity itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

  /**
   * Get items
   * @return items
  */
  
  @Schema(name = "items", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("items")
  public List<DataEntity> getItems() {
    return items;
  }

  public void setItems(List<DataEntity> items) {
    this.items = items;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataEntityList dataEntityList = (DataEntityList) o;
    return Objects.equals(this.dataSourceOddrn, dataEntityList.dataSourceOddrn) &&
        Objects.equals(this.items, dataEntityList.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataSourceOddrn, items);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataEntityList {\n");
    sb.append("    dataSourceOddrn: ").append(toIndentedString(dataSourceOddrn)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

