package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataQualityTestExpectation;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.LinkedUrl;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataQualityTest
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataQualityTest {

  private String suiteName;

  
  private List<String> datasetList = new ArrayList<>();

  private DataQualityTestExpectation expectation;

  private String suiteUrl;

  
  private List<LinkedUrl> linkedUrlList;

  /**
   * Default constructor
   * @deprecated Use {@link DataQualityTest#DataQualityTest(String, List<String>, DataQualityTestExpectation)}
   */
  @Deprecated
  public DataQualityTest() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataQualityTest(String suiteName, List<String> datasetList, DataQualityTestExpectation expectation) {
    this.suiteName = suiteName;
    this.datasetList = datasetList;
    this.expectation = expectation;
  }

  public DataQualityTest suiteName(String suiteName) {
    this.suiteName = suiteName;
    return this;
  }

  /**
   * Get suiteName
   * @return suiteName
  */
  @NotNull
  @Schema(name = "suite_name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("suite_name")
  public String getSuiteName() {
    return suiteName;
  }

  public void setSuiteName(String suiteName) {
    this.suiteName = suiteName;
  }

  public DataQualityTest datasetList(List<String> datasetList) {
    this.datasetList = datasetList;
    return this;
  }

  public DataQualityTest addDatasetListItem(String datasetListItem) {
    if (this.datasetList == null) {
      this.datasetList = new ArrayList<>();
    }
    this.datasetList.add(datasetListItem);
    return this;
  }

  /**
   * Get datasetList
   * @return datasetList
  */
  @NotNull
  @Schema(name = "dataset_list", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("dataset_list")
  public List<String> getDatasetList() {
    return datasetList;
  }

  public void setDatasetList(List<String> datasetList) {
    this.datasetList = datasetList;
  }

  public DataQualityTest expectation(DataQualityTestExpectation expectation) {
    this.expectation = expectation;
    return this;
  }

  /**
   * Get expectation
   * @return expectation
  */
  @NotNull
  @Schema(name = "expectation", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("expectation")
  public DataQualityTestExpectation getExpectation() {
    return expectation;
  }

  public void setExpectation(DataQualityTestExpectation expectation) {
    this.expectation = expectation;
  }

  public DataQualityTest suiteUrl(String suiteUrl) {
    this.suiteUrl = suiteUrl;
    return this;
  }

  /**
   * Get suiteUrl
   * @return suiteUrl
  */
  
  @Schema(name = "suite_url", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("suite_url")
  public String getSuiteUrl() {
    return suiteUrl;
  }

  public void setSuiteUrl(String suiteUrl) {
    this.suiteUrl = suiteUrl;
  }

  public DataQualityTest linkedUrlList(List<LinkedUrl> linkedUrlList) {
    this.linkedUrlList = linkedUrlList;
    return this;
  }

  public DataQualityTest addLinkedUrlListItem(LinkedUrl linkedUrlListItem) {
    if (this.linkedUrlList == null) {
      this.linkedUrlList = new ArrayList<>();
    }
    this.linkedUrlList.add(linkedUrlListItem);
    return this;
  }

  /**
   * Get linkedUrlList
   * @return linkedUrlList
  */
  
  @Schema(name = "linked_url_list", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("linked_url_list")
  public List<LinkedUrl> getLinkedUrlList() {
    return linkedUrlList;
  }

  public void setLinkedUrlList(List<LinkedUrl> linkedUrlList) {
    this.linkedUrlList = linkedUrlList;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataQualityTest dataQualityTest = (DataQualityTest) o;
    return Objects.equals(this.suiteName, dataQualityTest.suiteName) &&
        Objects.equals(this.datasetList, dataQualityTest.datasetList) &&
        Objects.equals(this.expectation, dataQualityTest.expectation) &&
        Objects.equals(this.suiteUrl, dataQualityTest.suiteUrl) &&
        Objects.equals(this.linkedUrlList, dataQualityTest.linkedUrlList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(suiteName, datasetList, expectation, suiteUrl, linkedUrlList);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataQualityTest {\n");
    sb.append("    suiteName: ").append(toIndentedString(suiteName)).append("\n");
    sb.append("    datasetList: ").append(toIndentedString(datasetList)).append("\n");
    sb.append("    expectation: ").append(toIndentedString(expectation)).append("\n");
    sb.append("    suiteUrl: ").append(toIndentedString(suiteUrl)).append("\n");
    sb.append("    linkedUrlList: ").append(toIndentedString(linkedUrlList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

