package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.QualityRunStatus;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataQualityTestRun
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataQualityTestRun {

  private String dataQualityTestOddrn;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime startTime;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime endTime;

  private String statusReason;

  private QualityRunStatus status;

  /**
   * Default constructor
   * @deprecated Use {@link DataQualityTestRun#DataQualityTestRun(String, OffsetDateTime, QualityRunStatus)}
   */
  @Deprecated
  public DataQualityTestRun() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataQualityTestRun(String dataQualityTestOddrn, OffsetDateTime startTime, QualityRunStatus status) {
    this.dataQualityTestOddrn = dataQualityTestOddrn;
    this.startTime = startTime;
    this.status = status;
  }

  public DataQualityTestRun dataQualityTestOddrn(String dataQualityTestOddrn) {
    this.dataQualityTestOddrn = dataQualityTestOddrn;
    return this;
  }

  /**
   * Get dataQualityTestOddrn
   * @return dataQualityTestOddrn
  */
  @NotNull
  @Schema(name = "data_quality_test_oddrn", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("data_quality_test_oddrn")
  public String getDataQualityTestOddrn() {
    return dataQualityTestOddrn;
  }

  public void setDataQualityTestOddrn(String dataQualityTestOddrn) {
    this.dataQualityTestOddrn = dataQualityTestOddrn;
  }

  public DataQualityTestRun startTime(OffsetDateTime startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Get startTime
   * @return startTime
  */
  @NotNull
  @Schema(name = "start_time", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("start_time")
  public OffsetDateTime getStartTime() {
    return startTime;
  }

  public void setStartTime(OffsetDateTime startTime) {
    this.startTime = startTime;
  }

  public DataQualityTestRun endTime(OffsetDateTime endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Get endTime
   * @return endTime
  */
  
  @Schema(name = "end_time", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("end_time")
  public OffsetDateTime getEndTime() {
    return endTime;
  }

  public void setEndTime(OffsetDateTime endTime) {
    this.endTime = endTime;
  }

  public DataQualityTestRun statusReason(String statusReason) {
    this.statusReason = statusReason;
    return this;
  }

  /**
   * Get statusReason
   * @return statusReason
  */
  
  @Schema(name = "status_reason", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("status_reason")
  public String getStatusReason() {
    return statusReason;
  }

  public void setStatusReason(String statusReason) {
    this.statusReason = statusReason;
  }

  public DataQualityTestRun status(QualityRunStatus status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @NotNull
  @Schema(name = "status", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("status")
  public QualityRunStatus getStatus() {
    return status;
  }

  public void setStatus(QualityRunStatus status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataQualityTestRun dataQualityTestRun = (DataQualityTestRun) o;
    return Objects.equals(this.dataQualityTestOddrn, dataQualityTestRun.dataQualityTestOddrn) &&
        Objects.equals(this.startTime, dataQualityTestRun.startTime) &&
        Objects.equals(this.endTime, dataQualityTestRun.endTime) &&
        Objects.equals(this.statusReason, dataQualityTestRun.statusReason) &&
        Objects.equals(this.status, dataQualityTestRun.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataQualityTestOddrn, startTime, endTime, statusReason, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataQualityTestRun {\n");
    sb.append("    dataQualityTestOddrn: ").append(toIndentedString(dataQualityTestOddrn)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    statusReason: ").append(toIndentedString(statusReason)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

