package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldEnumValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldStat;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldType;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetadataExtension;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Tag;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataSetField
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataSetField {

  private String oddrn;

  private String name;

  private String version;

  private String description;

  private String owner;

  
  private List<MetadataExtension> metadata;

  
  private List<Tag> tags;

  private String parentFieldOddrn;

  private DataSetFieldType type;

  private Boolean isPrimaryKey;

  private Boolean isSortKey;

  private Boolean isKey;

  private Boolean isValue;

  private String referenceOddrn;

  private String defaultValue;

  private DataSetFieldStat stats;

  
  private List<DataSetFieldEnumValue> enumValues;

  /**
   * Default constructor
   * @deprecated Use {@link DataSetField#DataSetField(String, String, DataSetFieldType)}
   */
  @Deprecated
  public DataSetField() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataSetField(String oddrn, String name, DataSetFieldType type) {
    this.oddrn = oddrn;
    this.name = name;
    this.type = type;
  }

  public DataSetField oddrn(String oddrn) {
    this.oddrn = oddrn;
    return this;
  }

  /**
   * Get oddrn
   * @return oddrn
  */
  @NotNull
  @Schema(name = "oddrn", example = "//aws/glue/{account_id}/{database}/{tablename}", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("oddrn")
  public String getOddrn() {
    return oddrn;
  }

  public void setOddrn(String oddrn) {
    this.oddrn = oddrn;
  }

  public DataSetField name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DataSetField version(String version) {
    this.version = version;
    return this;
  }

  /**
   * Get version
   * @return version
  */
  
  @Schema(name = "version", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public DataSetField description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public DataSetField owner(String owner) {
    this.owner = owner;
    return this;
  }

  /**
   * Get owner
   * @return owner
  */
  
  @Schema(name = "owner", example = "//aws/iam/{account_id}/user/name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("owner")
  public String getOwner() {
    return owner;
  }

  public void setOwner(String owner) {
    this.owner = owner;
  }

  public DataSetField metadata(List<MetadataExtension> metadata) {
    this.metadata = metadata;
    return this;
  }

  public DataSetField addMetadataItem(MetadataExtension metadataItem) {
    if (this.metadata == null) {
      this.metadata = new ArrayList<>();
    }
    this.metadata.add(metadataItem);
    return this;
  }

  /**
   * Get metadata
   * @return metadata
  */
  
  @Schema(name = "metadata", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("metadata")
  public List<MetadataExtension> getMetadata() {
    return metadata;
  }

  public void setMetadata(List<MetadataExtension> metadata) {
    this.metadata = metadata;
  }

  public DataSetField tags(List<Tag> tags) {
    this.tags = tags;
    return this;
  }

  public DataSetField addTagsItem(Tag tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * Get tags
   * @return tags
  */
  
  @Schema(name = "tags", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tags")
  public List<Tag> getTags() {
    return tags;
  }

  public void setTags(List<Tag> tags) {
    this.tags = tags;
  }

  public DataSetField parentFieldOddrn(String parentFieldOddrn) {
    this.parentFieldOddrn = parentFieldOddrn;
    return this;
  }

  /**
   * Get parentFieldOddrn
   * @return parentFieldOddrn
  */
  
  @Schema(name = "parent_field_oddrn", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parent_field_oddrn")
  public String getParentFieldOddrn() {
    return parentFieldOddrn;
  }

  public void setParentFieldOddrn(String parentFieldOddrn) {
    this.parentFieldOddrn = parentFieldOddrn;
  }

  public DataSetField type(DataSetFieldType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @NotNull
  @Schema(name = "type", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public DataSetFieldType getType() {
    return type;
  }

  public void setType(DataSetFieldType type) {
    this.type = type;
  }

  public DataSetField isPrimaryKey(Boolean isPrimaryKey) {
    this.isPrimaryKey = isPrimaryKey;
    return this;
  }

  /**
   * Get isPrimaryKey
   * @return isPrimaryKey
  */
  
  @Schema(name = "is_primary_key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_primary_key")
  public Boolean getIsPrimaryKey() {
    return isPrimaryKey;
  }

  public void setIsPrimaryKey(Boolean isPrimaryKey) {
    this.isPrimaryKey = isPrimaryKey;
  }

  public DataSetField isSortKey(Boolean isSortKey) {
    this.isSortKey = isSortKey;
    return this;
  }

  /**
   * Get isSortKey
   * @return isSortKey
  */
  
  @Schema(name = "is_sort_key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_sort_key")
  public Boolean getIsSortKey() {
    return isSortKey;
  }

  public void setIsSortKey(Boolean isSortKey) {
    this.isSortKey = isSortKey;
  }

  public DataSetField isKey(Boolean isKey) {
    this.isKey = isKey;
    return this;
  }

  /**
   * Get isKey
   * @return isKey
  */
  
  @Schema(name = "is_key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_key")
  public Boolean getIsKey() {
    return isKey;
  }

  public void setIsKey(Boolean isKey) {
    this.isKey = isKey;
  }

  public DataSetField isValue(Boolean isValue) {
    this.isValue = isValue;
    return this;
  }

  /**
   * Get isValue
   * @return isValue
  */
  
  @Schema(name = "is_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_value")
  public Boolean getIsValue() {
    return isValue;
  }

  public void setIsValue(Boolean isValue) {
    this.isValue = isValue;
  }

  public DataSetField referenceOddrn(String referenceOddrn) {
    this.referenceOddrn = referenceOddrn;
    return this;
  }

  /**
   * Get referenceOddrn
   * @return referenceOddrn
  */
  
  @Schema(name = "reference_oddrn", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("reference_oddrn")
  public String getReferenceOddrn() {
    return referenceOddrn;
  }

  public void setReferenceOddrn(String referenceOddrn) {
    this.referenceOddrn = referenceOddrn;
  }

  public DataSetField defaultValue(String defaultValue) {
    this.defaultValue = defaultValue;
    return this;
  }

  /**
   * Get defaultValue
   * @return defaultValue
  */
  
  @Schema(name = "default_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("default_value")
  public String getDefaultValue() {
    return defaultValue;
  }

  public void setDefaultValue(String defaultValue) {
    this.defaultValue = defaultValue;
  }

  public DataSetField stats(DataSetFieldStat stats) {
    this.stats = stats;
    return this;
  }

  /**
   * Get stats
   * @return stats
  */
  
  @Schema(name = "stats", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("stats")
  public DataSetFieldStat getStats() {
    return stats;
  }

  public void setStats(DataSetFieldStat stats) {
    this.stats = stats;
  }

  public DataSetField enumValues(List<DataSetFieldEnumValue> enumValues) {
    this.enumValues = enumValues;
    return this;
  }

  public DataSetField addEnumValuesItem(DataSetFieldEnumValue enumValuesItem) {
    if (this.enumValues == null) {
      this.enumValues = new ArrayList<>();
    }
    this.enumValues.add(enumValuesItem);
    return this;
  }

  /**
   * Get enumValues
   * @return enumValues
  */
  
  @Schema(name = "enum_values", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("enum_values")
  public List<DataSetFieldEnumValue> getEnumValues() {
    return enumValues;
  }

  public void setEnumValues(List<DataSetFieldEnumValue> enumValues) {
    this.enumValues = enumValues;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetField dataSetField = (DataSetField) o;
    return Objects.equals(this.oddrn, dataSetField.oddrn) &&
        Objects.equals(this.name, dataSetField.name) &&
        Objects.equals(this.version, dataSetField.version) &&
        Objects.equals(this.description, dataSetField.description) &&
        Objects.equals(this.owner, dataSetField.owner) &&
        Objects.equals(this.metadata, dataSetField.metadata) &&
        Objects.equals(this.tags, dataSetField.tags) &&
        Objects.equals(this.parentFieldOddrn, dataSetField.parentFieldOddrn) &&
        Objects.equals(this.type, dataSetField.type) &&
        Objects.equals(this.isPrimaryKey, dataSetField.isPrimaryKey) &&
        Objects.equals(this.isSortKey, dataSetField.isSortKey) &&
        Objects.equals(this.isKey, dataSetField.isKey) &&
        Objects.equals(this.isValue, dataSetField.isValue) &&
        Objects.equals(this.referenceOddrn, dataSetField.referenceOddrn) &&
        Objects.equals(this.defaultValue, dataSetField.defaultValue) &&
        Objects.equals(this.stats, dataSetField.stats) &&
        Objects.equals(this.enumValues, dataSetField.enumValues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oddrn, name, version, description, owner, metadata, tags, parentFieldOddrn, type, isPrimaryKey, isSortKey, isKey, isValue, referenceOddrn, defaultValue, stats, enumValues);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetField {\n");
    sb.append("    oddrn: ").append(toIndentedString(oddrn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    parentFieldOddrn: ").append(toIndentedString(parentFieldOddrn)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    isPrimaryKey: ").append(toIndentedString(isPrimaryKey)).append("\n");
    sb.append("    isSortKey: ").append(toIndentedString(isSortKey)).append("\n");
    sb.append("    isKey: ").append(toIndentedString(isKey)).append("\n");
    sb.append("    isValue: ").append(toIndentedString(isValue)).append("\n");
    sb.append("    referenceOddrn: ").append(toIndentedString(referenceOddrn)).append("\n");
    sb.append("    defaultValue: ").append(toIndentedString(defaultValue)).append("\n");
    sb.append("    stats: ").append(toIndentedString(stats)).append("\n");
    sb.append("    enumValues: ").append(toIndentedString(enumValues)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

