package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldEnumValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldStat;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldType;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataSetFieldAllOf
 */

@JsonTypeName("DataSetField_allOf")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataSetFieldAllOf {

  private String parentFieldOddrn;

  private DataSetFieldType type;

  private Boolean isPrimaryKey;

  private Boolean isSortKey;

  private Boolean isKey;

  private Boolean isValue;

  private String referenceOddrn;

  private String defaultValue;

  private DataSetFieldStat stats;

  
  private List<DataSetFieldEnumValue> enumValues;

  /**
   * Default constructor
   * @deprecated Use {@link DataSetFieldAllOf#DataSetFieldAllOf(DataSetFieldType)}
   */
  @Deprecated
  public DataSetFieldAllOf() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataSetFieldAllOf(DataSetFieldType type) {
    this.type = type;
  }

  public DataSetFieldAllOf parentFieldOddrn(String parentFieldOddrn) {
    this.parentFieldOddrn = parentFieldOddrn;
    return this;
  }

  /**
   * Get parentFieldOddrn
   * @return parentFieldOddrn
  */
  
  @Schema(name = "parent_field_oddrn", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("parent_field_oddrn")
  public String getParentFieldOddrn() {
    return parentFieldOddrn;
  }

  public void setParentFieldOddrn(String parentFieldOddrn) {
    this.parentFieldOddrn = parentFieldOddrn;
  }

  public DataSetFieldAllOf type(DataSetFieldType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @NotNull
  @Schema(name = "type", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public DataSetFieldType getType() {
    return type;
  }

  public void setType(DataSetFieldType type) {
    this.type = type;
  }

  public DataSetFieldAllOf isPrimaryKey(Boolean isPrimaryKey) {
    this.isPrimaryKey = isPrimaryKey;
    return this;
  }

  /**
   * Get isPrimaryKey
   * @return isPrimaryKey
  */
  
  @Schema(name = "is_primary_key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_primary_key")
  public Boolean getIsPrimaryKey() {
    return isPrimaryKey;
  }

  public void setIsPrimaryKey(Boolean isPrimaryKey) {
    this.isPrimaryKey = isPrimaryKey;
  }

  public DataSetFieldAllOf isSortKey(Boolean isSortKey) {
    this.isSortKey = isSortKey;
    return this;
  }

  /**
   * Get isSortKey
   * @return isSortKey
  */
  
  @Schema(name = "is_sort_key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_sort_key")
  public Boolean getIsSortKey() {
    return isSortKey;
  }

  public void setIsSortKey(Boolean isSortKey) {
    this.isSortKey = isSortKey;
  }

  public DataSetFieldAllOf isKey(Boolean isKey) {
    this.isKey = isKey;
    return this;
  }

  /**
   * Get isKey
   * @return isKey
  */
  
  @Schema(name = "is_key", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_key")
  public Boolean getIsKey() {
    return isKey;
  }

  public void setIsKey(Boolean isKey) {
    this.isKey = isKey;
  }

  public DataSetFieldAllOf isValue(Boolean isValue) {
    this.isValue = isValue;
    return this;
  }

  /**
   * Get isValue
   * @return isValue
  */
  
  @Schema(name = "is_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_value")
  public Boolean getIsValue() {
    return isValue;
  }

  public void setIsValue(Boolean isValue) {
    this.isValue = isValue;
  }

  public DataSetFieldAllOf referenceOddrn(String referenceOddrn) {
    this.referenceOddrn = referenceOddrn;
    return this;
  }

  /**
   * Get referenceOddrn
   * @return referenceOddrn
  */
  
  @Schema(name = "reference_oddrn", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("reference_oddrn")
  public String getReferenceOddrn() {
    return referenceOddrn;
  }

  public void setReferenceOddrn(String referenceOddrn) {
    this.referenceOddrn = referenceOddrn;
  }

  public DataSetFieldAllOf defaultValue(String defaultValue) {
    this.defaultValue = defaultValue;
    return this;
  }

  /**
   * Get defaultValue
   * @return defaultValue
  */
  
  @Schema(name = "default_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("default_value")
  public String getDefaultValue() {
    return defaultValue;
  }

  public void setDefaultValue(String defaultValue) {
    this.defaultValue = defaultValue;
  }

  public DataSetFieldAllOf stats(DataSetFieldStat stats) {
    this.stats = stats;
    return this;
  }

  /**
   * Get stats
   * @return stats
  */
  
  @Schema(name = "stats", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("stats")
  public DataSetFieldStat getStats() {
    return stats;
  }

  public void setStats(DataSetFieldStat stats) {
    this.stats = stats;
  }

  public DataSetFieldAllOf enumValues(List<DataSetFieldEnumValue> enumValues) {
    this.enumValues = enumValues;
    return this;
  }

  public DataSetFieldAllOf addEnumValuesItem(DataSetFieldEnumValue enumValuesItem) {
    if (this.enumValues == null) {
      this.enumValues = new ArrayList<>();
    }
    this.enumValues.add(enumValuesItem);
    return this;
  }

  /**
   * Get enumValues
   * @return enumValues
  */
  
  @Schema(name = "enum_values", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("enum_values")
  public List<DataSetFieldEnumValue> getEnumValues() {
    return enumValues;
  }

  public void setEnumValues(List<DataSetFieldEnumValue> enumValues) {
    this.enumValues = enumValues;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetFieldAllOf dataSetFieldAllOf = (DataSetFieldAllOf) o;
    return Objects.equals(this.parentFieldOddrn, dataSetFieldAllOf.parentFieldOddrn) &&
        Objects.equals(this.type, dataSetFieldAllOf.type) &&
        Objects.equals(this.isPrimaryKey, dataSetFieldAllOf.isPrimaryKey) &&
        Objects.equals(this.isSortKey, dataSetFieldAllOf.isSortKey) &&
        Objects.equals(this.isKey, dataSetFieldAllOf.isKey) &&
        Objects.equals(this.isValue, dataSetFieldAllOf.isValue) &&
        Objects.equals(this.referenceOddrn, dataSetFieldAllOf.referenceOddrn) &&
        Objects.equals(this.defaultValue, dataSetFieldAllOf.defaultValue) &&
        Objects.equals(this.stats, dataSetFieldAllOf.stats) &&
        Objects.equals(this.enumValues, dataSetFieldAllOf.enumValues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(parentFieldOddrn, type, isPrimaryKey, isSortKey, isKey, isValue, referenceOddrn, defaultValue, stats, enumValues);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetFieldAllOf {\n");
    sb.append("    parentFieldOddrn: ").append(toIndentedString(parentFieldOddrn)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    isPrimaryKey: ").append(toIndentedString(isPrimaryKey)).append("\n");
    sb.append("    isSortKey: ").append(toIndentedString(isSortKey)).append("\n");
    sb.append("    isKey: ").append(toIndentedString(isKey)).append("\n");
    sb.append("    isValue: ").append(toIndentedString(isValue)).append("\n");
    sb.append("    referenceOddrn: ").append(toIndentedString(referenceOddrn)).append("\n");
    sb.append("    defaultValue: ").append(toIndentedString(defaultValue)).append("\n");
    sb.append("    stats: ").append(toIndentedString(stats)).append("\n");
    sb.append("    enumValues: ").append(toIndentedString(enumValues)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

