package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataSetFieldType
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataSetFieldType {

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    STRING("TYPE_STRING"),
    
    NUMBER("TYPE_NUMBER"),
    
    INTEGER("TYPE_INTEGER"),
    
    BOOLEAN("TYPE_BOOLEAN"),
    
    CHAR("TYPE_CHAR"),
    
    DATETIME("TYPE_DATETIME"),
    
    TIME("TYPE_TIME"),
    
    STRUCT("TYPE_STRUCT"),
    
    BINARY("TYPE_BINARY"),
    
    LIST("TYPE_LIST"),
    
    MAP("TYPE_MAP"),
    
    UNION("TYPE_UNION"),
    
    DURATION("TYPE_DURATION"),
    
    REFERENCE("TYPE_REFERENCE"),
    
    VECTOR("TYPE_VECTOR"),
    
    UNKNOWN("TYPE_UNKNOWN");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private TypeEnum type;

  private String logicalType;

  private Boolean isNullable;

  /**
   * Default constructor
   * @deprecated Use {@link DataSetFieldType#DataSetFieldType(TypeEnum, Boolean)}
   */
  @Deprecated
  public DataSetFieldType() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataSetFieldType(TypeEnum type, Boolean isNullable) {
    this.type = type;
    this.isNullable = isNullable;
  }

  public DataSetFieldType type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @NotNull
  @Schema(name = "type", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public DataSetFieldType logicalType(String logicalType) {
    this.logicalType = logicalType;
    return this;
  }

  /**
   * Get logicalType
   * @return logicalType
  */
  
  @Schema(name = "logical_type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("logical_type")
  public String getLogicalType() {
    return logicalType;
  }

  public void setLogicalType(String logicalType) {
    this.logicalType = logicalType;
  }

  public DataSetFieldType isNullable(Boolean isNullable) {
    this.isNullable = isNullable;
    return this;
  }

  /**
   * Get isNullable
   * @return isNullable
  */
  @NotNull
  @Schema(name = "is_nullable", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("is_nullable")
  public Boolean getIsNullable() {
    return isNullable;
  }

  public void setIsNullable(Boolean isNullable) {
    this.isNullable = isNullable;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetFieldType dataSetFieldType = (DataSetFieldType) o;
    return Objects.equals(this.type, dataSetFieldType.type) &&
        Objects.equals(this.logicalType, dataSetFieldType.logicalType) &&
        Objects.equals(this.isNullable, dataSetFieldType.isNullable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, logicalType, isNullable);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetFieldType {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    logicalType: ").append(toIndentedString(logicalType)).append("\n");
    sb.append("    isNullable: ").append(toIndentedString(isNullable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

