package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldStat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataSetStatistics
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataSetStatistics {

  private String datasetOddrn;

  
  private Map<String, DataSetFieldStat> fields = new HashMap<>();

  /**
   * Default constructor
   * @deprecated Use {@link DataSetStatistics#DataSetStatistics(String, Map<String, DataSetFieldStat>)}
   */
  @Deprecated
  public DataSetStatistics() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataSetStatistics(String datasetOddrn, Map<String, DataSetFieldStat> fields) {
    this.datasetOddrn = datasetOddrn;
    this.fields = fields;
  }

  public DataSetStatistics datasetOddrn(String datasetOddrn) {
    this.datasetOddrn = datasetOddrn;
    return this;
  }

  /**
   * Get datasetOddrn
   * @return datasetOddrn
  */
  @NotNull
  @Schema(name = "dataset_oddrn", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("dataset_oddrn")
  public String getDatasetOddrn() {
    return datasetOddrn;
  }

  public void setDatasetOddrn(String datasetOddrn) {
    this.datasetOddrn = datasetOddrn;
  }

  public DataSetStatistics fields(Map<String, DataSetFieldStat> fields) {
    this.fields = fields;
    return this;
  }

  public DataSetStatistics putFieldsItem(String key, DataSetFieldStat fieldsItem) {
    if (this.fields == null) {
      this.fields = new HashMap<>();
    }
    this.fields.put(key, fieldsItem);
    return this;
  }

  /**
   * key is a field oddrn. For example: \"//aws/glue/{account_id}/{database}/{tablename}/columns/{column_name}\" 
   * @return fields
  */
  @NotNull
  @Schema(name = "fields", description = "key is a field oddrn. For example: \"//aws/glue/{account_id}/{database}/{tablename}/columns/{column_name}\" ", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("fields")
  public Map<String, DataSetFieldStat> getFields() {
    return fields;
  }

  public void setFields(Map<String, DataSetFieldStat> fields) {
    this.fields = fields;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSetStatistics dataSetStatistics = (DataSetStatistics) o;
    return Objects.equals(this.datasetOddrn, dataSetStatistics.datasetOddrn) &&
        Objects.equals(this.fields, dataSetStatistics.fields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(datasetOddrn, fields);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSetStatistics {\n");
    sb.append("    datasetOddrn: ").append(toIndentedString(datasetOddrn)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

