package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataSource
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataSource {

  private String oddrn;

  private String name;

  private String description;

  /**
   * Default constructor
   * @deprecated Use {@link DataSource#DataSource(String, String)}
   */
  @Deprecated
  public DataSource() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataSource(String oddrn, String name) {
    this.oddrn = oddrn;
    this.name = name;
  }

  public DataSource oddrn(String oddrn) {
    this.oddrn = oddrn;
    return this;
  }

  /**
   * Get oddrn
   * @return oddrn
  */
  @NotNull
  @Schema(name = "oddrn", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("oddrn")
  public String getOddrn() {
    return oddrn;
  }

  public void setOddrn(String oddrn) {
    this.oddrn = oddrn;
  }

  public DataSource name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DataSource description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataSource dataSource = (DataSource) o;
    return Objects.equals(this.oddrn, dataSource.oddrn) &&
        Objects.equals(this.name, dataSource.name) &&
        Objects.equals(this.description, dataSource.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oddrn, name, description);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataSource {\n");
    sb.append("    oddrn: ").append(toIndentedString(oddrn)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

