package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataTransformer
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataTransformer {

  private String sourceCodeUrl;

  private String sql;

  
  private List<String> inputs = new ArrayList<>();

  
  private List<String> outputs = new ArrayList<>();

  /**
   * Default constructor
   * @deprecated Use {@link DataTransformer#DataTransformer(List<String>, List<String>)}
   */
  @Deprecated
  public DataTransformer() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataTransformer(List<String> inputs, List<String> outputs) {
    this.inputs = inputs;
    this.outputs = outputs;
  }

  public DataTransformer sourceCodeUrl(String sourceCodeUrl) {
    this.sourceCodeUrl = sourceCodeUrl;
    return this;
  }

  /**
   * Get sourceCodeUrl
   * @return sourceCodeUrl
  */
  
  @Schema(name = "source_code_url", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("source_code_url")
  public String getSourceCodeUrl() {
    return sourceCodeUrl;
  }

  public void setSourceCodeUrl(String sourceCodeUrl) {
    this.sourceCodeUrl = sourceCodeUrl;
  }

  public DataTransformer sql(String sql) {
    this.sql = sql;
    return this;
  }

  /**
   * Get sql
   * @return sql
  */
  
  @Schema(name = "sql", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("sql")
  public String getSql() {
    return sql;
  }

  public void setSql(String sql) {
    this.sql = sql;
  }

  public DataTransformer inputs(List<String> inputs) {
    this.inputs = inputs;
    return this;
  }

  public DataTransformer addInputsItem(String inputsItem) {
    if (this.inputs == null) {
      this.inputs = new ArrayList<>();
    }
    this.inputs.add(inputsItem);
    return this;
  }

  /**
   * Get inputs
   * @return inputs
  */
  @NotNull
  @Schema(name = "inputs", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("inputs")
  public List<String> getInputs() {
    return inputs;
  }

  public void setInputs(List<String> inputs) {
    this.inputs = inputs;
  }

  public DataTransformer outputs(List<String> outputs) {
    this.outputs = outputs;
    return this;
  }

  public DataTransformer addOutputsItem(String outputsItem) {
    if (this.outputs == null) {
      this.outputs = new ArrayList<>();
    }
    this.outputs.add(outputsItem);
    return this;
  }

  /**
   * Get outputs
   * @return outputs
  */
  @NotNull
  @Schema(name = "outputs", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("outputs")
  public List<String> getOutputs() {
    return outputs;
  }

  public void setOutputs(List<String> outputs) {
    this.outputs = outputs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataTransformer dataTransformer = (DataTransformer) o;
    return Objects.equals(this.sourceCodeUrl, dataTransformer.sourceCodeUrl) &&
        Objects.equals(this.sql, dataTransformer.sql) &&
        Objects.equals(this.inputs, dataTransformer.inputs) &&
        Objects.equals(this.outputs, dataTransformer.outputs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceCodeUrl, sql, inputs, outputs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataTransformer {\n");
    sb.append("    sourceCodeUrl: ").append(toIndentedString(sourceCodeUrl)).append("\n");
    sb.append("    sql: ").append(toIndentedString(sql)).append("\n");
    sb.append("    inputs: ").append(toIndentedString(inputs)).append("\n");
    sb.append("    outputs: ").append(toIndentedString(outputs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

