package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.JobRunStatus;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DataTransformerRun
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DataTransformerRun {

  private String transformerOddrn;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime startTime;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime endTime;

  private String statusReason;

  private JobRunStatus status;

  /**
   * Default constructor
   * @deprecated Use {@link DataTransformerRun#DataTransformerRun(String, OffsetDateTime, JobRunStatus)}
   */
  @Deprecated
  public DataTransformerRun() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DataTransformerRun(String transformerOddrn, OffsetDateTime startTime, JobRunStatus status) {
    this.transformerOddrn = transformerOddrn;
    this.startTime = startTime;
    this.status = status;
  }

  public DataTransformerRun transformerOddrn(String transformerOddrn) {
    this.transformerOddrn = transformerOddrn;
    return this;
  }

  /**
   * Get transformerOddrn
   * @return transformerOddrn
  */
  @NotNull
  @Schema(name = "transformer_oddrn", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("transformer_oddrn")
  public String getTransformerOddrn() {
    return transformerOddrn;
  }

  public void setTransformerOddrn(String transformerOddrn) {
    this.transformerOddrn = transformerOddrn;
  }

  public DataTransformerRun startTime(OffsetDateTime startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Get startTime
   * @return startTime
  */
  @NotNull
  @Schema(name = "start_time", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("start_time")
  public OffsetDateTime getStartTime() {
    return startTime;
  }

  public void setStartTime(OffsetDateTime startTime) {
    this.startTime = startTime;
  }

  public DataTransformerRun endTime(OffsetDateTime endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Get endTime
   * @return endTime
  */
  
  @Schema(name = "end_time", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("end_time")
  public OffsetDateTime getEndTime() {
    return endTime;
  }

  public void setEndTime(OffsetDateTime endTime) {
    this.endTime = endTime;
  }

  public DataTransformerRun statusReason(String statusReason) {
    this.statusReason = statusReason;
    return this;
  }

  /**
   * Get statusReason
   * @return statusReason
  */
  
  @Schema(name = "status_reason", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("status_reason")
  public String getStatusReason() {
    return statusReason;
  }

  public void setStatusReason(String statusReason) {
    this.statusReason = statusReason;
  }

  public DataTransformerRun status(JobRunStatus status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @NotNull
  @Schema(name = "status", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("status")
  public JobRunStatus getStatus() {
    return status;
  }

  public void setStatus(JobRunStatus status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataTransformerRun dataTransformerRun = (DataTransformerRun) o;
    return Objects.equals(this.transformerOddrn, dataTransformerRun.transformerOddrn) &&
        Objects.equals(this.startTime, dataTransformerRun.startTime) &&
        Objects.equals(this.endTime, dataTransformerRun.endTime) &&
        Objects.equals(this.statusReason, dataTransformerRun.statusReason) &&
        Objects.equals(this.status, dataTransformerRun.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transformerOddrn, startTime, endTime, statusReason, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataTransformerRun {\n");
    sb.append("    transformerOddrn: ").append(toIndentedString(transformerOddrn)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    statusReason: ").append(toIndentedString(statusReason)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

