package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * DateTimeFieldStat
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class DateTimeFieldStat {

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime lowValue;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime highValue;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime meanValue;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime medianValue;

  private Long nullsCount;

  private Long uniqueCount;

  /**
   * Default constructor
   * @deprecated Use {@link DateTimeFieldStat#DateTimeFieldStat(OffsetDateTime, OffsetDateTime, Long, Long)}
   */
  @Deprecated
  public DateTimeFieldStat() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public DateTimeFieldStat(OffsetDateTime lowValue, OffsetDateTime highValue, Long nullsCount, Long uniqueCount) {
    this.lowValue = lowValue;
    this.highValue = highValue;
    this.nullsCount = nullsCount;
    this.uniqueCount = uniqueCount;
  }

  public DateTimeFieldStat lowValue(OffsetDateTime lowValue) {
    this.lowValue = lowValue;
    return this;
  }

  /**
   * Get lowValue
   * @return lowValue
  */
  @NotNull
  @Schema(name = "low_value", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("low_value")
  public OffsetDateTime getLowValue() {
    return lowValue;
  }

  public void setLowValue(OffsetDateTime lowValue) {
    this.lowValue = lowValue;
  }

  public DateTimeFieldStat highValue(OffsetDateTime highValue) {
    this.highValue = highValue;
    return this;
  }

  /**
   * Get highValue
   * @return highValue
  */
  @NotNull
  @Schema(name = "high_value", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("high_value")
  public OffsetDateTime getHighValue() {
    return highValue;
  }

  public void setHighValue(OffsetDateTime highValue) {
    this.highValue = highValue;
  }

  public DateTimeFieldStat meanValue(OffsetDateTime meanValue) {
    this.meanValue = meanValue;
    return this;
  }

  /**
   * Get meanValue
   * @return meanValue
  */
  
  @Schema(name = "mean_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("mean_value")
  public OffsetDateTime getMeanValue() {
    return meanValue;
  }

  public void setMeanValue(OffsetDateTime meanValue) {
    this.meanValue = meanValue;
  }

  public DateTimeFieldStat medianValue(OffsetDateTime medianValue) {
    this.medianValue = medianValue;
    return this;
  }

  /**
   * Get medianValue
   * @return medianValue
  */
  
  @Schema(name = "median_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("median_value")
  public OffsetDateTime getMedianValue() {
    return medianValue;
  }

  public void setMedianValue(OffsetDateTime medianValue) {
    this.medianValue = medianValue;
  }

  public DateTimeFieldStat nullsCount(Long nullsCount) {
    this.nullsCount = nullsCount;
    return this;
  }

  /**
   * Get nullsCount
   * @return nullsCount
  */
  @NotNull
  @Schema(name = "nulls_count", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("nulls_count")
  public Long getNullsCount() {
    return nullsCount;
  }

  public void setNullsCount(Long nullsCount) {
    this.nullsCount = nullsCount;
  }

  public DateTimeFieldStat uniqueCount(Long uniqueCount) {
    this.uniqueCount = uniqueCount;
    return this;
  }

  /**
   * Get uniqueCount
   * @return uniqueCount
  */
  @NotNull
  @Schema(name = "unique_count", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("unique_count")
  public Long getUniqueCount() {
    return uniqueCount;
  }

  public void setUniqueCount(Long uniqueCount) {
    this.uniqueCount = uniqueCount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DateTimeFieldStat dateTimeFieldStat = (DateTimeFieldStat) o;
    return Objects.equals(this.lowValue, dateTimeFieldStat.lowValue) &&
        Objects.equals(this.highValue, dateTimeFieldStat.highValue) &&
        Objects.equals(this.meanValue, dateTimeFieldStat.meanValue) &&
        Objects.equals(this.medianValue, dateTimeFieldStat.medianValue) &&
        Objects.equals(this.nullsCount, dateTimeFieldStat.nullsCount) &&
        Objects.equals(this.uniqueCount, dateTimeFieldStat.uniqueCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lowValue, highValue, meanValue, medianValue, nullsCount, uniqueCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DateTimeFieldStat {\n");
    sb.append("    lowValue: ").append(toIndentedString(lowValue)).append("\n");
    sb.append("    highValue: ").append(toIndentedString(highValue)).append("\n");
    sb.append("    meanValue: ").append(toIndentedString(meanValue)).append("\n");
    sb.append("    medianValue: ").append(toIndentedString(medianValue)).append("\n");
    sb.append("    nullsCount: ").append(toIndentedString(nullsCount)).append("\n");
    sb.append("    uniqueCount: ").append(toIndentedString(uniqueCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

