package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.CardinalityType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * ERDRelationship
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class ERDRelationship implements RelationshipDetails {

  
  private List<String> sourceDatasetFieldOddrnsList = new ArrayList<>();

  
  private List<String> targetDatasetFieldOddrnsList = new ArrayList<>();

  private Boolean isIdentifying;

  private CardinalityType cardinality;

  private String relationshipEntityName;

  /**
   * Default constructor
   * @deprecated Use {@link ERDRelationship#ERDRelationship(List<String>, List<String>, String)}
   */
  @Deprecated
  public ERDRelationship() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public ERDRelationship(List<String> sourceDatasetFieldOddrnsList, List<String> targetDatasetFieldOddrnsList, String relationshipEntityName) {
    this.sourceDatasetFieldOddrnsList = sourceDatasetFieldOddrnsList;
    this.targetDatasetFieldOddrnsList = targetDatasetFieldOddrnsList;
    this.relationshipEntityName = relationshipEntityName;
  }

  public ERDRelationship sourceDatasetFieldOddrnsList(List<String> sourceDatasetFieldOddrnsList) {
    this.sourceDatasetFieldOddrnsList = sourceDatasetFieldOddrnsList;
    return this;
  }

  public ERDRelationship addSourceDatasetFieldOddrnsListItem(String sourceDatasetFieldOddrnsListItem) {
    if (this.sourceDatasetFieldOddrnsList == null) {
      this.sourceDatasetFieldOddrnsList = new ArrayList<>();
    }
    this.sourceDatasetFieldOddrnsList.add(sourceDatasetFieldOddrnsListItem);
    return this;
  }

  /**
   * Get sourceDatasetFieldOddrnsList
   * @return sourceDatasetFieldOddrnsList
  */
  @NotNull
  @Schema(name = "source_dataset_field_oddrns_list", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("source_dataset_field_oddrns_list")
  public List<String> getSourceDatasetFieldOddrnsList() {
    return sourceDatasetFieldOddrnsList;
  }

  public void setSourceDatasetFieldOddrnsList(List<String> sourceDatasetFieldOddrnsList) {
    this.sourceDatasetFieldOddrnsList = sourceDatasetFieldOddrnsList;
  }

  public ERDRelationship targetDatasetFieldOddrnsList(List<String> targetDatasetFieldOddrnsList) {
    this.targetDatasetFieldOddrnsList = targetDatasetFieldOddrnsList;
    return this;
  }

  public ERDRelationship addTargetDatasetFieldOddrnsListItem(String targetDatasetFieldOddrnsListItem) {
    if (this.targetDatasetFieldOddrnsList == null) {
      this.targetDatasetFieldOddrnsList = new ArrayList<>();
    }
    this.targetDatasetFieldOddrnsList.add(targetDatasetFieldOddrnsListItem);
    return this;
  }

  /**
   * Get targetDatasetFieldOddrnsList
   * @return targetDatasetFieldOddrnsList
  */
  @NotNull
  @Schema(name = "target_dataset_field_oddrns_list", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("target_dataset_field_oddrns_list")
  public List<String> getTargetDatasetFieldOddrnsList() {
    return targetDatasetFieldOddrnsList;
  }

  public void setTargetDatasetFieldOddrnsList(List<String> targetDatasetFieldOddrnsList) {
    this.targetDatasetFieldOddrnsList = targetDatasetFieldOddrnsList;
  }

  public ERDRelationship isIdentifying(Boolean isIdentifying) {
    this.isIdentifying = isIdentifying;
    return this;
  }

  /**
   * Get isIdentifying
   * @return isIdentifying
  */
  
  @Schema(name = "is_identifying", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_identifying")
  public Boolean getIsIdentifying() {
    return isIdentifying;
  }

  public void setIsIdentifying(Boolean isIdentifying) {
    this.isIdentifying = isIdentifying;
  }

  public ERDRelationship cardinality(CardinalityType cardinality) {
    this.cardinality = cardinality;
    return this;
  }

  /**
   * Get cardinality
   * @return cardinality
  */
  
  @Schema(name = "cardinality", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("cardinality")
  public CardinalityType getCardinality() {
    return cardinality;
  }

  public void setCardinality(CardinalityType cardinality) {
    this.cardinality = cardinality;
  }

  public ERDRelationship relationshipEntityName(String relationshipEntityName) {
    this.relationshipEntityName = relationshipEntityName;
    return this;
  }

  /**
   * Get relationshipEntityName
   * @return relationshipEntityName
  */
  @NotNull
  @Schema(name = "relationship_entity_name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("relationship_entity_name")
  public String getRelationshipEntityName() {
    return relationshipEntityName;
  }

  public void setRelationshipEntityName(String relationshipEntityName) {
    this.relationshipEntityName = relationshipEntityName;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ERDRelationship erDRelationship = (ERDRelationship) o;
    return Objects.equals(this.sourceDatasetFieldOddrnsList, erDRelationship.sourceDatasetFieldOddrnsList) &&
        Objects.equals(this.targetDatasetFieldOddrnsList, erDRelationship.targetDatasetFieldOddrnsList) &&
        Objects.equals(this.isIdentifying, erDRelationship.isIdentifying) &&
        Objects.equals(this.cardinality, erDRelationship.cardinality) &&
        Objects.equals(this.relationshipEntityName, erDRelationship.relationshipEntityName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceDatasetFieldOddrnsList, targetDatasetFieldOddrnsList, isIdentifying, cardinality, relationshipEntityName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ERDRelationship {\n");
    sb.append("    sourceDatasetFieldOddrnsList: ").append(toIndentedString(sourceDatasetFieldOddrnsList)).append("\n");
    sb.append("    targetDatasetFieldOddrnsList: ").append(toIndentedString(targetDatasetFieldOddrnsList)).append("\n");
    sb.append("    isIdentifying: ").append(toIndentedString(isIdentifying)).append("\n");
    sb.append("    cardinality: ").append(toIndentedString(cardinality)).append("\n");
    sb.append("    relationshipEntityName: ").append(toIndentedString(relationshipEntityName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

