package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * GraphRelationship
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class GraphRelationship implements RelationshipDetails {

  private Boolean isDirected;

  private String relationshipEntityName;

  
  private Map<String, Object> attributes = new HashMap<>();

  /**
   * Default constructor
   * @deprecated Use {@link GraphRelationship#GraphRelationship(String)}
   */
  @Deprecated
  public GraphRelationship() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public GraphRelationship(String relationshipEntityName) {
    this.relationshipEntityName = relationshipEntityName;
  }

  public GraphRelationship isDirected(Boolean isDirected) {
    this.isDirected = isDirected;
    return this;
  }

  /**
   * Get isDirected
   * @return isDirected
  */
  
  @Schema(name = "is_directed", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("is_directed")
  public Boolean getIsDirected() {
    return isDirected;
  }

  public void setIsDirected(Boolean isDirected) {
    this.isDirected = isDirected;
  }

  public GraphRelationship relationshipEntityName(String relationshipEntityName) {
    this.relationshipEntityName = relationshipEntityName;
    return this;
  }

  /**
   * Get relationshipEntityName
   * @return relationshipEntityName
  */
  @NotNull
  @Schema(name = "relationship_entity_name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("relationship_entity_name")
  public String getRelationshipEntityName() {
    return relationshipEntityName;
  }

  public void setRelationshipEntityName(String relationshipEntityName) {
    this.relationshipEntityName = relationshipEntityName;
  }

  public GraphRelationship attributes(Map<String, Object> attributes) {
    this.attributes = attributes;
    return this;
  }

  public GraphRelationship putAttributesItem(String key, Object attributesItem) {
    if (this.attributes == null) {
      this.attributes = new HashMap<>();
    }
    this.attributes.put(key, attributesItem);
    return this;
  }

  /**
   * Get attributes
   * @return attributes
  */
  
  @Schema(name = "attributes", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attributes")
  public Map<String, Object> getAttributes() {
    return attributes;
  }

  public void setAttributes(Map<String, Object> attributes) {
    this.attributes = attributes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GraphRelationship graphRelationship = (GraphRelationship) o;
    return Objects.equals(this.isDirected, graphRelationship.isDirected) &&
        Objects.equals(this.relationshipEntityName, graphRelationship.relationshipEntityName) &&
        Objects.equals(this.attributes, graphRelationship.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isDirected, relationshipEntityName, attributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GraphRelationship {\n");
    sb.append("    isDirected: ").append(toIndentedString(isDirected)).append("\n");
    sb.append("    relationshipEntityName: ").append(toIndentedString(relationshipEntityName)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

