package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.IngestionAlertType;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * IngestionAlert
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class IngestionAlert {

  private String dataSourceOddrn;

  private String message;

  private IngestionAlertType type;

  /**
   * Default constructor
   * @deprecated Use {@link IngestionAlert#IngestionAlert(String, String, IngestionAlertType)}
   */
  @Deprecated
  public IngestionAlert() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public IngestionAlert(String dataSourceOddrn, String message, IngestionAlertType type) {
    this.dataSourceOddrn = dataSourceOddrn;
    this.message = message;
    this.type = type;
  }

  public IngestionAlert dataSourceOddrn(String dataSourceOddrn) {
    this.dataSourceOddrn = dataSourceOddrn;
    return this;
  }

  /**
   * Get dataSourceOddrn
   * @return dataSourceOddrn
  */
  @NotNull
  @Schema(name = "data_source_oddrn", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("data_source_oddrn")
  public String getDataSourceOddrn() {
    return dataSourceOddrn;
  }

  public void setDataSourceOddrn(String dataSourceOddrn) {
    this.dataSourceOddrn = dataSourceOddrn;
  }

  public IngestionAlert message(String message) {
    this.message = message;
    return this;
  }

  /**
   * Get message
   * @return message
  */
  @NotNull
  @Schema(name = "message", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("message")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  public IngestionAlert type(IngestionAlertType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @NotNull
  @Schema(name = "type", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public IngestionAlertType getType() {
    return type;
  }

  public void setType(IngestionAlertType type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    IngestionAlert ingestionAlert = (IngestionAlert) o;
    return Objects.equals(this.dataSourceOddrn, ingestionAlert.dataSourceOddrn) &&
        Objects.equals(this.message, ingestionAlert.message) &&
        Objects.equals(this.type, ingestionAlert.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dataSourceOddrn, message, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class IngestionAlert {\n");
    sb.append("    dataSourceOddrn: ").append(toIndentedString(dataSourceOddrn)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

