package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Label;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetricPoint;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Metric
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class Metric {

  
  private List<Label> labels;

  
  private List<MetricPoint> metricPoints = new ArrayList<>();

  /**
   * Default constructor
   * @deprecated Use {@link Metric#Metric(List<MetricPoint>)}
   */
  @Deprecated
  public Metric() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public Metric(List<MetricPoint> metricPoints) {
    this.metricPoints = metricPoints;
  }

  public Metric labels(List<Label> labels) {
    this.labels = labels;
    return this;
  }

  public Metric addLabelsItem(Label labelsItem) {
    if (this.labels == null) {
      this.labels = new ArrayList<>();
    }
    this.labels.add(labelsItem);
    return this;
  }

  /**
   * Get labels
   * @return labels
  */
  
  @Schema(name = "labels", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("labels")
  public List<Label> getLabels() {
    return labels;
  }

  public void setLabels(List<Label> labels) {
    this.labels = labels;
  }

  public Metric metricPoints(List<MetricPoint> metricPoints) {
    this.metricPoints = metricPoints;
    return this;
  }

  public Metric addMetricPointsItem(MetricPoint metricPointsItem) {
    if (this.metricPoints == null) {
      this.metricPoints = new ArrayList<>();
    }
    this.metricPoints.add(metricPointsItem);
    return this;
  }

  /**
   * Get metricPoints
   * @return metricPoints
  */
  @NotNull
  @Schema(name = "metric_points", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("metric_points")
  public List<MetricPoint> getMetricPoints() {
    return metricPoints;
  }

  public void setMetricPoints(List<MetricPoint> metricPoints) {
    this.metricPoints = metricPoints;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Metric metric = (Metric) o;
    return Objects.equals(this.labels, metric.labels) &&
        Objects.equals(this.metricPoints, metric.metricPoints);
  }

  @Override
  public int hashCode() {
    return Objects.hash(labels, metricPoints);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Metric {\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    metricPoints: ").append(toIndentedString(metricPoints)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

