package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Metric;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetricType;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * MetricFamily
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class MetricFamily {

  private String name;

  private MetricType type;

  private String unit;

  private String help;

  
  private List<Metric> metrics = new ArrayList<>();

  /**
   * Default constructor
   * @deprecated Use {@link MetricFamily#MetricFamily(String, MetricType, String, List<Metric>)}
   */
  @Deprecated
  public MetricFamily() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public MetricFamily(String name, MetricType type, String unit, List<Metric> metrics) {
    this.name = name;
    this.type = type;
    this.unit = unit;
    this.metrics = metrics;
  }

  public MetricFamily name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull
  @Schema(name = "name", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public MetricFamily type(MetricType type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  @NotNull
  @Schema(name = "type", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public MetricType getType() {
    return type;
  }

  public void setType(MetricType type) {
    this.type = type;
  }

  public MetricFamily unit(String unit) {
    this.unit = unit;
    return this;
  }

  /**
   * Get unit
   * @return unit
  */
  @NotNull
  @Schema(name = "unit", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("unit")
  public String getUnit() {
    return unit;
  }

  public void setUnit(String unit) {
    this.unit = unit;
  }

  public MetricFamily help(String help) {
    this.help = help;
    return this;
  }

  /**
   * Get help
   * @return help
  */
  
  @Schema(name = "help", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("help")
  public String getHelp() {
    return help;
  }

  public void setHelp(String help) {
    this.help = help;
  }

  public MetricFamily metrics(List<Metric> metrics) {
    this.metrics = metrics;
    return this;
  }

  public MetricFamily addMetricsItem(Metric metricsItem) {
    if (this.metrics == null) {
      this.metrics = new ArrayList<>();
    }
    this.metrics.add(metricsItem);
    return this;
  }

  /**
   * Get metrics
   * @return metrics
  */
  @NotNull
  @Schema(name = "metrics", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("metrics")
  public List<Metric> getMetrics() {
    return metrics;
  }

  public void setMetrics(List<Metric> metrics) {
    this.metrics = metrics;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetricFamily metricFamily = (MetricFamily) o;
    return Objects.equals(this.name, metricFamily.name) &&
        Objects.equals(this.type, metricFamily.type) &&
        Objects.equals(this.unit, metricFamily.unit) &&
        Objects.equals(this.help, metricFamily.help) &&
        Objects.equals(this.metrics, metricFamily.metrics);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, type, unit, help, metrics);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetricFamily {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("    help: ").append(toIndentedString(help)).append("\n");
    sb.append("    metrics: ").append(toIndentedString(metrics)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

