package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.CounterValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.GaugeValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.HistogramValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.InfoValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.StateSetValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.SummaryValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.UnknownValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * MetricPoint
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class MetricPoint {

  private Integer timestamp;

  private UnknownValue unknownValue;

  private GaugeValue gaugeValue;

  private CounterValue counterValue;

  private HistogramValue histogramValue;

  private StateSetValue stateSetValue;

  private InfoValue infoValue;

  private SummaryValue summaryValue;

  public MetricPoint timestamp(Integer timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  /**
   * Get timestamp
   * @return timestamp
  */
  
  @Schema(name = "timestamp", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("timestamp")
  public Integer getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(Integer timestamp) {
    this.timestamp = timestamp;
  }

  public MetricPoint unknownValue(UnknownValue unknownValue) {
    this.unknownValue = unknownValue;
    return this;
  }

  /**
   * Get unknownValue
   * @return unknownValue
  */
  
  @Schema(name = "unknown_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("unknown_value")
  public UnknownValue getUnknownValue() {
    return unknownValue;
  }

  public void setUnknownValue(UnknownValue unknownValue) {
    this.unknownValue = unknownValue;
  }

  public MetricPoint gaugeValue(GaugeValue gaugeValue) {
    this.gaugeValue = gaugeValue;
    return this;
  }

  /**
   * Get gaugeValue
   * @return gaugeValue
  */
  
  @Schema(name = "gauge_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("gauge_value")
  public GaugeValue getGaugeValue() {
    return gaugeValue;
  }

  public void setGaugeValue(GaugeValue gaugeValue) {
    this.gaugeValue = gaugeValue;
  }

  public MetricPoint counterValue(CounterValue counterValue) {
    this.counterValue = counterValue;
    return this;
  }

  /**
   * Get counterValue
   * @return counterValue
  */
  
  @Schema(name = "counter_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("counter_value")
  public CounterValue getCounterValue() {
    return counterValue;
  }

  public void setCounterValue(CounterValue counterValue) {
    this.counterValue = counterValue;
  }

  public MetricPoint histogramValue(HistogramValue histogramValue) {
    this.histogramValue = histogramValue;
    return this;
  }

  /**
   * Get histogramValue
   * @return histogramValue
  */
  
  @Schema(name = "histogram_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("histogram_value")
  public HistogramValue getHistogramValue() {
    return histogramValue;
  }

  public void setHistogramValue(HistogramValue histogramValue) {
    this.histogramValue = histogramValue;
  }

  public MetricPoint stateSetValue(StateSetValue stateSetValue) {
    this.stateSetValue = stateSetValue;
    return this;
  }

  /**
   * Get stateSetValue
   * @return stateSetValue
  */
  
  @Schema(name = "state_set_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("state_set_value")
  public StateSetValue getStateSetValue() {
    return stateSetValue;
  }

  public void setStateSetValue(StateSetValue stateSetValue) {
    this.stateSetValue = stateSetValue;
  }

  public MetricPoint infoValue(InfoValue infoValue) {
    this.infoValue = infoValue;
    return this;
  }

  /**
   * Get infoValue
   * @return infoValue
  */
  
  @Schema(name = "info_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("info_value")
  public InfoValue getInfoValue() {
    return infoValue;
  }

  public void setInfoValue(InfoValue infoValue) {
    this.infoValue = infoValue;
  }

  public MetricPoint summaryValue(SummaryValue summaryValue) {
    this.summaryValue = summaryValue;
    return this;
  }

  /**
   * Get summaryValue
   * @return summaryValue
  */
  
  @Schema(name = "summary_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("summary_value")
  public SummaryValue getSummaryValue() {
    return summaryValue;
  }

  public void setSummaryValue(SummaryValue summaryValue) {
    this.summaryValue = summaryValue;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetricPoint metricPoint = (MetricPoint) o;
    return Objects.equals(this.timestamp, metricPoint.timestamp) &&
        Objects.equals(this.unknownValue, metricPoint.unknownValue) &&
        Objects.equals(this.gaugeValue, metricPoint.gaugeValue) &&
        Objects.equals(this.counterValue, metricPoint.counterValue) &&
        Objects.equals(this.histogramValue, metricPoint.histogramValue) &&
        Objects.equals(this.stateSetValue, metricPoint.stateSetValue) &&
        Objects.equals(this.infoValue, metricPoint.infoValue) &&
        Objects.equals(this.summaryValue, metricPoint.summaryValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(timestamp, unknownValue, gaugeValue, counterValue, histogramValue, stateSetValue, infoValue, summaryValue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetricPoint {\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    unknownValue: ").append(toIndentedString(unknownValue)).append("\n");
    sb.append("    gaugeValue: ").append(toIndentedString(gaugeValue)).append("\n");
    sb.append("    counterValue: ").append(toIndentedString(counterValue)).append("\n");
    sb.append("    histogramValue: ").append(toIndentedString(histogramValue)).append("\n");
    sb.append("    stateSetValue: ").append(toIndentedString(stateSetValue)).append("\n");
    sb.append("    infoValue: ").append(toIndentedString(infoValue)).append("\n");
    sb.append("    summaryValue: ").append(toIndentedString(summaryValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

