package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.List;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetricFamily;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * MetricSet
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class MetricSet {

  private String oddrn;

  
  private List<MetricFamily> metricFamilies = new ArrayList<>();

  /**
   * Default constructor
   * @deprecated Use {@link MetricSet#MetricSet(String, List<MetricFamily>)}
   */
  @Deprecated
  public MetricSet() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public MetricSet(String oddrn, List<MetricFamily> metricFamilies) {
    this.oddrn = oddrn;
    this.metricFamilies = metricFamilies;
  }

  public MetricSet oddrn(String oddrn) {
    this.oddrn = oddrn;
    return this;
  }

  /**
   * The ODDRN of data entity or dataset field
   * @return oddrn
  */
  @NotNull
  @Schema(name = "oddrn", description = "The ODDRN of data entity or dataset field", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("oddrn")
  public String getOddrn() {
    return oddrn;
  }

  public void setOddrn(String oddrn) {
    this.oddrn = oddrn;
  }

  public MetricSet metricFamilies(List<MetricFamily> metricFamilies) {
    this.metricFamilies = metricFamilies;
    return this;
  }

  public MetricSet addMetricFamiliesItem(MetricFamily metricFamiliesItem) {
    if (this.metricFamilies == null) {
      this.metricFamilies = new ArrayList<>();
    }
    this.metricFamilies.add(metricFamiliesItem);
    return this;
  }

  /**
   * Get metricFamilies
   * @return metricFamilies
  */
  @NotNull
  @Schema(name = "metric_families", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("metric_families")
  public List<MetricFamily> getMetricFamilies() {
    return metricFamilies;
  }

  public void setMetricFamilies(List<MetricFamily> metricFamilies) {
    this.metricFamilies = metricFamilies;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetricSet metricSet = (MetricSet) o;
    return Objects.equals(this.oddrn, metricSet.oddrn) &&
        Objects.equals(this.metricFamilies, metricSet.metricFamilies);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oddrn, metricFamilies);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetricSet {\n");
    sb.append("    oddrn: ").append(toIndentedString(oddrn)).append("\n");
    sb.append("    metricFamilies: ").append(toIndentedString(metricFamilies)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

