package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.math.BigDecimal;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * NumberFieldStat
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class NumberFieldStat {

  private BigDecimal lowValue;

  private BigDecimal highValue;

  private BigDecimal meanValue;

  private BigDecimal medianValue;

  private Long nullsCount;

  private Long uniqueCount;

  /**
   * Default constructor
   * @deprecated Use {@link NumberFieldStat#NumberFieldStat(BigDecimal, BigDecimal, Long, Long)}
   */
  @Deprecated
  public NumberFieldStat() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public NumberFieldStat(BigDecimal lowValue, BigDecimal highValue, Long nullsCount, Long uniqueCount) {
    this.lowValue = lowValue;
    this.highValue = highValue;
    this.nullsCount = nullsCount;
    this.uniqueCount = uniqueCount;
  }

  public NumberFieldStat lowValue(BigDecimal lowValue) {
    this.lowValue = lowValue;
    return this;
  }

  /**
   * Get lowValue
   * @return lowValue
  */
  @NotNull
  @Schema(name = "low_value", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("low_value")
  public BigDecimal getLowValue() {
    return lowValue;
  }

  public void setLowValue(BigDecimal lowValue) {
    this.lowValue = lowValue;
  }

  public NumberFieldStat highValue(BigDecimal highValue) {
    this.highValue = highValue;
    return this;
  }

  /**
   * Get highValue
   * @return highValue
  */
  @NotNull
  @Schema(name = "high_value", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("high_value")
  public BigDecimal getHighValue() {
    return highValue;
  }

  public void setHighValue(BigDecimal highValue) {
    this.highValue = highValue;
  }

  public NumberFieldStat meanValue(BigDecimal meanValue) {
    this.meanValue = meanValue;
    return this;
  }

  /**
   * Get meanValue
   * @return meanValue
  */
  
  @Schema(name = "mean_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("mean_value")
  public BigDecimal getMeanValue() {
    return meanValue;
  }

  public void setMeanValue(BigDecimal meanValue) {
    this.meanValue = meanValue;
  }

  public NumberFieldStat medianValue(BigDecimal medianValue) {
    this.medianValue = medianValue;
    return this;
  }

  /**
   * Get medianValue
   * @return medianValue
  */
  
  @Schema(name = "median_value", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("median_value")
  public BigDecimal getMedianValue() {
    return medianValue;
  }

  public void setMedianValue(BigDecimal medianValue) {
    this.medianValue = medianValue;
  }

  public NumberFieldStat nullsCount(Long nullsCount) {
    this.nullsCount = nullsCount;
    return this;
  }

  /**
   * Get nullsCount
   * @return nullsCount
  */
  @NotNull
  @Schema(name = "nulls_count", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("nulls_count")
  public Long getNullsCount() {
    return nullsCount;
  }

  public void setNullsCount(Long nullsCount) {
    this.nullsCount = nullsCount;
  }

  public NumberFieldStat uniqueCount(Long uniqueCount) {
    this.uniqueCount = uniqueCount;
    return this;
  }

  /**
   * Get uniqueCount
   * @return uniqueCount
  */
  @NotNull
  @Schema(name = "unique_count", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("unique_count")
  public Long getUniqueCount() {
    return uniqueCount;
  }

  public void setUniqueCount(Long uniqueCount) {
    this.uniqueCount = uniqueCount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NumberFieldStat numberFieldStat = (NumberFieldStat) o;
    return Objects.equals(this.lowValue, numberFieldStat.lowValue) &&
        Objects.equals(this.highValue, numberFieldStat.highValue) &&
        Objects.equals(this.meanValue, numberFieldStat.meanValue) &&
        Objects.equals(this.medianValue, numberFieldStat.medianValue) &&
        Objects.equals(this.nullsCount, numberFieldStat.nullsCount) &&
        Objects.equals(this.uniqueCount, numberFieldStat.uniqueCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lowValue, highValue, meanValue, medianValue, nullsCount, uniqueCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NumberFieldStat {\n");
    sb.append("    lowValue: ").append(toIndentedString(lowValue)).append("\n");
    sb.append("    highValue: ").append(toIndentedString(highValue)).append("\n");
    sb.append("    meanValue: ").append(toIndentedString(meanValue)).append("\n");
    sb.append("    medianValue: ").append(toIndentedString(medianValue)).append("\n");
    sb.append("    nullsCount: ").append(toIndentedString(nullsCount)).append("\n");
    sb.append("    uniqueCount: ").append(toIndentedString(uniqueCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

