package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.RelationshipDetails;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Relationship
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class Relationship {

  /**
   * Gets or Sets relationshipType
   */
  public enum RelationshipTypeEnum {
    ERD("ERD"),
    
    GRAPH("GRAPH");

    private String value;

    RelationshipTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RelationshipTypeEnum fromValue(String value) {
      for (RelationshipTypeEnum b : RelationshipTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private RelationshipTypeEnum relationshipType;

  private String sourceDatasetOddrn;

  private String targetDatasetOddrn;

  private RelationshipDetails details;

  /**
   * Default constructor
   * @deprecated Use {@link Relationship#Relationship(RelationshipTypeEnum, String, String, RelationshipDetails)}
   */
  @Deprecated
  public Relationship() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public Relationship(RelationshipTypeEnum relationshipType, String sourceDatasetOddrn, String targetDatasetOddrn, RelationshipDetails details) {
    this.relationshipType = relationshipType;
    this.sourceDatasetOddrn = sourceDatasetOddrn;
    this.targetDatasetOddrn = targetDatasetOddrn;
    this.details = details;
  }

  public Relationship relationshipType(RelationshipTypeEnum relationshipType) {
    this.relationshipType = relationshipType;
    return this;
  }

  /**
   * Get relationshipType
   * @return relationshipType
  */
  @NotNull
  @Schema(name = "relationship_type", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("relationship_type")
  public RelationshipTypeEnum getRelationshipType() {
    return relationshipType;
  }

  public void setRelationshipType(RelationshipTypeEnum relationshipType) {
    this.relationshipType = relationshipType;
  }

  public Relationship sourceDatasetOddrn(String sourceDatasetOddrn) {
    this.sourceDatasetOddrn = sourceDatasetOddrn;
    return this;
  }

  /**
   * Get sourceDatasetOddrn
   * @return sourceDatasetOddrn
  */
  @NotNull
  @Schema(name = "source_dataset_oddrn", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("source_dataset_oddrn")
  public String getSourceDatasetOddrn() {
    return sourceDatasetOddrn;
  }

  public void setSourceDatasetOddrn(String sourceDatasetOddrn) {
    this.sourceDatasetOddrn = sourceDatasetOddrn;
  }

  public Relationship targetDatasetOddrn(String targetDatasetOddrn) {
    this.targetDatasetOddrn = targetDatasetOddrn;
    return this;
  }

  /**
   * Get targetDatasetOddrn
   * @return targetDatasetOddrn
  */
  @NotNull
  @Schema(name = "target_dataset_oddrn", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("target_dataset_oddrn")
  public String getTargetDatasetOddrn() {
    return targetDatasetOddrn;
  }

  public void setTargetDatasetOddrn(String targetDatasetOddrn) {
    this.targetDatasetOddrn = targetDatasetOddrn;
  }

  public Relationship details(RelationshipDetails details) {
    this.details = details;
    return this;
  }

  /**
   * Get details
   * @return details
  */
  @NotNull
  @Schema(name = "details", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("details")
  public RelationshipDetails getDetails() {
    return details;
  }

  public void setDetails(RelationshipDetails details) {
    this.details = details;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Relationship relationship = (Relationship) o;
    return Objects.equals(this.relationshipType, relationship.relationshipType) &&
        Objects.equals(this.sourceDatasetOddrn, relationship.sourceDatasetOddrn) &&
        Objects.equals(this.targetDatasetOddrn, relationship.targetDatasetOddrn) &&
        Objects.equals(this.details, relationship.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(relationshipType, sourceDatasetOddrn, targetDatasetOddrn, details);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Relationship {\n");
    sb.append("    relationshipType: ").append(toIndentedString(relationshipType)).append("\n");
    sb.append("    sourceDatasetOddrn: ").append(toIndentedString(sourceDatasetOddrn)).append("\n");
    sb.append("    targetDatasetOddrn: ").append(toIndentedString(targetDatasetOddrn)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

