package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.math.BigDecimal;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import jakarta.validation.constraints.NotNull;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * StringFieldStat
 */

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2024-01-25T14:34:00.516853964Z[Etc/UTC]")
public class StringFieldStat {

  private Integer maxLength;

  private BigDecimal avgLength;

  private Long nullsCount;

  private Long uniqueCount;

  /**
   * Default constructor
   * @deprecated Use {@link StringFieldStat#StringFieldStat(Integer, BigDecimal, Long, Long)}
   */
  @Deprecated
  public StringFieldStat() {
    super();
  }

  /**
   * Constructor with only required parameters
   */
  public StringFieldStat(Integer maxLength, BigDecimal avgLength, Long nullsCount, Long uniqueCount) {
    this.maxLength = maxLength;
    this.avgLength = avgLength;
    this.nullsCount = nullsCount;
    this.uniqueCount = uniqueCount;
  }

  public StringFieldStat maxLength(Integer maxLength) {
    this.maxLength = maxLength;
    return this;
  }

  /**
   * Get maxLength
   * @return maxLength
  */
  @NotNull
  @Schema(name = "max_length", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("max_length")
  public Integer getMaxLength() {
    return maxLength;
  }

  public void setMaxLength(Integer maxLength) {
    this.maxLength = maxLength;
  }

  public StringFieldStat avgLength(BigDecimal avgLength) {
    this.avgLength = avgLength;
    return this;
  }

  /**
   * Get avgLength
   * @return avgLength
  */
  @NotNull
  @Schema(name = "avg_length", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("avg_length")
  public BigDecimal getAvgLength() {
    return avgLength;
  }

  public void setAvgLength(BigDecimal avgLength) {
    this.avgLength = avgLength;
  }

  public StringFieldStat nullsCount(Long nullsCount) {
    this.nullsCount = nullsCount;
    return this;
  }

  /**
   * Get nullsCount
   * @return nullsCount
  */
  @NotNull
  @Schema(name = "nulls_count", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("nulls_count")
  public Long getNullsCount() {
    return nullsCount;
  }

  public void setNullsCount(Long nullsCount) {
    this.nullsCount = nullsCount;
  }

  public StringFieldStat uniqueCount(Long uniqueCount) {
    this.uniqueCount = uniqueCount;
    return this;
  }

  /**
   * Get uniqueCount
   * @return uniqueCount
  */
  @NotNull
  @Schema(name = "unique_count", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("unique_count")
  public Long getUniqueCount() {
    return uniqueCount;
  }

  public void setUniqueCount(Long uniqueCount) {
    this.uniqueCount = uniqueCount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    StringFieldStat stringFieldStat = (StringFieldStat) o;
    return Objects.equals(this.maxLength, stringFieldStat.maxLength) &&
        Objects.equals(this.avgLength, stringFieldStat.avgLength) &&
        Objects.equals(this.nullsCount, stringFieldStat.nullsCount) &&
        Objects.equals(this.uniqueCount, stringFieldStat.uniqueCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxLength, avgLength, nullsCount, uniqueCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class StringFieldStat {\n");
    sb.append("    maxLength: ").append(toIndentedString(maxLength)).append("\n");
    sb.append("    avgLength: ").append(toIndentedString(avgLength)).append("\n");
    sb.append("    nullsCount: ").append(toIndentedString(nullsCount)).append("\n");
    sb.append("    uniqueCount: ").append(toIndentedString(uniqueCount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

